<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "functions-transaction.php";
require_once "config.php";
require_once "DatabaseConnector.php";
require_once "ApiUserDao.php";
require_once "ApiUserService.php";
require_once "models/ApiUser.php";
require_once "TransactionDao.php";
require_once "services/TransactionService.php";
require_once 'utils/SQLFilter.php';


header('Content-type: application/json');

$databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
$apiUserService = new ApiUserService(new ApiUserDao($databaseConnector->getConnection()));

// We secure API
authenticateApiUser($apiUserService);

// Throw an error in case of missing parameters
if (!isset($_GET['LastID']) || !isset($_GET['userid'])) {
    header("HTTP/1.0 400 Bad Request");
    $errorResponse = array();
    $errorResponse["errorDescription"] = "mandatory parameters are missing. Please provide LastID and userid";
    echo json_encode($errorResponse);
    die("");
}

$id = $_GET['LastID'];
$userid = $_GET['userid'];


$transactionService = new TransactionService(new TransactionDao($databaseConnector->getConnection()));

$array = $transactionService->getTransactionsWithBiggerIdAndDifferentStoreId($id, $userid);
echo json_encode($array);

?>
