<?php

require_once 'dao/utils/SQLFilter.php';

class TransactionService {

    /**
     * @var TransactionDao
     */
    private $transactionDao;

    public function __construct($transactionDao) {

        $this->transactionDao = $transactionDao;
    }

    /**
     * We get the transactions with transactions.id is bigger
     * than the given id and store_id different from given StoreId
     *
     * @param int $id
     * @param string $storeId
     * @return Transaction []
     */
    public function getTransactionsWithBiggerIdAndDifferentStoreId($id, $storeId) {
        $transactions = $this->transactionDao->findAll((new SQLFilter("id > $id"))->andExpr("store_id != $storeId"));
        $transactionsDTO = array();
        foreach ($transactions as $transaction) {
            $transactionDTO = new stdClass();
            // the fields that we want from model
            $transactionDTO->id = $transaction->getId();
            $transactionDTO->customer_auto_id = $transaction->getCustomerAutoId();
            $transactionDTO->money = $transaction->getMoney();
            $transactionDTO->points = $transaction->getPoints();
            $transactionDTO->date = $transaction->getDate();
            $transactionDTO->by = $transaction->getBy();
            $transactionDTO->store_id = $transaction->getStoreId();
            $transactionDTO->notes = $transaction->getNotes();
            $transactionDTO->services = $transaction->getServices();
            $transactionDTO->giftcard_id = $transaction->getGiftCardId();
            $transactionDTO->giftcard_money = $transaction->getGiftCardMoney();
            $transactionsDTO[] = $transactionDTO;
        }
        return $transactionsDTO;
    }
}
