<?php

require_once('config.php');

// Set response headers
header("Content-Type: application/json; charset=UTF-8");
header("Pragma: no-cache");
header("Cache: no-cache");
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

try {
    // Connect to the database
    $pdo = new PDO($dsn, $db_user, $db_password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // SQL query to calculate total points for each customer
    $sql = "SELECT 
                customers.id AS customer_id, 
                customers.name AS customer_name, 
                SUM(transactions.points) AS total_points
            FROM customers
            LEFT JOIN transactions ON customers.id = transactions.customer_auto_id
            GROUP BY customers.id, customers.name";

    // Execute the query
    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Fetch results
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return the results as JSON
    echo json_encode([
        "success" => true,
        "data" => $results
    ]);
} catch (PDOException $e) {
    // Handle database connection or query errors
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ]);
    exit;
} catch (Exception $e) {
    // Handle any other errors
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ]);
    exit;
}

?>
