<?php
// Clover Launcher + OAuth handler

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

$code        = isset($_GET['code']) ? $_GET['code'] : null;
$merchant_id = isset($_GET['merchant_id']) ? $_GET['merchant_id'] : null;

function clover_token_exchange($code) {
    $url = clover_base_url() . '/oauth/v2/token';

    $data = http_build_query(array(
        'client_id'     => CLOVER_CLIENT_ID,
        'client_secret' => CLOVER_CLIENT_SECRET,
        'code'          => $code,
        'grant_type'    => 'authorization_code'
    ));

    $opts = array(
        'http' => array(
            'method'  => 'POST',
            'header'  => "Content-Type: application/x-www-form-urlencoded\r\n",
            'content' => $data
        )
    );

    $ctx = stream_context_create($opts);
    $resp = file_get_contents($url, false, $ctx);

    return json_decode($resp, true);
}

if ($code && $merchant_id) {
    $tokens = clover_token_exchange($code);

    if (!empty($tokens['access_token'])) {
        $stmt = $pdo->prepare("REPLACE INTO clover_merchants (merchant_id, access_token, updated_at) VALUES (?, ?, NOW())");
        $stmt->execute(array($merchant_id, $tokens['access_token']));
    }
}

?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>xLoyalty Clover</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body>
<h2>xLoyalty — Clover Integration</h2>

<p>Το Clover είναι συνδεδεμένο με το xLoyalty connector.</p>

<ul>
<li><a href="link_xloyalty.php">Σύνδεση λογαριασμού xLoyalty</a></li>
<li><a href="redeem_test.php">Δοκιμή εξαργύρωσης</a></li>
</ul>

</body>
</html>
