<?php

require_once('config.php');

// NowSMSDListExists - Returns true if distribution list exists, otherwise false.
// Parameters:
//  $dlistName - Distribution list name

function NowSMSDListExists($dlistName)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListAction=List&DListName=" . urlencode($dlistName);
    $response = file_get_contents($urlString);
    if (!strncasecmp($response, "OK", 2)) {
        return true;
    } else {
        return false;
    }

}

// NowSMSDListCheckMember - Returns true if member of distribution list, otherwise false.
// Parameters:
//  $dlistName - Distribution list name
//  $dlistMember - Distribution list member phone number

function NowSMSDListCheckMember($dlistName, $dlistMember)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListAction=List&DListName=" . urlencode($dlistName);
    $response = file_get_contents($urlString);

    $memberArray = explode("\r\n", $response);

    for ($i = 1; $i < count($memberArray); $i++) {
        $idxDash = strpos($memberArray[$i], " -");
        if ($idxDash !== false) {
            $memberArray[$i] = substr($memberArray[$i], 0, $idxDash);
        }
        if (!strcasecmp($memberArray[$i], $dlistMember)) {
            return true;
        }
    }

    return false;

}

// NowSMSDListCheckMember - Returns true if member of distribution list, otherwise false.
// Parameters:
//  $dlistName - Distribution list name
//  $dlistMember - Distribution list member phone number

function NowSMSDListMembers($dlistName)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListAction=List&DListName=" . urlencode($dlistName);
    $response = file_get_contents($urlString);

    $memberArray = array();

    foreach (explode("\r\n", $response) as $line) {
        if (strpos($line, $dlistName) === false && $line != "") {
            $memberArray[] = $line;
        }
    }

    return $memberArray;
}

// NowSMSDListAddMember - Add member to distribution list
// Parameters:
//  $dlistName - Distribution list name
//  $dlistMember - Distribution list member phone number

function NowSMSDListAddMember($dlistName, $dlistMember)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListMemberAction=Add&DListName=" . urlencode($dlistName) . "&DListMember=" . urlencode($dlistMember);
    $response = file_get_contents($urlString);
}

// NowSMSDListDeleteMember - Delete member from distribution list
// Parameters:
//  $dlistName - Distribution list name
//  $dlistMember - Distribution list member phone number

function NowSMSDListDeleteMember($dlistName, $dlistMember)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListMemberAction=Delete&DListName=" . urlencode($dlistName) . "&DListMember=" . urlencode($dlistMember);
    $response = file_get_contents($urlString);

}

// NowSMSDListDeleteMemberAllLists - Scan all distribution lists and remove member
// Parameters:
//  $dlistMember - Distribution list member phone number

function NowSMSDListDeleteMemberAllLists($dlistMember)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListAction=List";
    $response = file_get_contents($urlString);

    $dlistArray = explode("\r\n", $response);

    // Loop through all distribution lists and remove member
    for ($i = 0; $i < count($dlistArray); $i++) {
        if ($dlistArray[$i] != "") {
            if (NowSMSDListCheckMember($dlistArray[$i], $dlistMember)) {
                NowSMSDListDeleteMember($dlistArray[$i], $dlistMember);
            }
        }
    }
}

// NowSMSDListSendSMS - Send an SMS text message to a distribution list
// Parameters:
//  $dlistName - Distribution list name

function NowSMSDListSendSMS($dlistName, $smsText)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "PhoneNumber=" . urlencode($dlistName) . "&Text=" . urlencode($smsText);
    $response = file_get_contents($urlString);
    if (strpos($response, "MessageID=") === false) {
        return false;
    } else {
        return true;
    }

}

// NowSMSDListCreateList - Creates a distribution list
// Parameters:
//  $dlistName - Distribution list name

function NowSMSDListCreateList($dlistName)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListAction=Add" . "&DListName=" . $dlistName;
    $response = file_get_contents($urlString);
}

// NowSMSDListCreateList - Creates a distribution list
// Parameters:
//  $dlistName - Distribution list name

function NowSMSDListRemoveList($dlistName)
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListAction=Delete" . "&DListName=" . $dlistName;
    $response = file_get_contents($urlString);
}

// NowSMSDListAllLists - Scan all distribution lists and remove member
// Parameters:

function NowSMSDListAllLists()
{
    $urlString = "http://" . NOWSMSIP . ":" . NOWSMSPORT . "/DLists?";
    $urlString = $urlString . "User=" . urlencode(NOWSMSUSER) . "&Password=" . urlencode(NOWSMSPASS) . "&";
    $urlString = $urlString . "DListAction=List";
    $response = file_get_contents($urlString);

    $dlistArray = array();

    foreach (explode("\r\n", $response) as $line) {
        if ($line != "") {
            $dlistArray[] = $line;
        }
    }

    return $dlistArray;
}

function toDlistName($string) {
   $string = "loyalty-".greeklish($string);
   $strip = array("~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "=", "+", "[", "{", "]",
                   "}", "\\", "|", ";", ":", "\"", "'", "&#8216;", "&#8217;", "&#8220;", "&#8221;", "&#8211;", "&#8212;",
                   "â€”", "â€“", ",", "<", ".", ">", "/", "?");
   $clean = trim(str_replace($strip, "", strip_tags($string)));
   $clean = preg_replace('/\s+/', "-", $clean);
   if(function_exists('mb_strtolower'))
      return mb_strtolower($clean, 'UTF-8');
   return strtolower($clean);
}

function greeklish($string) {
   return strtr($string, array(
      'Α' => 'A', 'Β' => 'V', 'Γ' => 'G', 'Δ' => 'D', 'Ε' => 'E', 'Ζ' => 'Z', 'Η' => 'I', 'Θ' => 'TH', 'Ι' => 'I', 'Κ' => 'K', 'Λ' => 'L',
      'Μ' => 'M', 'Ν' => 'N', 'Ξ' => 'KS', 'Ο' => 'O', 'Π' => 'P', 'Ρ' => 'R', 'Σ' => 'S', 'Τ' => 'T', 'Υ' => 'Y', 'Φ' => 'F',
      'Χ' => 'X', 'Ψ' => 'PS', 'Ω' => 'O',
      'α' => 'a', 'β' => 'v', 'γ' => 'g', 'δ' => 'd', 'ε' => 'e', 'ζ' => 'z', 'η' => 'i',
      'θ' => 'th', 'ι' => 'i', 'κ' => 'k', 'λ' => 'l', 'μ' => 'm', 'ν' => 'n', 'ξ' => 'ks', 'ο' => 'o', 'π' => 'p', 'ρ' => 'r',
      'σ' => 's', 'τ' => 't', 'υ' => 'y', 'φ' => 'f', 'χ' => 'x', 'ψ' => 'ps', 'ω' => 'o', 'ς' => 's',
      'ά' => 'a', 'έ' => 'e', 'ή' => 'i', 'ί' => 'i', 'ό' => 'o', 'ύ' => 'y', 'ώ' => 'o',
      'ϊ' => 'i', 'ϋ' => 'y',
      'ΐ' => 'i', 'ΰ' => 'y'
   ));
}

?> 
