<?php
    header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

    require_once('config.php');
    require_once('auth.php');
    require('header.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo VIEW_OFFERS; ?></title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="styles.css">
    <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
    <script type="text/javascript">
        function editRow(id){
            document.getElementById('id').value = id;
            document.prizes.submit();
        }

        function deleteRow(id){
            if(confirm("Are you sure you want to delete the offer?\n\n")){
                document.getElementById('id').value = id;
                document.prizes.action='admin-delete-prize-exec.php';
                document.prizes.submit();
            }
        }
    </script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
</head>

<body>
<?php headerDiv(); ?>

<div class="container mt-5 main">
    <h1 class="text-center"><?php echo VIEW_OFFERS; ?></h1>

    <form method="post" name="prizes" id="prizes" action="admin-edit-prize-form.php">
        <input type="hidden" name="id" value="" id="id" />

        <div class="table-responsive">
            <table class="table table-striped table-bordered text-center">
                <thead class="thead-dark">
                    <tr>
                        <?php if ($_SESSION['SESS_ADMIN'] == "y") { ?>
                            <th><?php echo ACTIONS; ?></th>
                        <?php } ?>
                        <th><?php echo POINTS; ?></th>
                        <th><?php echo FROM; ?></th>
                        <th><?php echo TO; ?></th>
                        <th><?php echo MESSAGE; ?></th>
                        <th><?php echo MEMBER_CATEGORY; ?></th>
                        <th><?php echo SMS; ?></th>
                        <th><?php echo STATUS; ?></th>
                        <th><?php echo REDEMPTIONS; ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        $link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
                        if(!$link) {
                            die(ERROR_DATABASE_CONNECTION_FAILURE);
                        }
                        $db = mysql_select_db(DB_DATABASE);
                        if(!$db) {
                            die("Unable to select database");
                        }
                        mysql_query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'", $link)
                            or die(mysql_error());

                        $result = mysql_query("SELECT p.*, COUNT(c.id) AS checkouts FROM prizes AS p LEFT JOIN checkouts AS c ON c.prize_auto_id = p.id AND c.received = 'y' GROUP BY p.id ORDER BY prize_points ASC ")
                            or die(mysql_error());

                        while($row = mysql_fetch_array($result)) {
                            echo '<tr>';
                            if ($_SESSION['SESS_ADMIN'] == "y") {
                                echo '<td>
                                    <button type="button" class="btn btn-primary btn-sm" onclick="editRow('.$row['id'].')">Edit</button>
                                    <!--<button type="button" class="btn btn-danger btn-sm" onclick="deleteRow('.$row['id'].')">Delete</button>-->
                                </td>';
                            }
                            $state = "Active";
                            if(strtotime($row['from_date']) > time()) {
                                $state = "Inactive (future)";
                            }
                            if(strtotime($row['till_date']) < time()) {
                                $state = "Inactive (expired)";
                            }
                            echo '
                                <td>'.$row['prize_points'].'</td>
                                <td>'.date("d/m/Y", strtotime($row['from_date'])).'</td>
                                <td>'.date("d/m/Y", strtotime($row['till_date'])).'</td>
                                <td>'.$row['prize_msg'].'</td>
                                <td>';
                            if(is_null($row['customer_custom'])) {
                                echo "All";
                            }
                            else {
                                for ($i = 1; $i <= CUSTOM_FIELDS_NUM; $i++) {
                                    if($row['customer_custom'] == $i) {
                                        echo $_SESSION['SESS_CUSTOM_FIELD' . $i];
                                    }
                                }
                            }
                            echo '</td>
                                <td>'.($row['sms_notify'] ? "Yes" : "No").'</td>
                                <td>'.$state.'</td>
                                <td>'.$row['checkouts'].'</td>
                            </tr>';
                        }
                    ?>
                </tbody>
            </table>
        </div>

        <?php if ($_SESSION['SESS_ADMIN'] == "y") { ?>
        <div class="text-center mt-4">
            <button type="button" class="btn btn-success" onclick="window.location.href='admin-new-prize-form.php'">
                <i class="fas fa-gift"></i> <?php echo NEW_OFFER; ?>
            </button>
            <button type="button" class="btn btn-info" onclick="window.location.href='promotion-form.php'">
                <i class="fas fa-bullhorn"></i> <?php echo NEW_PROMOTION_MISSION; ?>
            </button> (<?php echo FOR_THOSE_WITH_WALLET_APP; ?>)
        </div>
        <?php } ?>

    </form>

    <p class="text-center mt-3"><?php echo 'Total number of offers: '.mysql_num_rows($result); ?></p>
</div>


<pre>
    
    
</pre>
</body>
</html>
