<?php
header("Pragma: no-cache");
header("Cache: no-cache");
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

require_once('config.php');
require_once('auth.php');
require('header.php');
require_once ("DatabaseConnector.php");
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
echo '<h1>' . HEADER_CUSTOMER_REGISTRATION_STATS . '</h1>';
<link href="styles.css" rel="stylesheet" type="text/css" />
<link href="calendar.css" type="text/css" rel="stylesheet" />
<script type="text/javascript">
	function printDiv(){
		var content = document.getElementById("printable");
		var pri = document.getElementById("printwindow").contentWindow;
		pri.document.open();
		pri.document.write('<div><img src="images/logo.png" /><br /><br />');
		pri.document.write(content.innerHTML);
		pri.document.write('<br /></div>');
		pri.document.close();
		pri.focus();
		pri.print();
	}
</script>
<script src="calendar.js" type="text/javascript"></script>
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
</head>

<body>
<?php headerDiv();?>


<div class="main">
<?php echo '<h1>' . HEADER_CUSTOMER_REGISTRATION_STATS . '</h1>';  ?>

	<?php 
        
		$customer_id = $_POST['customer_id'];
		$customer_name = $_POST['customer_name'];
		
		if($customer_id == ''){
			echo ERROR_NO_CUSTOMER_SELECTED;
			exit();
		}
	?>

<form method="post" action="view-customer-registration-statistics.php" style="margin:20px;">
    <input type="hidden" name="customer_name" size="20" value="<?php echo $customer_name; ?>"/>
    <input type="hidden" name="customer_id" size="20" value="<?php echo $customer_id; ?>"/>
 <!--    <table cellspacing="0">
        <tr><td colspan="2">Ημ/νία συναλλαγών:</td></tr>
        <tr>
            <td>Από : </td>
            <td>
                <input type="text" size="8" name="from_date" id="from_date" value="<?php
                if (!isset($_POST['from_date']))
                    echo date("Y-m-d");
                else
                    echo $_POST['from_date']
                    ?>"/>
                <script type="text/javascript"> calendar.set("from_date");</script>
            </td>
            <td rowspan="3" style="padding-left:20px;">
                <button type="submit" class="styled">
                    <img src="images/refresh.png" class="icon" /> Ανανέωση
                </button>
            </td>
        </tr>
        <tr>
            <td>Έως : </b></td>
            <td>
                <input type="text" size="8" name="till_date" id="till_date" value="<?php
                       if (!isset($_POST['till_date']))
                           echo date("Y-m-d");
                       else
                           echo $_POST['till_date']
                           ?>"/>
                <script type="text/javascript"> calendar.set("till_date");</script>
            </td>
        </tr>

    </table> -->
</form>

<?php
if (isset($_POST['from_date']))
    $from_date = $_POST['from_date'] . " 00:00:01";
else
    $from_date = date("Y-m-d") . " 00:00:01";
if (isset($_POST['till_date']))
    $till_date = $_POST['till_date'] . " 23:59:59";
else
    $till_date = date("Y-m-d") . " 23:59:59";
$when = " AND transactions.date >=:from_date  AND transactions.date < :till_date";

$customerstore = "";
$transactionstore = "";
if ($_SESSION['SESS_ADMIN'] != "y") {
    $customerstore = " AND customers.signup_store = " . $_SESSION['SESS_STORE_AUTO_ID'];
    $transactionstore = " AND transactions.store_id = " . $_SESSION['SESS_STORE_AUTO_ID'];
}


try {
    $databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
    $pdo = $databaseConnector->getConnection();
    $pdo->exec('set names utf8');

    $customer_id = $_POST['customer_id'];
    $customer_name = $_POST['customer_name'];


    $id_from_customer_query = "SELECT id "
            . " FROM customers "
            . " WHERE customer_id =  :customer_id";


    $sth = $pdo->prepare($id_from_customer_query);
    $sth->bindParam(':customer_id', $customer_id, PDO::PARAM_INT);
    $sth->execute();

    $row = $sth->fetch();
    $id_from_customers_table = $row['id'];

    $qry = "SELECT customers.name as name,customers.surname as surname ,customers.customer_id,customers.signup_date as signup_date, "
            . "            store_id,total_points, ref_total_points, ref_total_money \n"
            . "FROM customers JOIN (SELECT sum(points) as total_points, transactions.notes\n"
            . "	  	     FROM (customers JOIN transactions ON customers.id = transactions.customer_auto_id)\n"
            . "	  	     WHERE customers.id = :customer_id \n"
            . "	             GROUP BY notes) AS REF_TRANS \n"
            . "      	       ON customers.customer_id = CONVERT(REPLACE(REF_TRANS.notes, \"Πόντοι σύστασης από \", \"\"), UNSIGNED)\n"
            . "               JOIN (SELECT customers.id as cid, sum(points) as ref_total_points, sum(money) as ref_total_money, stores.store_id\n"
            . "           	     FROM customers JOIN transactions ON customers.id = transactions.customer_auto_id\n"
            . "            	     JOIN stores ON customers.signup_store = stores.id\n"
            . "           	     GROUP BY customer_id) AS REF_TOTALS\n"
            . "      	       ON customers.id = REF_TOTALS.cid";

    $sth = $pdo->prepare($qry);

    $sth->bindParam(':customer_id', $id_from_customers_table);
   // $sth->bindParam(':from_date', $from_date);
    //$sth->bindParam(':till_date', $till_date);
    $sth->execute();

    $totalCustomers = $sth->rowCount();

    echo '<p class="main">' . LABEL_CUSTOMER_RECORDS . ' ' . $customer_id . ' ' . $customer_name . '</p>';
   echo '<div id="printable">
        <table class="main" cellspacing="0">
            <tr style="font-weight:bold;text-align:center;">
                <td class="">' . NUMBER . '</td>
                <td class="leftborder">' . SURNAME . '</td>
                <td class="leftborder">' . NAME . '</td>
                <td class="leftborder">' . REGISTRATION_DATE . '</td>
                <td class="leftborder">' . LABEL_REGISTRATION_STORE . '</td>
            </tr>
        </table>
    </div>';

    if ($_SESSION['SESS_ADMIN'] == "y") {
        echo '<td class="leftborder"><?= TURNOVER_FROM_STORE_TRANSACTIONS ?></td>';
    }
    echo '<td class="leftborder"><?= POINTS_FROM_STORE_TRANSACTIONS ?></td>';
    if (REFERRAL_BONUS) {
        echo "<td class='leftborder'><?= PROFIT_POINTS_ENTITLED ?></td>";
    }
    echo '<td><?= LEVEL ?></td></tr>';

    $counter = 0;
    $sum_total_points = 0;
    $total_money = 0;
    while ($row = $sth->fetch()) {
        if ($counter == 0) {
            $column = "even";
            $counter++;
        } else {
            $column = "odd";
            $counter = 0;
        }

        $customer_id = $row['customer_id'];
        $surname = $row['surname'];
        $name = $row['name'];
        $signup_date = $row['signup_date'];
        $store_id = $row['store_id'];
        $ref_total_money = $row['ref_total_money'];
        $total_points = $row['total_points'];
        $ref_total_points = $row['ref_total_points'];
        $level = ($ref_total_money / $total_points ) * $_SESSION['SESS_REFERRALMONEYPOINTS'];
        

        echo '
				<tr class="';
        echo $column;
        echo '" >
					<td class="">' . $customer_id . '</td>
					<td class="leftborder">' . $surname . '</td>
					<td class="leftborder">' . $name . '</td>
					<td class="leftborder center">' . date("d/m/Y", strtotime($signup_date)) . '</td>
					<td class="leftborder">' . $store_id . '</td>
                                        <td class="leftborder">' . $ref_total_money . '</td> ';

        if ($_SESSION['SESS_ADMIN'] == "y") {

            echo '<td class="leftborder center">' . $ref_total_points . '</td>';
        }

        if (REFERRAL_BONUS) {
            echo '	<td class="leftborder center">' . $total_points . '</td>';
        }
        echo ' <td class="leftborder">' . $level . '</td></tr>';
        $sum_total_points += $total_points;
        $total_money += $ref_total_money;
    }
    echo '</table>';

    echo '<p class="main">';
    echo '<p><?= WHEN_TURNOVER_IS_ZERO ?></p>';
    echo '<?= REGISTRATIONS ?> : ' . $totalCustomers . '<br />';
    if ($_SESSION['SESS_ADMIN'] == "y") {
        echo '<?= TURNOVER ?> : ' . $total_money . ' €<br />';
    }
    echo '	<?= TOTAL_POINTS ?> : ' . $sum_total_points . '<br />';

    echo '	 </p>';
} catch (Exception $e) {
    echo "Failed: " . $e->getMessage();
}
?>
