<?php

/**
 * Κλάση για διευκόλυνση σύνδεσης με το Google URL shorten API
 */
class GoogleUrl {

    /**
     * Το url του API 
     * @var type string
     */
    private $api_url = "https://www.googleapis.com/urlshortener/v1/url";

    /**
     * Κατασκευαστής που δέχεται ως παράμετρο το api key που έχουμε πάρει
     * από λογαριασμό που έχουμε φτιάξει στην google, φτιάχνοντας project
     * που χρησιμοποιεί το Google URL shorten API 
     * 
     * @param string $api_key
     */
    function __construct($api_key) {
        $this->api_url = $this->api_url."?key=".$api_key;
    }

    /**
     * Short Long URL
     * @param string $url το μεγάλο URL
     * @return string μικρό URL ή void
     */
    public function encode($url) {
        $data = $this->cURL($url, true);
        return isset($data->id) ? $data->id : '';
    }

    /**
     * Extend Short URL
     * @param string $url το μικρό URL
     * @return string το μεγάλο URL ή void 
     */
    public function decode($url) {
        $data = $this->cURL($url, false);
        return isset($data->longUrl) ? $data->longUrl : '';
    }

    /**
     * κάνει cURL αίτημα
     * @param string $url
     * @param bool $post
     * @return object
     */
    private function cURL($url, $post = true) {
        # create cURL
        $ch = curl_init();
        # POST request for URL shorten
        if ($post) {
            curl_setopt($ch, CURLOPT_URL, $this->api_url);
            # set header content type for json
            curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json') );
            # set request method post
            curl_setopt($ch, CURLOPT_POST, true);
            # send json encoded request
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array('longUrl' => $url)));
        }
        # GET request for URL extend
        else {
            curl_setopt($ch, CURLOPT_URL, $this->api_url . '&shortUrl=' . $url);
        }
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        #curl_setopt( $ch, CURLOPT_BINARYTRANSFER, true );
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        # execute curl request
        $json = curl_exec($ch);
        # close cURL connection
        curl_close($ch);
        # return response as object
        return (object) json_decode($json);
    }

}

?>