<?php

require_once 'Payment3DSService.php';
require_once __DIR__ . '/../../libs/net2020/stripe-sdk/init.php';
require_once __DIR__ . '/../../libs/net2020/stripe-sdk/stripe-config.php';

/**
 * The stripe payment 3DS flow.
 */
class StripePayment3DSService implements Payment3DSService
{
    public function __construct()
    {
        // Δεν βασιζόμαστε πλέον σε session για payment_intent,
        // αλλά δεν πειράζει αν υπάρχει ενεργή session.
        if (session_id() === '') {
            session_start();
        }
    }

    /**
     * Δημιουργεί Stripe Checkout Session και κάνει redirect.
     * ΔΕΝ γράφει πλέον payment_intent στο $_SESSION.
     */
    public function requestPayment($amount, $successUrl, $cancelUrl)
    {
        $stripe = new \Stripe\StripeClient(STRIPE_CLIENT_SECRET);

        // Αν δεν υπάρχει ήδη query string στο successUrl, βάζουμε ?session_id=...
        // Αλλιώς προσθέτουμε &session_id=...
        if (strpos($successUrl, '?') === false) {
            $successUrlWithSession = $successUrl . '?session_id={CHECKOUT_SESSION_ID}';
        } else {
            $successUrlWithSession = $successUrl . '&session_id={CHECKOUT_SESSION_ID}';
        }

        $session = $stripe->checkout->sessions->create(array(
            'success_url' => $successUrlWithSession,
            'cancel_url'  => $cancelUrl,
            'line_items'  => array(
                array(
                    'price_data' => array(
                        'currency'     => 'eur',
                        'unit_amount'  => $amount, // π.χ. 7000 = 70.00 EUR
                        'product_data' => array(
                            'name' => 'Loyalty Services'
                        )
                    ),
                    'quantity' => 1,
                ),
            ),
            'payment_intent_data' => array(
                'capture_method' => 'manual'
            ),
            'mode' => 'payment',
        ));

        header("Location: " . $session->url);
        exit;
    }

    /**
     * Κάνει capture του PaymentIntent βασισμένο στο Stripe Checkout Session ID
     * που έρχεται ως ?session_id=... στο URL.
     */
    public function makeTheActualCharge($amount, $account)
    {
        if (session_id() === '') {
            session_start();
        }

        if (!isset($_GET['session_id']) || $_GET['session_id'] === '') {
            throw new Exception('Missing Stripe Checkout session_id in URL.');
        }

        $checkoutSessionId = $_GET['session_id'];

        $stripe = new \Stripe\StripeClient(STRIPE_CLIENT_SECRET);

        // Παίρνουμε το Checkout Session από τη Stripe
        $checkoutSession = $stripe->checkout->sessions->retrieve($checkoutSessionId, array());

        if (!isset($checkoutSession->payment_intent) || !$checkoutSession->payment_intent) {
            throw new Exception('No payment_intent found in Checkout Session.');
        }

        $paymentIntentId = $checkoutSession->payment_intent;

        // Τώρα μπορούμε να κάνουμε retrieve + capture
        $paymentIntent = $stripe->paymentIntents->retrieve($paymentIntentId, array());

        // Αν ήδη είναι succeeded (π.χ. μέσω άλλης ροής)
        if ($paymentIntent->status === 'succeeded') {
            // προχωράς απλά στη λογική μετά την πληρωμή
        } else {
            // Manual capture
            $paymentIntent = $paymentIntent->capture();

            if ($paymentIntent->status !== 'succeeded') {
                throw new Exception('Could not confirm the payment!');
            }
        }

        // Optional: ενημέρωση description
        $stripe->paymentIntents->update(
            $paymentIntent->id,
            array(
                'description' => 'Net2020 loyalty services'
            )
        );

        // Εδώ μπορείς να χρησιμοποιήσεις $account, $amount κτλ
        // π.χ. να γράψεις log / transaction στη δική σου βάση
    }
}
