<?php

require_once 'dao/utils/SQLFilter.php';

class SmsHistoryService {
    
    /**
     * @var SmsHistoryDao 
     */
    private $smsHistoryDao;
    
    public function __construct($smsHistoryDao) {

        $this->smsHistoryDao = $smsHistoryDao;
    }
    
    /**
     * Whether there are new inbox messages
     * for the given phone number
     * 
     * @param string $phone
     * @return boolean if there are new inbox messages
     */
    public function haveNewInbox($phone) {
        
        $inboxMessages = $this->smsHistoryDao->findAll((new SQLFilter("recipients = $phone"))->andExpr("isRead = 0"));
        return count($inboxMessages) > 0;
    }
    
    public function markAllAsRead($phone) {
        
        $this->smsHistoryDao->markAllAsRead($phone);
    }
}
