<?php

/**
 * A payment service to provide a secure 3DS based payment flow.
 * 
 * @author Kyriakopoulos George
 */
interface Payment3DSService {
    
    /**
     * Requests a user to pay and redirects him after confirming 
     * that is willing to pay.
     * 
     * @param number $amount The amount to request
     * @param string $successUrl The redirect URL
     * @param string $cancelUrl The redirect URL
     * 
     * @return void
     * 
     */
    public function requestPayment($amount, $successUrl, $cancelUrl);
    
    /**
     * After the required payment is confirmed, then the payment is charged.
     * 
     * @param number $amount The amount accepted to charge.
     * @param Account $account The loyalty account that the payment is charged to.
     * 
     * @return void
     * 
     */
    public function makeTheActualCharge($amount, $account);
}
