<?php

require_once 'dao/utils/SQLFilter.php';

class CustomerService {

    /**
     * @var CustomerDao
     */
    private $customerDao;

    public function __construct($customerDao) {

        $this->customerDao = $customerDao;
    }

    /**
     * We get the customers that customers.id is bigger.
     * from the given id
     *
     * @param string $id
     * @return Customer []
     */
    public function getCustomersWithBiggerId($id,$storeid ) {

        $customers= $this->customerDao->findAll((new SQLFilter("id > $id"))->andExpr("signup_store != $storeid"));
        $customersDTO = [];
        foreach ($customers as $customer) {
            $customerDTO = new stdClass();
            // the fields that we want from the models
            $customerDTO->id = $customer->getId();
            $customerDTO->name = $customer->getName();
            $customerDTO->customerId = $customer->getCustomer_id();
            $customerDTO->surname = $customer->getSurname();
            $customerDTO->phone = $customer->getPhone();
            $customerDTO->street = $customer->getStreet();
            $customersDTO[] = $customerDTO;
        }
        return $customersDTO;
    }

}
