<?php

require_once 'auth.php';
require_once 'config.php';
require_once 'header.php';
require_once 'DatabaseConnector.php';
require_once 'functions-transaction.php';

$title = CATEGORY_SETTINGS;

if(isset($_POST['services'])) {
    $services = secureInput($_POST['services']);
    
    try {
        
        $databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
        $pdo = $databaseConnector->getConnection();

        $pdo->exec("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'");
        
        $sql = 'UPDATE settings SET value = :services WHERE setting = "services"';
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(":services", $services);

        $stmt->execute();

        $_SESSION['SESS_SERVICES'] = $services;
        
    } catch (Exception $ex) {
        die("Database error");
    }

}

$categorizedServices = getCategorizedServices($_SESSION['SESS_SERVICES']);

$categories = array_keys($categorizedServices);

require_once 'services-settings-view.php';
