<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Scan Receipt with Camera</title>
    <script src="https://cdn.jsdelivr.net/npm/tesseract.js@2.1.1/dist/tesseract.min.js"></script>
</head>
<body>
    <video id="video" width="640" height="480" autoplay></video>
    <button id="capture">Capture Image</button>
    <canvas id="canvas" width="640" height="480" style="display:none;"></canvas>
    <button id="send">Read Text</button>
    <div id="ocr_result">OCR Text will appear here...</div>

    <script>
        const video = document.getElementById('video');
        const canvas = document.getElementById('canvas');
        const context = canvas.getContext('2d');
        const captureButton = document.getElementById('capture');
        const sendButton = document.getElementById('send');
        const ocrResultElement = document.getElementById('ocr_result');

        // Get access to the camera
        if (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
            navigator.mediaDevices.getUserMedia({ video: { facingMode: "environment" } })
                .then(function(stream) {
                    video.srcObject = stream;
                    video.play();
                })
                .catch(function(error) {
                    console.error("Error accessing the camera.", error);
                    ocrResultElement.innerHTML = 'Error accessing the camera: ' + error.message;
                });
        }

        captureButton.onclick = function() {
            canvas.style.display = 'block';
            context.drawImage(video, 0, 0, 640, 480);
        };

        sendButton.onclick = function() {
            canvas.toBlob(function(blob) {
                if (!blob) {
                    ocrResultElement.innerHTML = 'Failed to capture blob from canvas.';
                    return;
                }
                Tesseract.recognize(
                    blob,
                    'eng',
                    { logger: m => console.log(m) }
                ).then(({ data: { text } }) => {
                    console.log('OCR Text:', text);
                    if (text) {
                        ocrResultElement.innerHTML = text.replace(/\n/g, '<br>');
                    } else {
                        ocrResultElement.innerHTML = 'No text recognized.';
                    }
                }).catch(e => {
                    console.error('Error during OCR processing:', e);
                    ocrResultElement.innerHTML = "Error in OCR processing: " + e.message;
                });
            }, 'image/jpeg');
        };
    </script>
</body>
</html>
