<?php

header("Pragma: no-cache");
header("Cache: no-cache");
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

require_once ('auth.php');
require_once ('config.php');
require_once ('admin.php');
require_once ('header.php');

require_once ('DatabaseConnector.php');
require_once('Dao.php');

$title = "Διαχείριση των promotion";
$homePageActive = ""; // css κανόνας
$sendPushNotificationActive = "";
$myVisitorsActive = "";

//Σύνδεση στην βάση
$connector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
$mysqlConnection = $connector->getConnection();
$dao = new Dao($mysqlConnection);


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title>Αποστολή push</title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="https://toert.github.io/Isolated-Bootstrap/versions/4.0.0-beta/iso_bootstrap4.0.0min.css">



<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="Cache-Control"
	content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">

</head>

<body>
	
<?php headerDiv();?> 



<main class="bootstrap container" style="margin-top:10px;">
<div class="row">
        <div class="col-12"><h1>Τα promotion μου</h1></div>
        <div class="col-12">
            <?php 
            if(isset($_GET['message'])) {
                $message = $_GET['message'];
                ?>
            <div class="alert alert-success" role="alert">
                <?=$message?>
            </div>
            
            <?php
            }
            ?>




<button class="btn btn-success" data-toggle="collapse" data-target="#addPromotion">Εισαγωγή νέου promotion</button>
<div id="addPromotion" class="collapse alert alert-success" style = "margin-top:10px">
    <form  action="promotion-service.php" method="post">
    
        <div class="form-group">
            <label for="promotionTitle">Τίτλος του promotion</label>
            <input type="text" class="form-control" id="promotionTitle" name="promotionTitle">
        </div>
        <div class="form-group">
            <label for="promotionBody">Κείμενο</label>
            <textarea class="form-control" id="promotionBody" rows="5" name="promotionBody"></textarea>
        </div>
        <div class="form-group">
            <div class="alert alert-danger" role="alert">
                Ημερομηνία λήξης
            </div>
            Μέχρι <input  name="expireDate" type="date"><br>
            
            <input style="margin-top:15px" type="submit" class="btn btn-primary" value="Αποθήκευση">
        </div>
 </form>
</div>
<button class="btn btn-primary" data-toggle="collapse" data-target="#showPromotion">Εμφάνιση των promotion</button>
<div id="showPromotion" class="collapse" style = "margin-top:10px">
<table id="index_table" class="table table-dark table-hover table-responsive-sm">
        <thead>
            <tr>
                <th scope="col"></th>
                <th scope="col">Τίτλος promotion</th>
                <th scope="col">Κείμενο</th>
                <th scope="col">Λήξη του promotion</th>
                <th scope="col">Ενέργειες</th>
             </tr>
        </thead>
        <tbody>

        </tbody>
        <?php 
             $index = 1;
             
             $promotions = $dao->getPromotions();
            foreach ($promotions as $promotion) {    
        ?>
            <tr>
                 <th scope="row"><?=$index?></th>
                    <td><?=$promotion->getTitle();?></td>
                    <td><?=$promotion->getBody();?></td>
                    <td>
                        <?php
                            if($promotion->getExpireDate()=="0000-00-00"){
                                echo "-";
                            }
                            else {
                                echo $promotion->getExpireDate();
                            }
                        ?>
                    </td>
                    <td><a class="nounderline" href="promotion-service.php?promotionID=<?=$promotion->getId()?>"><button type="button" class="btn btn-danger  btn-sm">Διαγραφή</button></a></td>
                
            </tr>
        <?php 
            $index++;} 
         ?>
</table>
 

</div>






</main>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
</body>
</html>
