<?php

if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) {
    die('Direct access not allowed');
    exit();
  }
    require_once('config.php');
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
            <!-- Required meta tags -->
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

            <!-- Bootstrap CSS -->
            <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css" integrity="sha384-9aIt2nRpC12Uk9gS9baDl411NQApFmC26EwAOH8WgZl5MYYxFfc+NcPb1dKGj7Sk" crossorigin="anonymous">

<title><?php echo TIMOKATALOGOS; ?></title>
        <style>
            .text-center {
                text-align : center;
            }
            .loyalty{
                background-color : #d6f6ff;
                margin-bottom : 2em;
                padding-bottom : 4em;
                padding-top : 1.5em;
                border-radius: 25px;
            }
            .sms {
                background-color : #b5f9b4;
                margin-bottom : 2em;
                padding-bottom : 4em;
                padding-top : 1.5em;
                border-radius: 25px;
            }
            .mb-2em{
                margin-bottom : 2em;
            }
            .mb-3 {
                margin-bottom : 3em;
            }
            .mb-4 {
                margin-bottom : 4em; 
            }
            .shadow {         
                padding: 10px;
                box-shadow: 5px 10px 8px #888888;
            }
            
            input[type=number]::-webkit-inner-spin-button, 
            input[type=number]::-webkit-outer-spin-button {
              -webkit-appearance: none;
              margin: 0;
            }
            
        </style>
    </head>

    <body>
        <div class="bootstrap">
            <div class="container">
                
            <!-- Τιμοκατάλογος Loyalty start -->
                <div class = "row loyalty shadow">
                    <div class = "col-12">
                        <div class="col-12 mb-2em">
                            <h3 class = "text-center"><?php echo TIMOKATALOGOS; ?></h3>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="card-deck mb-3 text-center">
                        <?php foreach($loyaltyPrices as $loyaltyPrice): ?>
                            <div class="card mb-4 shadow">
                                <div class="card-header">
                                    <h4 class="my-0 font-weight-normal"><?php echo ANANEOSI_PAKETOY; ?>
 <?=$loyaltyPrice->getPeriod();?> 
                                    <?php
                                        if ($loyaltyPrice->getPeriod() == 1) {
                                            echo "<br>μήνα";
                                        } else {
                                            echo "<br>μηνών";
                                        }
                                    ?>
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <h1 class="card-title pricing-card-title"><?=$loyaltyPrice->getPrice();?>&euro;</h1>
                                    <ul class="list-unstyled mt-3 mb-4">
                                        <li><?php echo ANANEOSI_PAKETOY; ?></li>
                                    </ul>
                                    <a href="payment-request.php?id=<?=$loyaltyPrice->getId()?>&type=loyalty" class="btn btn-lg btn-block btn-primary"><?php echo PLIROMI; ?></a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <!-- Τιμοκατάλογος Loyalty end -->
            <hr/>
            <!-- Τιμοκατάλογος sms start -->
                <div class = "row sms shadow">
                    <div class="col-12 mb-2em">
                        <h3 class = "text-center"><?php echo TIMOKATALOGOS_SMS; ?></h3>
                    </div>

                    <div class="col-12">
                        <div class="card-deck mb-3 text-center">
                        <?php foreach($smsPrices as $smsPrice): ?>
                            <div class="card mb-4 shadow">
                                <div class="card-header">
                                    <h4 class="my-0 font-weight-normal"><?php echo ANANEOSI_PAKETOY_SMS; ?> <?=$smsPrice->getAmount();?> (msgs)</h4>
                                </div>
                                <div class="card-body">
                                    <h1 class="card-title pricing-card-title"><?=$smsPrice->getPrice();?>&euro;</h1>
                                    <ul class="list-unstyled mt-3 mb-4">
                                        <li><?php echo ANANEOSI_PAKETOY_SMS; ?></li>
                                    </ul>
                                    <a href="payment-request.php?id=<?=$smsPrice->getId()?>&type=sms" class="btn btn-lg btn-block btn-primary"><?php echo PLIROMI; ?></a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <!-- Τιμοκατάλογος sms end -->   
        </div>
        
        <?php
// Στοιχεία σύνδεσης στη βάση newmedia_account_manager
define('DB_HOST1', 'localhost');
define('DB_USER1', 'newmedia_creditsview');
define('DB_PASSWORD1', 'Marios89*'); // Αντικατάστησε το με τον κωδικό
define('DB_DATABASE1', 'newmedia_account-manager');

// Σύνδεση με τη βάση δεδομένων
$conn = new mysqli(DB_HOST1, DB_USER1, DB_PASSWORD1, DB_DATABASE1);

// Έλεγχος σύνδεσης
if ($conn->connect_error) {
    die("Σφάλμα σύνδεσης: " . $conn->connect_error);
}

// Παράμετρος SMS_SENDER_ID
$sms_sender_id = 'demonet'; // Αντικατέστησέ το με την πραγματική τιμή

// Βήμα 1: Εύρεση account.id από τον πίνακα account
$sql_account = "SELECT id FROM account WHERE sender = ?";
$stmt_account = $conn->prepare($sql_account);
if (!$stmt_account) {
    die("Σφάλμα SQL: " . $conn->error);
}
$stmt_account->bind_param("s", $sms_sender_id);
$stmt_account->execute();
$stmt_account->bind_result($account_id);
$stmt_account->fetch();
$stmt_account->close();

if (!empty($account_id)) {
    // Βήμα 2: Υπολογισμός συνολικών θετικών credits
    $sql_credits = "SELECT SUM(credits) AS total_credits FROM credits WHERE accountid = ? AND credits > 0";
    $stmt_credits = $conn->prepare($sql_credits);
    if (!$stmt_credits) {
        die("Σφάλμα SQL: " . $conn->error);
    }
    $stmt_credits->bind_param("i", $account_id);
    $stmt_credits->execute();
    $stmt_credits->bind_result($total_credits);
    $stmt_credits->fetch();
    $stmt_credits->close();

    echo "<div class='row sms shadow'>";
    echo "<div class='col-12 mb-2em'>";
    echo "<h3 class='text-center'>Ιστορικό Πιστώσεων</h3>";
    echo "</div>";
    echo "<div class='col-12'>";
    echo "<div class='card-deck mb-3 text-center'>";
    echo "<table class='table'>";
    echo "<thead><tr><th>Ημερομηνία</th><th>Credits</th></tr></thead>";
    echo "<tbody>";

    // Βήμα 3: Εμφάνιση αναλυτικών εγγραφών
    $sql_history = "SELECT crdate, credits FROM credits WHERE accountid = ? AND credits > 0";
    $stmt_history = $conn->prepare($sql_history);
    if (!$stmt_history) {
        die("Σφάλμα SQL: " . $conn->error);
    }
    $stmt_history->bind_param("i", $account_id);
    $stmt_history->execute();
    $stmt_history->bind_result($crdate, $credits);

    while ($stmt_history->fetch()) {
        echo "<tr>";
        echo "<td>" . $crdate . "</td>";
        echo "<td>" . $credits . "</td>";
        echo "</tr>";
    }

    echo "</tbody>";
    echo "</table>";
    echo "</div>";
    echo "</div>";
    echo "</div>";

    $stmt_history->close();
} else {
    echo "Δεν βρέθηκε λογαριασμός για το SMS_SENDER_ID.";
}

// Κλείσιμο σύνδεσης
$conn->close();
?>


?>

        
        <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
   </body>
<html>