<?php
	header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    
	require_once('config.php');
	require_once('auth.php');
	require('header.php');
    require_once('sendSMS.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title><?php echo TITLE_FAST_TRANSACTION; ?></title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<style type="text/css">
    input[type="radio"]:checked + label {
        font-weight: bold;
    }
</style>
<script language="JavaScript" src="form_validator.js"
    type="text/javascript" xml:space="preserve"></script>
<script type="text/javascript">
    var checkHappened = false;

	function confirmDialog(moneypoints, visitpoints){
		document.getElementById('list').value = document.forms["transaction"]["phone"].value;
		if(document.getElementById('list').value == 0){
			alert("Δεν έχετε επιλέξει κάποιον πελάτη!");
			return false;
		}

		var question = "Είστε σίγουρος για τη συναλλαγή;\n\n";
		var name = document.getElementById('list').options[document.getElementById('list').selectedIndex].innerHTML;
		var money = document.forms["transaction"]["money"].value;
		var points = money*moneypoints+visitpoints;
		points = +points.toFixed(2);

        if(!checkHappened) {
            checkAvailableCheckouts(points);
            return false;
        }

		var text = "Θα προστεθούν "+points+" πόντοι στο χρήστη "+name;
		var message = question+text;
		return confirm(message);
/*
		if(confirm(message)){
			if(document.getElementById('redirect').checked == true){
				document.transaction.action='new-transaction-exec-quick.php'
			}
			return true;
		}
		else{
			return false;
		}
*/
	}
	function setCellValue(){
		document.forms["transaction"]["phone"].value = document.getElementById('list').value;
        setNoCheck();
	}
	function setSelectValue(){
		document.getElementById('list').value = document.forms["transaction"]["phone"].value;
        setNoCheck();
	}
	function checkBox() {
		if(document.transaction.redirect.checked == true)
			document.transaction.redirect.checked = false;
		else
			document.transaction.redirect.checked = true;
	}

    function setNoCheck() {
        checkHappened = false;
        document.getElementById("display_customer_points").innerHTML = " - ";
        document.getElementById("availableCheckouts").innerHTML = '<input type="radio" name="pid" id="checkout0" checked="checked"><label for="checkout0"><img src="images/apply.png" alt="" /> Submit without redemption</label>';
        document.getElementById("submitButton").innerHTML = '<img src="images/view.png" class="icon" /> Check points';
    }
    function checkAvailableCheckouts(points) {
        var xmlhttp;
        xmlhttp=new XMLHttpRequest();
        xmlhttp.open("GET", "get-customer-checkouts.php?points="+points+"&phone="+document.forms["transaction"]["phone"].value, true);
        xmlhttp.onreadystatechange = function () {
            if ( xmlhttp.readyState == 4 && xmlhttp.status == 200 ) {
                jsonObject = JSON.parse( xmlhttp.responseText );

                if(jsonObject.status == 200) {
                    var html = "";
                    for(var i=0; i < jsonObject.message.length; i++) {
                        html = html + '<input type="radio" name="pid" id="checkout' + jsonObject.message[i].id + '" value="' + jsonObject.message[i].id + '">';
                        html = html + '<label for="checkout' + jsonObject.message[i].id + '">';
                        html = html + "<img src='images/checkout.png' alt='' /> ";
                        html = html + jsonObject.message[i].prize_msg + " (" + jsonObject.message[i].prize_points + " πόντοι)" + "</label><br />";
                    }
                    html = html + '<input type="radio" name="pid" id="checkout0" checked="checked" value=""><label for="checkout0"><img src="images/apply.png" alt="" /> Submit without redemption</label>';
                    document.getElementById("availableCheckouts").innerHTML = html;
                    checkHappened = true;
                    document.getElementById("display_customer_points").innerHTML = jsonObject.points;
                    if(jsonObject.category) {
                        document.getElementById("display_customer_points").innerHTML = jsonObject.points + " (" + jsonObject.category + ")";
                    }
                    document.getElementById("submitButton").innerHTML = '<img src="images/apply.png" class="icon" /> Submit transaction';
                }
                else {
                    alert(jsonObject.message);
                }
            }
        };
        xmlhttp.send(null);
    }

    function checkMoney(input) {
        if(input.value.length >= 10) {
            document.getElementById('notes').value = input.value;
            input.value = parseInt(input.value.substr(input.value.length - 4))/100;
        }

        setNoCheck()
    }

</script>
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
</head>

<body>
	
<?php headerDiv();?>

<div class="main">
<h1><?php echo QUICK_TRANSACTION; ?></h1>
	<div id="transaction_errorloc" style=":hover{font-size:12px;}font-size:15px;"></div>

	<form action="new-transaction-exec.php" method="post" 
	name="transaction" id="transaction" 
	>
	<table class="main">
		<tr>
			<td><?php echo CUSTOMER_PHONE; ?></td>
			<td><input type="text" name="phone" id="phone" size="10" onchange="setSelectValue();" style="font-size:18px;font-weight:bold;" onkeypress="if(event.keyCode=='13'){document.transaction.money.focus();return false;}" /></td>
			<td>
			<select onchange="setCellValue();" name="list" id="list" style="font-size:18px;font-weight:bold;">
				<option value="0"><?php echo CUSTOMER_LIST; ?></option>
				<?php 
					$link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
						if(!$link) {
							die(ERROR_DATABASE_CONNECTION_FAILURE);
						}
						$db = mysql_select_db(DB_DATABASE);
						if(!$db) {
							die("Unable to select database");
						}
						mysql_query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'", $link)
							or die(mysql_error());
						$result = mysql_query("SELECT customer_id, name, surname, phone FROM customers ORDER BY surname, name") 
							or die(mysql_error());
						while($row = mysql_fetch_array($result)) {
							echo '<option value="'.$row['phone'].'">'.$row['surname'].' '.$row['name'].' ('.$row['customer_id'].')</option>
							';
						}	
				?>
			</select>
			</td>
		</tr>
		<tr><td><?php echo AMOUNT_IN_EURO; ?></td>
			<td><input type="text" name="money" id="money" size="10" value="" style="font-size:18px;font-weight:bold;" onchange="checkMoney(this)" onkeyup="this.value = this.value.replace(/,/g, '.')"/></td>
			<td></td>
		</tr>
		<tr>
			<td></td>
			<td><input type="hidden" name="notes" id="notes" size="20"/></td>
			<td>
			</td>
		</tr>
        <tr>
            <td><?php echo CUSTOMER_POINTS; ?></td>
            <td id="display_customer_points"> - </td>
        </tr>
        <tr>
            <td><?php echo EXARGYROSIS_PROSFORAS; ?></td>
            <td colspan="2">
                <div id="availableCheckouts">
                    <input type="radio" value="" id="checkout0" checked="checked" name="pid"/><label for="checkout0"><img src="images/apply.png" alt="" /> Submit without redemption</label>
                </div>
            </td>
        </tr>
		<tr>
			<td colspan="3" style="padding-top:20px;padding-bottom:20px;text-align:center;">
				<input type="checkbox" name="redirect" id="redirect" checked="yes" value="yes" />
					 <span onClick="checkBox();" style="cursor: pointer;"><?php echo APOKRYPSI_TIS_SELIDAS_EKTYPO; ?></span>
					 <br />(<?php echo ISCHYEI_MONO_AN_O_PELATIS_DEN; ?>)</span>
			</td>
		</tr>
		<TR>
			<TD colspan="2" style="text-align:left;padding:10px;">
				<button type="submit" class="styled" id="submitButton" onClick="return confirmDialog(
				<?php echo $_SESSION['SESS_MONEY_POINTS'];?>, <?php echo $_SESSION['SESS_VISIT_POINTS'];?>
				)"><img src="images/view.png" class="icon" /> Check</button>
			</TD>
			<td>
				<button type="button" class="styled" onClick="window.location.href='user-index.php'">
					<img src="images/home.png" class="icon" /> Return
				</button>
				<button type="button" class="styled" onClick="window.location.href='new-big-transaction-form.php'">
					<img src="images/new-transaction.png" class="icon" /> Loyalty transaction with member id
				</button>
			</td>
		</TR>
	</TABLE>
</form>
<script type="text/javascript" language="javascript">
	document.getElementById("phone").focus();
    <?php
        $smsCredits = returnSMS();
        if($_SESSION['SESS_SMS_ENABLE_TRANSATION'] == 'y' && $smsCredits < 1) {
            echo "alert('Ο πελάτης ΔΕ θα λάβει SMS λόγω μηδενικού υπολοίπου!')";
        }
    ?>
</script>
<script language="JavaScript" type="text/javascript"
    xml:space="preserve">//<![CDATA[
  var frmvalidator  = new Validator("transaction");
  frmvalidator.EnableOnPageErrorDisplaySingleBox();
  frmvalidator.EnableMsgsTogether();
  frmvalidator.addValidation("phone","req","Δεν έχετε εισάγει τον αριθμό πελάτη");
  frmvalidator.addValidation("money","req","Δεν έχετε εισάγει τo ποσό της συναλλαγής");
  frmvalidator.addValidation("money","gt=-1", "Το ποσό της συναλλαγής πρέπει να είναι θετικό");
  frmvalidator.addValidation("money","decimal", "Το ποσό της συναλλαγής πρέπει να είναι αριθμός");

//]]></script>
</div>

</body>
</html>
