<?php
require_once('config.php');
require_once('class.phpmailer.php');
require_once('class.smtp.php');

function sendEmail ($emailRecipients = array(), $msgHtml, $subject = "Loyalty Club") {

    $emailRecipients = array_unique($emailRecipients);

    $errors = 0;
    foreach($emailRecipients as $key => $email) {
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $errors++;
            continue;
        }

        $mail = new PHPMailer;

        $mail->isSMTP();
        $mail->CharSet = 'UTF-8';
        $mail->Host = PHPMAILER_SMTP_HOST;
        $mail->SMTPAuth = true;
        $mail->Username = PHPMAILER_SMTP_USER;
        $mail->Password = PHPMAILER_SMTP_PASS;
        $mail->SMTPSecure = 'tls';
        $mail->Port = PHPMAILER_SMTP_PORT;

        $mail->setFrom(PHPMAILER_FROM_MAIL, PHPMAILER_FROM_NAME);
        $mail->addAddress($email);
        $mail->addReplyTo(PHPMAILER_REPLY_MAIL, PHPMAILER_REPLY_NAME);

        $mail->AddCustomHeader("List-Unsubscribe: <mailto:unsubscribe@loyaltyclub.gr?subject=Unsubscribe from " . SMS_FROM . ">, <http://loyaltyclub.gr/unsubscribe.php?mail=" . $email . ">");

        $mail->isHTML(true);

        $mail->Subject = $subject;
        $mail->Body    = $msgHtml;
        $mail->AltBody = strip_tags($msgHtml);

        if(!$mail->send()) {
            $errors++;
        }
    }

    return count($emailRecipients)-$errors;
}

?>
