<?php
// *** DEBUG – βγάζει όλα τα λάθη στην οθόνη (βγάλ' το σε production) ***
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Buffer για να μην μπλοκάρουν τα headers αν τυχόν υπάρξει output
ob_start();

require_once "functions.php";
require_once "DatabaseConnector.php";

// Ασφαλές session_start (δεν θα ξανατρέξει αν έχει ήδη αρχίσει)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

try {
    $databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
    $pdo = $databaseConnector->getConnection();
    $pdo->exec('SET NAMES utf8');

    // Παίρνεις username / password από GET όπως το θες
    $login    = isset($_GET['username']) ? secureInput($_GET['username']) : '';
    $password = isset($_GET['password']) ? secureInput($_GET['password']) : '';

    // Αν δεν έχει password -> αποτυχία
    if ($password === '') {
        session_write_close();
        header("Location: login-failed.php?msg=1");
        exit();
    }

    // ---- Build query ανάλογα με το αν έχει σταλεί customer_id ----
    if ($login === '') {
        // Login ΜΟΝΟ με τηλέφωνο ή email
        $qry = "
            SELECT *
            FROM customers
            WHERE phone = :password OR email = :password
            LIMIT 1
        ";
        $stmt = $pdo->prepare($qry);
        $stmt->bindParam(":password", $password, PDO::PARAM_STR);
    } else {
        // Login με customer_id ΚΑΙ (τηλέφωνο ή email)
        $qry = "
            SELECT *
            FROM customers
            WHERE customer_id = :customer_id
              AND (phone = :password OR email = :password)
            LIMIT 1
        ";
        $stmt = $pdo->prepare($qry);
        $stmt->bindParam(":customer_id", $login, PDO::PARAM_STR);
        $stmt->bindParam(":password", $password, PDO::PARAM_STR);
    }

    $stmt->execute();

    // Πιο safe από rowCount() σε SELECT
    $member = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($member) {
        // Αποθηκεύεις ό,τι χρειάζεσαι στο session
        $_SESSION['username'] = $login;
        $_SESSION['password'] = $password; // το θες έτσι

        session_regenerate_id(true);

        foreach ($member as $key => $value) {
            $_SESSION[$key] = $value;
        }

        session_write_close();

        header("Location: user-index.php");
        exit();
    } else {
        // Λάθος στοιχεία
        header("Location: login-failed.php?msg=1");
        exit();
    }

} catch (Exception $e) {
    // Για debug μπορείς να δεις το πραγματικό μήνυμα
    // die("Database Error: " . $e->getMessage());
    die("Database Error");
}
?>
