<!doctype html>
<html lang="en">
    <?php
    require_once '../DatabaseConnector.php';
    require_once '../Dao.php';
    require_once '../PromotionClass.php';
    require_once '../config.php';
    
require_once "functions.php";

if (!isLoggedin()) {
    header("location: login-failed.php?msg=2");
}
echo openHeader("Inbox", "");
echo menu(true);

?>

    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO"
              crossorigin="anonymous">
        <link rel="stylesheet" href="parts/styles.css">
    </head>

    <body>
        <main>
            <?php

            $connector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
            $mysqlConnection = $connector->getConnection();
            $dao = new Dao($mysqlConnection);
            
            $id = $_SESSION['username'];

            //Στον πίνακα βάζω ή αφαιρώ χρώματα
            $colors = array("#eee7e6", "#ffffff");
            $color_len = count($colors);
            $color = 0;
            
            ?>
            <div align="middle">

<h4>Active Promotions</h4></div>
            <div class="list-group">


                <?php
                
                    $promotions = $dao->getNotExpiredPromotions();
                    foreach ($promotions as $promotion) {
                        if($dao->userIsInCategory($id, $promotion->getCategory())) {?>
                        <a href="#" class="list-group-item list-group-item-action flex-column align-items-start" style="border:dashed; background-color: <?= $colors[$color] ?>">
                            <div class="d-flex w-100 justify-content-between">
                                <h4 class="mb-1" style="color: red">
        <?= $promotion->getTitle() ?>
                                </h4>
                                
                                
                                
                                </div>
                            <p class="mb-1" style="font-size: 14px;">
        <?= $promotion->getBody() ?>
                            </p>
                        <img src="../images/logo.png" width="100" align="right">
                            
        </small>
                            <div  ><span><?= "Ημερομηνία έκδοσης " . " " . date("d/m/Y", strtotime($promotion->getEntryDate()))?></span></div>
                            <br>
<?php
                                    if ($promotion->getExpireDate() != "0000-00-00") {
                                         echo "<span>"."Ημερομηνία λήξης " . " " .  date("d/m/Y", strtotime($promotion->getExpireDate()))."</span>" ;
                                    }?>
                        </a>

                        <?php
                        if ($color == $color_len - 1) {
                            $color = 0;
                            $color++;
                        }
                    }
                    }
                ?>

            </div>

        </main>
        <?php

echo closeHeader();
echo footer();

?>
    </body>

</html>

