<?php
    require_once "functions.php";
    require_once "DatabaseConnector.php";

	session_start();
	try {
		$databaseConnector = new DatabaseConnector(DB_DATABASE,DB_USER, DB_PASSWORD, DB_HOST); 
		$pdo = $databaseConnector->getConnection();
		$pdo->exec('set names utf8');

	    $login = "";
	    $password = "";
	    if(isset($_GET['username'])) {
	        $login = secureInput($_GET['username']);
	    }
	    if(isset($_GET['password'])) {
		    $password = secureInput($_GET['password']);
	    }
	    
		if($login == '' || $password == '') {
			session_write_close();
			header("location: login-failed.php?msg=1");
			exit();
		}
		
		//Create query
		$qry="SELECT * FROM customers WHERE customer_id=:customer_id AND phone=:phone";

		$stmt = $pdo->prepare($qry);
		$stmt->bindParam(":customer_id", $login);
		$stmt->bindParam(":phone", $password);
		$stmt->execute();
		
			if($stmt->rowCount() == 1) {
				$member = $stmt->fetch(PDO::FETCH_ASSOC);
				$_SESSION['username']=$login;
				$_SESSION['password']=$password;
				session_regenerate_id();

	            foreach($member as $key => $value) {
	                $_SESSION[$key] = $value;
	            }

				session_write_close();
				header("location: user-index.php");
				exit();
			}else {
				header("location: login-failed.php?msg=1");
				exit();
			}
	} catch (Exception $e) {
            die("Database Error");
    }
?>
