<?php

class WebTokenDAO {

    /**
     *
     * @var PDO
     */
    private $connection;

    function __construct($connection) {
        $this->connection = $connection;
    }

    /**
     * Returns true if web token got set or false if not
     * 
     * @param string $phone customers phone in DB
     * @param string $token firebase web token
     * @return boolean is_set true if updated false otherwise
     */
    public function set_web_token($phone, $token) {
        $sql = "SELECT id FROM customers WHERE phone = :phone";
        $stmt = $this->connection->prepare($sql);
        $stmt->bindParam(":phone", $phone);
        $stmt->execute();
        $customer = $stmt->fetch();

        if (!$customer) {
            return false;
        }
        //updating customers web token
        $id = $customer["id"];
        $sql = "UPDATE customers SET firebase_web_token = :token WHERE id = $id";
        $stmt = $this->connection->prepare($sql);
        $stmt->bindParam(":token", $token);
        $stmt->execute();
        
        return true;
    }



}
