<?php

require_once 'config.php';
require_once '../DatabaseConnector.php';
require_once 'WebTokenDAO.php';

if (!isset($_GET["phone"], $_GET['token'])) {
    echo 'Not enough params...';
    http_response_code(400);
    die();
}

$phone = secure_input($_GET['phone']);
$token = secure_input($_GET['token']);

try {
    $database_object = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
    $web_token_dao = new WebTokenDAO($database_object->getConnection());
    
    $token_updated = $web_token_dao->set_web_token($phone, $token);

    if ($token_updated) {
        echo 'Successfully updated';
    } else {
        echo 'Not updated';
        http_response_code(204);
    }
} catch (Exception $ex) {
    die("Database Problem...");
}

echo "Phone : $phone | Token : $token";

function secure_input($input) {
    $input = trim($input);
    $input = stripcslashes($input);
    $input = htmlspecialchars($input);
    return $input;
}
?>
