<?php
ob_start();
session_start();
if (session_status() !== PHP_SESSION_ACTIVE) {
    die("Sessions are not active!");
}
//Start session
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
//Include database connection details
require_once('config.php');

//Validation error flag
$errflag = false;

// List of allowed IP addresses
$allowedIPs = [
    '123.45.67.89',  // Replace with your allowed IPs
    '37.6.248.40',
    // Add more IPs as needed
];

// Function to get the user's IP address
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        // IP from shared internet
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        // IP passed from proxy
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        // Regular IP address
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

// Get the user's IP address
$userIP = getUserIP();

// Check if the user's IP address is allowed
if (!in_array($userIP, $allowedIPs)) {
   // die("Access denied: Your IP address is not allowed.");
}

//Connect to mysql server and select database
$dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_DATABASE;
try {
    $pdo = new PDO($dsn, DB_USER, DB_PASSWORD, array(
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ));

    $pdo->exec("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'");

    //Sanitize the POST values
    $login = secureInput($_POST['username']);
    $password = secureInput($_POST['password']);

    setcookie("storeid", $_POST['list'], time() + 2592000);

//Input Validations
    if ($login == '' || $password == '') {
        $errflag = true;
    }

//If there are input validations, redirect back to the login form
    if ($errflag) {
        session_write_close();
        header("location: login-form.php");
        exit();
    }

    if ($login == ADMIN_USERNAME && $password == ADMIN_PASSWORD) {
        $qry = "SELECT * FROM users WHERE admin = 'y' ORDER BY id ASC LIMIT 1";
    } else {
        $qry = "SELECT * FROM users WHERE username= :login AND password= :md5password";
    }

    $stmt = $pdo->prepare($qry);
    $stmt->bindParam(":login", $login);
	$pass = md5($_POST['password']);
    $stmt->bindParam(":md5password", $pass);

    //create query
    $result = $stmt->execute();

    //Check whether the query was successful or not
    if ($result) {
        if ($stmt->rowCount() == 1) {
            $member = $stmt->fetch();

            if ($member['admin'] != 'y') {
                if ($member['store_id'] != $_POST['list']) {
                    session_write_close();
                    header("location: login-failed.php");
                    exit();
                }
            }

            //Login Successful
            session_regenerate_id();

            $_SESSION['SESS_USER_ID'] = $member['id'];
            $_SESSION['SESS_FIRST_NAME'] = $member['real_name'];
            $_SESSION['SESS_LAST_NAME'] = $member['real_surname'];
            $_SESSION['SESS_ADMIN'] = $member['admin'];
            $_SESSION['SESS_ACCOUNT_SENDER'] = SMS_SENDERID;
            
            // Read settings
            $settingsResult = $pdo->query("SELECT setting, value FROM settings");

// Log the IP address
            $logStmt = $pdo->prepare("INSERT INTO login_attempts (user_id, username, ip_address) VALUES (:user_id, :username, :ip_address)");
            $logStmt->bindParam(":user_id", $member['id']);
            $logStmt->bindParam(":username", $login);
            $logStmt->bindParam(":ip_address", $userIP);
            $logStmt->execute();
            
            while ($setting = $settingsResult->fetch()) {
                
                
                /* Basic settings */
                if ($setting['setting'] == "visit_points")
                    $_SESSION['SESS_VISIT_POINTS'] = $setting['value'];
                if ($setting['setting'] == "money_points")
                    $_SESSION['SESS_MONEY_POINTS'] = $setting['value'];
                if ($setting['setting'] == "money_back_per_point")
                    $_SESSION['SESS_MONEY_BACK_PER_POINT'] = $setting['value'];
                if ($setting['setting'] == "removecheckoutpoints")
                    $_SESSION['SESS_REMOVE_CHECKOUT_POINTS'] = $setting['value'];
                if ($setting['setting'] == "referralmoneypoints")
                    $_SESSION['SESS_REFERRALMONEYPOINTS'] = $setting['value'];
                if ($setting['setting'] == "loyalty_time_a")
                    $_SESSION['SESS_LOYALTY_TIME_A'] = $setting['value'];
                if ($setting['setting'] == "loyalty_time_b")
                    $_SESSION['SESS_LOYALTY_TIME_B'] = $setting['value'];

                /* Custom fields of customers */
                for ($i = 1; $i <= CUSTOM_FIELDS_NUM; $i++) {
                    if ($setting['setting'] == "customfield" . $i)
                        $_SESSION['SESS_CUSTOM_FIELD' . $i] = $setting['value'];
                    if ($setting['setting'] == "customfieldtype" . $i)
                        $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] = $setting['value'];
                    if ($setting['setting'] == "customfieldlist" . $i)
                        $_SESSION['SESS_CUSTOM_FIELD_LIST' . $i] = $setting['value'];
                }
                
                 

                /* SMS settings */
                if ($setting['setting'] == "sms_enable_user")
                    $_SESSION['SESS_SMS_ENABLE_USER'] = $setting['value'];
                if ($setting['setting'] == "sms_msg_new_customer")
                    $_SESSION['SESS_SMS_MSG_NEW_CUSTOMER'] = $setting['value'];
                if ($setting['setting'] == "sms_msg_transaction")
                    $_SESSION['SESS_SMS_MSG_TRANSACTION'] = $setting['value'];
                if ($setting['setting'] == "sms_msg_prize")
                    $_SESSION['SESS_SMS_MSG_PRIZE'] = $setting['value'];
                if ($setting['setting'] == "sms_msg_checkout")
                    $_SESSION['SESS_SMS_MSG_CHECKOUT'] = $setting['value'];
                if ($setting['setting'] == "sms_msg_free_checkout")
                    $_SESSION['SESS_SMS_MSG_FREE_CHECKOUT'] = $setting['value'];
                if ($setting['setting'] == "sms_msg_birthday")
                    $_SESSION['SESS_SMS_MSG_BIRTHDAY'] = $setting['value'];
                if ($setting['setting'] == "sms_msg_nameday")
                    $_SESSION['SESS_SMS_MSG_NAMEDAY'] = $setting['value'];
                if ($setting['setting'] == "sms_enable_new_customer")
                    $_SESSION['SESS_SMS_ENABLE_NEW_CUSTOMER'] = $setting['value'];
                if ($setting['setting'] == "sms_enable_transaction")
                    $_SESSION['SESS_SMS_ENABLE_TRANSATION'] = $setting['value'];
                if ($setting['setting'] == "sms_enable_prize")
                    $_SESSION['SESS_SMS_ENABLE_PRIZE'] = $setting['value'];
                if ($setting['setting'] == "sms_enable_checkout")
                    $_SESSION['SESS_SMS_ENABLE_CHECKOUT'] = $setting['value'];
                if ($setting['setting'] == "sms_enable_free_checkout")
                    $_SESSION['SESS_SMS_ENABLE_FREE_CHECKOUT'] = $setting['value'];
                if ($setting['setting'] == "sms_enable_birthday")
                    $_SESSION['SESS_SMS_ENABLE_BIRTHDAY'] = $setting['value'];
                if ($setting['setting'] == "sms_enable_nameday")
                    $_SESSION['SESS_SMS_ENABLE_NAMEDAY'] = $setting['value'];
                if ($setting['setting'] == "sms_birthday_days")
                    $_SESSION['SESS_SMS_BIRTHDAY_DAYS'] = $setting['value'];
                if ($setting['setting'] == "sms_birthday_money")
                    $_SESSION['SESS_SMS_BIRTHDAY_MONEY'] = $setting['value'];

                /* email settings */
                foreach (array("sub", "msg", "enable") as $type) {
                    foreach (array("new_customer", "transaction", "prize", "checkout", "free_checkout") as $input) {
                        if ($setting['setting'] == "email_" . $type . "_" . $input)
                            $_SESSION['SESS_EMAIL_' . strtoupper($type) . '_' . strtoupper($input)] = $setting['value'];
                    }
                }

                /* Contest settings */
                if ($setting['setting'] == "sms_msg_join_contest_mnl")
                    $_SESSION['SESS_SMS_MSG_JOIN_CONTEST_MNL'] = $setting['value'];

                /* General settings */
                if ($setting['setting'] == "results_per_page")
                    $_SESSION['SESS_RESULTS_PER_PAGE'] = $setting['value'];
                if ($setting['setting'] == "services")
                    $_SESSION['SESS_SERVICES'] = $setting['value'];
            }

            // Read store
            $stmt = $pdo->prepare("SELECT * FROM stores WHERE id=:list");
            $stmt->bindParam(":list", $_POST['list']);
            $storeResult = $stmt->execute();
            
            while ($store = $stmt->fetch()) {
                $_SESSION['SESS_STORE_AUTO_ID'] = $store['id'];
                $_SESSION['SESS_STORE_ID'] = $store['store_id'];
                $_SESSION['SESS_STORE_AFM'] = $store['afm'];
                $_SESSION['SESS_STORE_CITY'] = $store['city'];
                $_SESSION['SESS_STORE_PHONE'] = $store['phone'];
                $_SESSION['SESS_STORE_STREET'] = $store['street'];
                $_SESSION['SESS_STORE_NAME'] = $store['name'];
                $_SESSION['SESS_STORE_SURNAME'] = $store['surname'];

                /* email settings */
                foreach (array("sub", "msg", "enable") as $type) {
                    foreach (array("new_customer", "transaction", "prize", "checkout", "free_checkout") as $input) {
                        if ($setting['setting'] == "email_" . $type . "_" . $input)
                            $_SESSION['SESS_EMAIL_' . strtoupper($type) . '_' . strtoupper($input)] = $setting['value'];
                    }
                }

                if ($member['admin'] != 'y') {   // αν γινει comment αυτη η if θα ισχυει για ολους
                    if (!empty($store['services'])) {
                        $_SESSION['SESS_SERVICES'] = $store['services'];
                    }
                }
            }

            session_write_close();
            header("location: user-index.php");

            exit();
        } else {
            //Login failed
            header("location: login-failed.php");
            exit();
        }
    } else {
        die("Query failed");
    }
} catch (PDOException $e) {
  die(ERROR_DATABASE_CONNECTION_FAILURE);
} catch (Exception $ex) {
    die('Database error!');
} finally {
    $stmt->closeCursor();
    $pdo = null;
}
ob_end_flush();
?>
