<?php
require_once('config.php');

define('CSV_DELIMITER', ';');
define('SKIP_FIRST_CSV_LINE', true);
define('CALCULATE_POINTS', true);
define('USER_ID', 1); // assign the transaction to a specific user
define('STORE_ID', 1); // assign the transaction to a specific store

$dateNow = date("Y-m-d H:i:s");
$notes1 = "import csv " . $dateNow;
$services = "";
$giftcardMoney = 0;
$giftcardId = null; // use null instead of "NULL" for safer handling

// Database connection using mysqli
$mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE);

if ($mysqli->connect_error) {
    die("Database connection failed: " . $mysqli->connect_error);
}

// Set character set to UTF-8
$mysqli->set_charset("utf8");

// Fetch settings
$settings = array();
$settingsResult = $mysqli->query("SELECT setting, value FROM settings");
if ($settingsResult) {
    while ($setting = $settingsResult->fetch_assoc()) {
        if ($setting['setting'] == "visit_points") {
            $settings['SESS_VISIT_POINTS'] = $setting['value'];
        }
        if ($setting['setting'] == "money_points") {
            $settings['SESS_MONEY_POINTS'] = $setting['value'];
        }
    }
}

// Validate and sanitize file path
$filePath = filter_input(INPUT_GET, 'file1', FILTER_SANITIZE_STRING);
$filePath = realpath($filePath); // Resolve path to prevent directory traversal
if (!$filePath || !file_exists($filePath)) {
    die("Invalid or missing file.");
}

$counter = 0;
if (($handle = fopen($filePath, "r")) !== false) {
    $firstLine = true;

    while (($row = fgetcsv($handle, 0, CSV_DELIMITER)) !== false) {
        if (SKIP_FIRST_CSV_LINE && $firstLine) {
            $firstLine = false;
            continue;
        }

        if (is_array($row) && count($row) == 6) {
            $where = "customer_id";
            if (strlen($row[0]) == 10) {
                $where = "phone";
            }

            // Use prepared statements to prevent SQL injection
            $stmt = $mysqli->prepare("SELECT id FROM customers WHERE $where = ?");
            $stmt->bind_param("s", $row[0]); // 's' means the parameter is a string
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows === 0) {
                echo "Customer " . htmlspecialchars($row[0]) . " not found. Skipping from import.";
                continue;
            } else {
                $user = $result->fetch_assoc();
                $customer_id = $user['id'];
            }

            $money = str_replace(",", ".", $row[1]);
            if (!is_numeric($money)) {
                echo "Invalid money value for customer " . htmlspecialchars($row[0]) . ". Skipping.";
                continue;
            }

            $points = 0;
            if (CALCULATE_POINTS) {
                $points = $money * $settings['SESS_MONEY_POINTS'] + $settings['SESS_VISIT_POINTS'];
            }

            $dateTrans = $row[2] . " 00:00:00";
            $notes = $notes1 . " " . htmlspecialchars($row[4]);

            $insertQuery = "INSERT INTO transactions 
                (customer_auto_id, money, points, date, `by`, store_id, notes, services, giftcard_id, giftcard_money)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $insertStmt = $mysqli->prepare($insertQuery);
            $insertStmt->bind_param("iddsisissi", $customer_id, $money, $points, $dateTrans, USER_ID, STORE_ID, $notes, $services, $giftcardId, $giftcardMoney);
            $insertStmt->execute();

            $counter++;
            $last_customer_id = $row[0];
        }
    }

    fclose($handle);
    echo "Imported $counter transactions. Last customer ID: " . htmlspecialchars($last_customer_id);
} else {
    echo "Unable to read the file.";
}

// Close database connection
$mysqli->close();
