<?php

require_once 'auth.php';
require_once 'config.php';
require_once 'functions-transaction.php';
require_once __DIR__.'/../libs/net2020/DatabaseConnector.php';
require_once __DIR__.'/../libs/net2020/utils/SQLFilter.php';
require_once 'dao/CustomerDao.php';

header("Content-type: application/json; charset=utf-8");

if (!isset($_GET["customer"]) && !isset($_GET["id"])) {
    
    die("Wrong params");
    http_response_code(400);
    die();  
}

$databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
$connection = $databaseConnector->getConnection();
$connection->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'");

$customerDao = new CustomerDao($connection);


if (isset($_GET["customer"])) {
    
    $customer = secureInput($_GET["customer"]);
    
    $customers = $customerDao->findAll((new SQLFilter("name LIKE %$customer%"))->orExpr("surname LIKE %$customer%")->limit("10"));
    
    echo json_encode($customers, JSON_UNESCAPED_UNICODE);

} else if (isset($_GET["id"])) {
    
    $customerId = secureInput($_GET["id"]);

     $customers = $customerDao->findAll((new SQLFilter("customer_id = $customerId")));
     
     $customer = [];
     
     if(count($customers) > 0) {
         $customer = $customers[0];
     }
     echo json_encode($customer, JSON_UNESCAPED_UNICODE);
}


