document.addEventListener('DOMContentLoaded', function() {
    const video = document.getElementById('video');
    const canvas = document.getElementById('canvas');
    const context = canvas.getContext('2d');
    const captureButton = document.getElementById('capture');
    const sendButton = document.getElementById('send');

    // Get access to the camera
    if (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
        navigator.mediaDevices.getUserMedia({
            video: { facingMode: "environment" } // Use the back camera
        })
        .then(function(stream) {
            video.srcObject = stream;
            video.play();
        })
        .catch(function(error) {
            console.error("Error accessing the camera:", error);
        });
    }

    // Capture the image from the video stream
    captureButton.addEventListener('click', function() {
        context.drawImage(video, 0, 0, 640, 480);
    });

    // Send the image to the server for processing
    sendButton.addEventListener('click', function() {
        canvas.toBlob(function(blob) {
            const formData = new FormData();
            formData.append('receipt_image', blob, 'receipt.jpg');

            fetch('https://37.27.179.82/upload2.php', {
                method: 'POST',
                body: formData,
            })
            .then(response => response.json())
            .then(data => {
                console.log('Success:', data);
                alert('Image processed successfully!');
            })
            .catch((error) => {
                console.error('Error:', error);
                alert('Failed to send the image.'); // edw meiname
            });
        }, 'image/jpeg');
    });
});
