const video = document.getElementById('video');
const canvas = document.getElementById('canvas');
const context = canvas.getContext('2d');
const captureButton = document.getElementById('capture');
const sendButton = document.getElementById('send');

// Set constraints for the video stream
const constraints = {
    video: {
        width: 640,
        height: 480,
        facingMode: "environment" // Try to request rear camera
    }
};

// Attach the video stream to the video element and autoplay.
navigator.mediaDevices.getUserMedia(constraints)
    .then(function(stream) {
        video.srcObject = stream;
        video.play();
    })
    .catch(function(error) {
        console.error("Error accessing the camera.", error);
    });

// Capture button to capture the image to canvas
captureButton.addEventListener('click', function() {
    context.drawImage(video, 0, 0, canvas.width, canvas.height);
});

// Send button to perform OCR on the captured image
sendButton.addEventListener('click', function() {
    Tesseract.recognize(
        canvas,
        'eng', // or 'gre' if it's Greek etc, based on your requirement
        { logger: m => console.log(m) }
    ).then(({ data: { text } }) => {
        console.log('OCR Result:', text);
        document.getElementById('ocrResult').textContent = text;
    }).catch(err => {
        console.error('OCR Error:', err);
        document.getElementById('ocrResult').textContent = 'OCR Error: ' + err.message;
    });
});
