<?php
/* USAGE 

bridge.php?cid=0004&m=15.4&sid=1&uid=1&j=1

cid = the customer id for the transaction
m = money of the transaction
sid = store id that the transaction happened
uid = user id that made the transaction
j = whether to return results as json or as html

*/

require_once('bridge-config.php');
require_once('config.php');
require_once('sendSMS.php');
require_once('sendEmail.php');

if (isset($_REQUEST['j']) && $_REQUEST['j'] == "1")
	$json = true;
else
	$json = false;

if ($json) {
	header("Content-Type: application/json");
}
header("Pragma: no-cache");
header("Cache: no-cache");
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

$info = getAccountInfo();
if ($info['subscription_end_date_timestamp'] < time()) {
    die("Λυπούμαστε, η συνδρομή σας έχει λήξει.\nΠαρακαλώ επικοινωνήστε με τη new media business για ανανέωση της συνδρομής σας, στο 2410539535.");
}

//Connect to mysql server
$link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
if (!$link) {
    die('Αποτυχία σύνδεσης με το διακομιστή της βάσης δεδομένων : ' . mysql_error());
}

//Select database
$db = mysql_select_db(DB_DATABASE);
if (!$db) {
    die('Αποτυχία σύνδεσης με τη βάση δεδομένων');
}

mysql_query("SET sql_mode = '', character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'", $link)
or die(mysql_error());


$settingsResult = mysql_query("SELECT setting, value FROM settings") or die(mysql_error());
$settings = array();
while ($setting = mysql_fetch_array($settingsResult)) {
    /* Basic settings */
    if ($setting['setting'] == "visit_points")
        $settings['SESS_VISIT_POINTS'] = $setting['value'];
    if ($setting['setting'] == "money_points")
        $settings['SESS_MONEY_POINTS'] = $setting['value'];
    if ($setting['setting'] == "removecheckoutpoints")
        $settings['SESS_REMOVE_CHECKOUT_POINTS'] = $setting['value'];
    if ($setting['setting'] == "services")
        $settings['SESS_SERVICES'] = $setting['value'];
    if ($setting['setting'] == "referralmoneypoints")
        $settings['SESS_REFERRALMONEYPOINTS'] = $setting['value'];

    /* SMS settings */
    if ($setting['setting'] == "sms_msg_new_customer")
        $settings['SESS_SMS_MSG_NEW_CUSTOMER'] = $setting['value'];
    if ($setting['setting'] == "sms_msg_transaction")
        $settings['SESS_SMS_MSG_TRANSACTION'] = $setting['value'];
    if ($setting['setting'] == "sms_msg_prize")
        $settings['SESS_SMS_MSG_PRIZE'] = $setting['value'];
    if ($setting['setting'] == "sms_msg_checkout")
        $settings['SESS_SMS_MSG_CHECKOUT'] = $setting['value'];
    if ($setting['setting'] == "sms_enable_transaction")
        $settings['SESS_SMS_ENABLE_TRANSATION'] = $setting['value'];
    if ($setting['setting'] == "sms_enable_prize")
        $settings['SESS_SMS_ENABLE_PRIZE'] = $setting['value'];
    if ($setting['setting'] == "sms_enable_checkout")
        $settings['SESS_SMS_ENABLE_CHECKOUT'] = $setting['value'];

    /* Email settings */
    if ($setting['setting'] == "email_enable_transaction")
        $settings['SESS_EMAIL_ENABLE_TRANSACTION'] = $setting['value'];
    if ($setting['setting'] == "email_msg_transaction")
        $settings['SESS_EMAIL_MSG_TRANSACTION'] = $setting['value'];
    if ($setting['setting'] == "email_sub_transaction")
        $settings['SESS_EMAIL_SUB_TRANSACTION'] = $setting['value'];
    if ($setting['setting'] == "email_msg_prize")
        $settings['SESS_EMAIL_MSG_PRIZE'] = $setting['value'];
    if ($setting['setting'] == "email_sub_prize")
        $settings['SESS_EMAIL_SUB_PRIZE'] = $setting['value'];
    if ($setting['setting'] == "email_enable_prize")
        $settings['SESS_EMAIL_ENABLE_PRIZE'] = $setting['value'];
    if ($setting['setting'] == "email_msg_checkout")
        $settings['SESS_EMAIL_MSG_CHECKOUT'] = $setting['value'];
    if ($setting['setting'] == "email_sub_checkout")
        $settings['SESS_EMAIL_SUB_CHECKOUT'] = $setting['value'];
    if ($setting['setting'] == "email_enable_checkout")
        $settings['SESS_EMAIL_ENABLE_CHECKOUT'] = $setting['value'];
}

$storesResult = mysql_query("SELECT * FROM stores") or die(mysql_error());
$stores = array();
$storesDetails = array();
while ($store = mysql_fetch_array($storesResult)) {
    $stores[$store['pin']] = $store['id'];
    $storesDetails[$store['id']] = $store;
}


if (isset($_REQUEST['uid'])) {
    $me = $_REQUEST['uid'];
}
else {
    if (USER_ID != "")
        $me = USER_ID;
    else
        $me = "NULL";
}

if(isset($_COOKIE['sid'])){
	$store_id = $_COOKIE['sid'];
}
else {
	if (isset($_REQUEST['sid'])) {
	    $store_id = $_REQUEST['sid'];
	}
	else {
	    if (STORE_ID != "")
		$store_id = STORE_ID;
	    else
		$store_id = "NULL";
	}
}

if (isset($_REQUEST['cid']))
    $customer_id = str_replace("viber://add?number=30", "", $_REQUEST['cid']);
else
    $customer_id = '';

if(!isset($_COOKIE['pass']) || (!isset($stores[$_COOKIE['pass']]))) {
	if(isset($_REQUEST['cookiepass']) && isset($stores[$_REQUEST['cookiepass']])) {
        setcookie('pass', $_REQUEST['cookiepass'], time() + 86400*COOKIEDAYS); // 86400 = seconds of a day
        setcookie('sid', $stores[$_REQUEST['cookiepass']], time() + 86400*COOKIEDAYS); // 86400 = seconds of a day
	}
	else {
		echo '<div style="width:600px; margin: 10px auto;font-size:4em">';
		echo '<form action="#" method="post">';
		echo '<span style="font-size:0.7em">PIN : </span><input type="password" style="font-size: 1em;" name="cookiepass" value="" size="5" />';
		// foreach ($_REQUEST as $key => $value) {
		// 	if($key != "cookiepass") {
		// 		echo '<input type="hidden" name="'.$key.'" value="'.$value.'" />';
		// 	}
		// }
		echo '<input type="submit" value="OK" style="height: 60px;padding: 30px 45px 0;"/></form></div>';
		die();
	}
}

$smsCredits = returnSMS();

if(!isset($_POST['m'])) {
    /* normal checkout */
    if(isset($_POST['prizeid']) && isset($_POST['checkoutid']) && isset($_POST['prizepoints'])) { ?>
        <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
        <html>
        <head>
            <meta charset="UTF-8">
            <title>Η εξαργύρωση ολοκληρώθηκε</title>
            <style type="text/css">a.nav{font-size: 1.4em}</style>
        </head>
        <body style="margin: 0px 0px 40px 0px;">
        <div style="width:600px; margin: 20px auto;font-size:1.7em">
            <?php
            if(!defined("VISIT_ONLY") || !VISIT_ONLY) {
                echo '<a class="nav" href="bridge.php">Νέα συναλλαγή</a> | <a class="nav" href="bridge-checkouts.php">Εξαργυρώσεις</a> | <a class="nav" href="bridge-new-customer.php">Νέος πελάτης</a><br />
            <img src="images/logo.jpg" alt="logo" />';
            }

            if ($customer_id == '') {
                    echo "<p>Δεν έχει επιλεγεί κάποιος πελάτης</p>";
                die();
            }

            $selectQuery = "SELECT customers.*, SUM(transactions.points) AS points FROM customers, transactions WHERE transactions.customer_auto_id = customers.id AND customers.customer_id LIKE '".$customer_id."'";
            $result = mysql_query($selectQuery) or die(mysql_error());
            $row = mysql_fetch_array($result);

            $prizeid = $_POST['prizeid'];
            $phone = $row['phone'];
            $totalPointsForSMS = $row['points'];

            /* check if it is a valid prize */
            $result = mysql_query("SELECT * FROM prizes WHERE id = ".$prizeid) or die(mysql_error());
            $prizerow = mysql_fetch_array($result);

            $checkout_date = date("Y/m/d");
            $prize_points = $prizerow['prize_points'];

            if (strtotime($prizerow['till_date']) < time()){
                echo '<p class="main">Η εξαργύρωση <span style="color:red;">δεν ολοκληρώθηκε</span> καθώς έχει περάσει η προθεσμία ισχύς της προσφοράς!</p>';
            }
            else {
                if(!isset($settings['SESS_REMOVE_CHECKOUT_POINTS'])) {
                    $settings['SESS_REMOVE_CHECKOUT_POINTS'] = "1";
                }

                if($settings['SESS_REMOVE_CHECKOUT_POINTS'] == "1"){
                    /* remove the prize points */
                    $insertQuery = "INSERT INTO transactions (`customer_auto_id`, `money`, `points`, `date`, `by`, `store_id`, `notes`, `services`)
                            VALUES ('".$row['id']."', '0', ".($prize_points * (-1)).", '".date("Y-m-d H:i:s")."', ".$me.", ".$store_id.", 'Εξαργύρωση προσφοράς', '');";
                    mysql_query($insertQuery, $link) or die(mysql_error());
                    $transactionAutoId = mysql_insert_id($link);

                    /* insert the new checkout row */
                    $insertQuery = "INSERT INTO checkouts (`transaction_auto_id`, `customer_auto_id`, `prize_auto_id`, `created_by_store_auto_id`, `date`, `received_date`, `received`, `received_by_store_auto_id`)
                            VALUES ('".$transactionAutoId."', '".$row['id']."', ".$prizeid.", ".$store_id.", '".date("Y-m-d H:i:s")."', '".date("Y-m-d H:i:s")."', 'y', ".$store_id.")";
                    mysql_query($insertQuery, $link) or die(mysql_error());
                    echo '<p>Αφαιρέθηκαν '.$prize_points.' πόντοι από τον πελάτη</p>';

                    $totalPointsForSMS -= $prize_points;
                }
                else {
                    /* find the checkout for this customer/prize/received=n and update it */
                    $updateQuery = "UPDATE checkouts SET received_date='".date("Y-m-d H:i:s")."', received='y', received_by_store_auto_id=".$store_id."
                                WHERE prize_auto_id = ".$prizeid." AND customer_auto_id = ".$row['id']." AND received='n'";
                    $result=mysql_query($updateQuery) or die(mysql_error());

                    echo '<p>Οι πόντοι της προσφοράς ΔΕΝ αφαιρέθηκαν από τον πελάτη</p>';
                }

                if($settings['SESS_SMS_ENABLE_CHECKOUT'] == 'y' && $row['sms'] == "1"){
                    $smsMsg = str_replace("surname", $row['surname'], $settings['SESS_SMS_MSG_CHECKOUT']);
                    $smsMsg = str_replace("name", $row['name'], $smsMsg);
                    $smsMsg = str_replace("customerId", $row['customer_id'], $smsMsg);
                    $smsMsg = str_replace("totalPoints", $totalPointsForSMS, $smsMsg);
                    $smsMsg = str_replace("prizePoints", $prize_points, $smsMsg);
                    $smsMsg = str_replace("prizeMsg", $prizerow['prize_msg'], $smsMsg);
                    $smsMsg = getLatinText($smsMsg);
                    $smsRes = sendSMS(array(SMS_COUNTRY_CODE.$phone), $smsMsg);
                    if($smsRes)
                        echo '<p class="main">Ο πελάτης ενημερώθηκε με sms στο κινητό του.</p>';
                    else
                        echo '<p class="main">Ο πελάτης ΔΕΝ ενημερώθηκε με γραπτό μήνυμα.</p>';
                }

                if($settings['SESS_EMAIL_ENABLE_CHECKOUT'] == 'y' && filter_var($row['email'], FILTER_VALIDATE_EMAIL)){
                    $emailMsg = str_replace("surname", $row['surname'], $settings['SESS_EMAIL_MSG_CHECKOUT']);
                    $emailMsg = str_replace("name", $row['name'], $emailMsg);
                    $emailMsg = str_replace("customerId", $row['customer_id'], $emailMsg);
                    $emailMsg = str_replace("totalPoints", $totalPointsForSMS, $emailMsg);
                    $emailMsg = str_replace("prizePoints", $prize_points, $emailMsg);
                    $emailMsg = str_replace("prizeMsg", $prizerow['prize_msg'], $emailMsg);
                    $emailRes = sendEmail(array($row['email']), $emailMsg, $settings['SESS_EMAIL_SUB_CHECKOUT']);
                    if($emailRes)
                        echo '<p class="main">Ο πελάτης ενημερώθηκε με email.</p>';
                    else
                        echo '<p class="main">Ο πελάτης ΔΕΝ ενημερώθηκε με email.</p>';
                }
            }
            ?>
            <p><strong>Η εξαργύρωση ολοκληρώθηκε</strong></p>
        </div>
        <p style="margin:0;background:#3e3e3e;color:#EEEEEE;position:fixed;bottom:0;width:100%;line-height:30px;text-align:center;font-size:16px;">Loyalty Club application by New Media Business | Τηλ.: 2410 539535</p>
        </body>
        </html>
<?php
        die();
    } /* end of normal checkout */
    /* quick visit checkout */
    elseif (isset($_POST['pid']) && isset($_POST['cid'])) {
        $fatalError = false;
        $messages = "";
        $money = 0;
        $points = $money * $settings["SESS_MONEY_POINTS"] + $settings['SESS_VISIT_POINTS'];
		$dateNow = date("Y-m-d H:i:s");
        if(isset($_POST['date'])) {
            $dateNow = $_POST['date'];
        }
		$notes = "";

        if (strlen($customer_id) >= 9) {
            $qry = "SELECT customers.*, SUM( transactions.points ) AS points, SUM( transactions.money ) AS money, COUNT( * ) AS visits
                    FROM  customers, transactions
                    WHERE transactions.customer_auto_id = customers.id AND customers.phone LIKE '$customer_id'";
        }
        else {
            $qry = "SELECT customers.*, SUM( transactions.points ) AS points, SUM( transactions.money ) AS money, COUNT( * ) AS visits
                    FROM  customers, transactions
                    WHERE transactions.customer_auto_id = customers.id AND customers.customer_id LIKE '$customer_id'";
        }

        $result=mysql_query($qry);
        //Check whether the query was successful or not
        if($result) {
            if(mysql_num_rows($result) == 1) {
                $user = mysql_fetch_array($result);
                if(is_null($user['id'])){
                    /* customer not found, maybe because he has no transactions, search again */
                    if (strlen($customer_id) >= 9) {
                        $qry = "SELECT * FROM customers WHERE phone LIKE '$customer_id'";
                    }
                    else {
                        $qry = "SELECT * FROM customers WHERE customer_id LIKE '$customer_id'";
                    }

                    $custres = mysql_query($qry) or die(mysql_error());
                    $user = mysql_fetch_array($custres);
                    $user['points'] = 0;
                    $user['money'] = 0;
                    $user['visits'] = 0;
                }

                $preventRefresh = mysql_query(" SELECT * FROM `transactions` WHERE
                                            `customer_auto_id` =".$user['id']." AND
                                            `money` = ".$money." AND
                                            `points` = ".$points." AND
                                            `date` = '".$dateNow."'") or die(mysql_error());

                if(mysql_num_rows($preventRefresh) > 0) {
                    echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
                            <html>
                            <head>
                                <meta charset="UTF-8">
                                <title>Αποτέλεσμα επίσκεψης</title>
                                <style type="text/css">
                                    *{
                                        font-size: 1.2em;
                                        font-family: Verdana, Arial, Helvetica, sans-serif;
                                    }
                                </style>
                            </head>
                            <body>
                            <div style="text-align: center"><img src="images/logo.jpg" style="padding: 10px 20px 30px" alt="logo" /><div style="clear: both"></div>
                            <p class="main">Υπάρχει ήδη μια παρόμοια συναλλαγή. Παρακαλώ δοκιμάστε ξανά.</p>
                            </body>
                        </html>
                        ';
                    die();
                }

                $customer_auto_id = $user['id'];
                $customer_id = $user['customer_id'];
                $phone = $user['phone'];

                //customer found successfully, do the transaction
                $insertQuery = "INSERT INTO transactions (`customer_auto_id`, `money`, `points`, `date`, `by`, `store_id`, `notes`, `services`)
                            VALUES ('$customer_auto_id', '$money', '$points', '$dateNow', '$me', '$store_id', '$notes', '');";

                mysql_query($insertQuery, $link) or die(mysql_error());

                $transactionId = mysql_insert_id($link);
                $totalPoints = $points+$user['points'];
                $totalMoney = $money+$user['money'];

                /* if we skip check for checkouts, automatically find if he can have a checkout and do it */
                if(defined("SKIP_CHECK") && SKIP_CHECK == true) {

                    //check if customer can have a prize
                    $prizeResult = mysql_query("SELECT prizes.*, prizes.prize_points*".$user['members_num']." AS `prize_points` FROM prizes WHERE till_date > NOW() AND from_date < NOW() ORDER BY prize_points DESC")
                    or die(mysql_error());
                    $prizeStampPoints = 0;
                    $prizeStampMessage = "";

                    while($prize = mysql_fetch_array($prizeResult)) {
                        if ($totalPoints >= $prize['prize_points'] && (is_null($prize['customer_custom']) || (isset($user['custom'.$prize['customer_custom']]) && $user['custom'.$prize['customer_custom']] == 'y'))){
                            if(isset($settings['SESS_REMOVE_CHECKOUT_POINTS']) && $settings['SESS_REMOVE_CHECKOUT_POINTS'] == "1") {
                                $_POST['pid'] = $prize['id'];
                                $prizeStampPoints = $prize['prize_points'];
                                $prizeStampMessage = $prize['prize_msg'];
                                break;
                            }
                        }
                    }

                    $messages .= "<p>";
                    for ($i = 0; $i < $totalPoints-$prizeStampPoints; $i++) {
                        $messages .= '<img src="images/stamp.jpg" />';
                    }
                    $messages .= "</p>";
                    $messages .= "<p><strong>" . $prizeStampMessage . "</strong></p>";
                }

                $messages .= "<strong>Η συναλλαγή του πελάτη ".$user['name']." ".$user['surname']." ολοκληρώθηκε με επιτυχία.</strong>\n";

                /* if requested to do also a checkout */
                if(!empty($_POST['pid'])) {
                    /* check if it is a valid prize */
                    $result = mysql_query("SELECT * FROM prizes WHERE id = " . mysql_real_escape_string($_POST['pid'],
                            $link)) or die(mysql_error());
                    $prizeRow = mysql_fetch_array($result);

                    $totalPointsForSMS = $totalPoints;

                    /* it is a valid prize */
                    if (strtotime($prizeRow['till_date']) > time() && $totalPoints >= $prizeRow['prize_points'] * $user['members_num']) {
                        /* if we DON'T remove the points with each checkout, this means we only have one entry for this checkout that we need to update to received = y */
                        if (!isset($settings['SESS_REMOVE_CHECKOUT_POINTS']) || $settings['SESS_REMOVE_CHECKOUT_POINTS'] == "0") {
                            /* find the checkout for this customer/prize/received=n and update it */
                            $updateQuery = "UPDATE checkouts SET received_date='" . date("Y-m-d H:i:s") . "', received='y', received_by_store_auto_id=" . $store_id . "
                                            WHERE prize_auto_id = " . $prizeRow['id'] . " AND customer_auto_id = " . $user['id'] . " AND received='n'";
                            $result = mysql_query($updateQuery) or die(mysql_error());
                        } /* if we remove the prize points from the customer */
                        else {
                            /* remove the prize points */
                            $insertQuery = "INSERT INTO transactions (`customer_auto_id`, `money`, `points`, `date`, `by`, `store_id`, `notes`, `services`)
                                            VALUES ('".$user['id']."', '0', " . ($prizeRow['prize_points'] * (-1)) . ", '" . date("Y-m-d H:i:s") . "', " . $me . ", " . $store_id . ", 'Εξαργύρωση προσφοράς', '');";

                            mysql_query($insertQuery, $link) or die(mysql_error());
                            $transactionIdCheckout = mysql_insert_id($link);

                            /* insert the new checkout row */
                            $insertQuery = "INSERT INTO checkouts (`transaction_auto_id`, `customer_auto_id`, `prize_auto_id`, `created_by_store_auto_id`, `date`, `received_date`, `received`, `received_by_store_auto_id`)
                                            VALUES ('" . $transactionIdCheckout . "', '" . $user['id'] . "', " . $prizeRow['id'] . ", " . $store_id . ", '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d H:i:s") . "', 'y', " . $store_id . ")";
                            mysql_query($insertQuery, $link) or die(mysql_error());

                            $totalPointsForSMS -= $prizeRow['prize_points'];
                            $totalPoints -= $prizeRow['prize_points'];
                        }

                        if ($settings['SESS_SMS_ENABLE_CHECKOUT'] == 'y' && $user['sms'] == "1" && $smsCredits > 0) {
                            $smsMsg = str_replace("surname", $user['surname'], $settings['SESS_SMS_MSG_CHECKOUT']);
                            $smsMsg = str_replace("name", $user['name'], $smsMsg);
                            $smsMsg = str_replace("customerId", $user['customer_id'], $smsMsg);
                            $smsMsg = str_replace("totalPoints", $totalPointsForSMS, $smsMsg);
                            $smsMsg = str_replace("prizePoints", $prizeRow['prize_points'], $smsMsg);
                            $smsMsg = str_replace("prizeMsg", $prizeRow['prize_msg'], $smsMsg);
                            $smsMsg = getLatinText($smsMsg);
                            $smsRes = sendSMS(array(SMS_COUNTRY_CODE . $phone), $smsMsg);
                            if ($smsRes) {
                                $smsCredits--;
                            }
                        } /* end of checkout sms */

                        if($settings['SESS_EMAIL_ENABLE_CHECKOUT'] == 'y' && filter_var($user['email'], FILTER_VALIDATE_EMAIL)){
                            $emailMsg = str_replace("surname", $user['surname'], $settings['SESS_EMAIL_MSG_CHECKOUT']);
                            $emailMsg = str_replace("name", $user['name'], $emailMsg);
                            $emailMsg = str_replace("customerId", $user['customer_id'], $emailMsg);
                            $emailMsg = str_replace("totalPoints", $totalPointsForSMS, $emailMsg);
                            $emailMsg = str_replace("prizePoints", $prizeRow['prize_points'], $emailMsg);
                            $emailMsg = str_replace("prizeMsg", $prizeRow['prize_msg'], $emailMsg);
                            $emailRes = sendEmail(array($user['email']), $emailMsg, $settings['SESS_EMAIL_SUB_CHECKOUT']);
                        }

                    } /* end of if valid prize */
                } /* end of if pid posted */
            }else{
                $messages .= "Η συναλλαγή δεν ολοκληρώθηκε γιατί είτε δε βρέθηκε ο πελάτης, είτε βρέθηκαν παραπάνω από ένας.";
                $fatalError = true;
            }
        }else{
            $messages .= "Η συναλλαγή δεν ολοκληρώθηκε γιατί υπήρξε κάποιο πρόβλημα.";
            $fatalError = true;
        }

        if(!$fatalError) {
            $offersMsg = "TO MEΓAΛYTEPO ΔΩPO ΠOY ΔIKAIOYΣTE EINAI: ";
            $foundBestPrize = false;

            //check if customer can have a prize
            $prizeResult = mysql_query("SELECT prizes.*, prizes.prize_points*".$user['members_num']." AS `prize_points` FROM prizes WHERE till_date > NOW() AND from_date < NOW() ORDER BY prize_points DESC")
            or die(mysql_error());

            $alreadyInformed = false;
            while($prize = mysql_fetch_array($prizeResult)) {
                if ($totalPoints >= $prize['prize_points'] && (is_null($prize['customer_custom']) || (isset($user['custom'.$prize['customer_custom']]) && $user['custom'.$prize['customer_custom']] == 'y'))){

                    if(!isset($settings['SESS_REMOVE_CHECKOUT_POINTS']) || $settings['SESS_REMOVE_CHECKOUT_POINTS'] == "0") {

                        $customer_auto_id = $user['id'];
                        $prize_id = $prize['id'];

                        /* check if he has already received this prize */
                        $checkoutsResult = mysql_query("SELECT * FROM checkouts WHERE customer_auto_id='$customer_auto_id' AND prize_auto_id='$prize_id'");
                        $rows = mysql_num_rows($checkoutsResult);

                        /* he can have this prize */
                        if($rows == 0) {
                            /* create a checkout.received = 'n' entry */
                            $insertCheckoutQuery = "INSERT INTO checkouts (`transaction_auto_id`, `customer_auto_id`, `prize_auto_id`, `created_by_store_auto_id`, `date`, `received`)
                                    VALUES ('$transactionId', '$customer_auto_id', '$prize_id', '".$store_id."','$dateNow', 'n');";
                            mysql_query($insertCheckoutQuery, $link) or die(mysql_error());

                            if(isset($settings['SESS_SMS_ENABLE_PRIZE']) && $settings['SESS_SMS_ENABLE_PRIZE'] == 'y' && $user['sms'] == "1" && $prize['sms_notify'] == "1" && $smsCredits > 0){
                                $smspMsg = str_replace("surname", $user['surname'], $settings['SESS_SMS_MSG_PRIZE']);
                                $smspMsg = str_replace("name", $user['name'], $smspMsg);
                                $smspMsg = str_replace("totalPoints", $totalPoints, $smspMsg);
                                $smspMsg = str_replace("prizePoints", $prize['prize_points'], $smspMsg);
                                $smspMsg = str_replace("prizeMsg", $prize['prize_msg'], $smspMsg);
                                $smspMsg = getLatinText($smspMsg);
                                $smspRes = sendSMS(array(SMS_COUNTRY_CODE.$phone), $smspMsg);
                                if($smspRes) {
                                    $messages .= "Ο πελάτης ενημερώθηκε με sms στο κινητό του για την απόκτηση προσφοράς.\n";
                                    $smsCredits--;
                                }
                            }

                            if(isset($settings['SESS_EMAIL_ENABLE_PRIZE']) && $settings['SESS_EMAIL_ENABLE_PRIZE'] == 'y' && filter_var($user['email'], FILTER_VALIDATE_EMAIL) && $prize['sms_notify'] == "1"){
                                $emailMsg = str_replace("surname", $user['surname'], $settings['SESS_EMAIL_MSG_PRIZE']);
                                $emailMsg = str_replace("name", $user['name'], $emailMsg);
                                $emailMsg = str_replace("totalPoints", $totalPoints, $emailMsg);
                                $emailMsg = str_replace("prizePoints", $prize['prize_points'], $emailMsg);
                                $emailMsg = str_replace("prizeMsg", $prize['prize_msg'], $emailMsg);
                                $emailRes = sendEmail(array($user['email']), $emailMsg, $settings['SESS_EMAIL_SUB_PRIZE']);
                                if($emailRes) {
                                    $messages .= "Ο πελάτης ενημερώθηκε με email για την απόκτηση προσφοράς.\n";
                                }
                            }
                        }
                    }
                    else {
                        if(!$alreadyInformed && $user['points'] < $prize['prize_points']) {
                            if(isset($settings['SESS_SMS_ENABLE_PRIZE']) && $settings['SESS_SMS_ENABLE_PRIZE'] == 'y' && $user['sms'] == "1" && $prize['sms_notify'] == "1" && $smsCredits > 0){
                                $smspMsg = str_replace("surname", $user['surname'], $settings['SESS_SMS_MSG_PRIZE']);
                                $smspMsg = str_replace("name", $user['name'], $smspMsg);
                                $smspMsg = str_replace("totalPoints", $totalPoints, $smspMsg);
                                $smspMsg = str_replace("prizePoints", $prize['prize_points'], $smspMsg);
                                $smspMsg = str_replace("prizeMsg", $prize['prize_msg'], $smspMsg);
                                $smspMsg = getLatinText($smspMsg);
                                $smspRes = sendSMS(array(SMS_COUNTRY_CODE.$phone), $smspMsg);
                                if($smspRes) {
                                    $messages .= "Ο πελάτης ενημερώθηκε με sms στο κινητό του για την απόκτηση προσφοράς.\n";
                                    $smsCredits--;
                                }
                            }

                            if(isset($settings['SESS_EMAIL_ENABLE_PRIZE']) && $settings['SESS_EMAIL_ENABLE_PRIZE'] == 'y' && filter_var($user['email'], FILTER_VALIDATE_EMAIL) && $prize['sms_notify'] == "1"){
                                $emailMsg = str_replace("surname", $user['surname'], $settings['SESS_EMAIL_MSG_PRIZE']);
                                $emailMsg = str_replace("name", $user['name'], $emailMsg);
                                $emailMsg = str_replace("totalPoints", $totalPoints, $emailMsg);
                                $emailMsg = str_replace("prizePoints", $prize['prize_points'], $emailMsg);
                                $emailMsg = str_replace("prizeMsg", $prize['prize_msg'], $emailMsg);
                                $emailRes = sendEmail(array($user['email']), $emailMsg, $settings['SESS_EMAIL_SUB_PRIZE']);
                                if($emailRes) {
                                    $messages .= "Ο πελάτης ενημερώθηκε με email για την απόκτηση προσφοράς.\n";
                                }
                            }
                            $alreadyInformed = true;
                        }

                        if(!$foundBestPrize) {
                            $offersMsg .= $prize['prize_msg'];
                            $foundBestPrize = true;
                        }
                    }

                    //break; /* Uncomment if you want to only receive the biggest price he can, not all */
                } // if he can have this prize
            } // while

            if(!$foundBestPrize) {
                $offersMsg = "";
            }

            if($settings['SESS_SMS_ENABLE_TRANSATION'] == 'y' && $user['sms'] == "1" && $smsCredits > 0 && $totalPoints > 0){
                $smsMsg = str_replace("surname", $user['surname'], $settings['SESS_SMS_MSG_TRANSACTION']);
                $smsMsg = str_replace("name", $user['name'], $smsMsg);
                $smsMsg = str_replace("customerId", $customer_id, $smsMsg);
                $smsMsg = str_replace("points", $points, $smsMsg);
                $smsMsg = str_replace("totalPoints", $totalPoints, $smsMsg);
                $smsMsg = str_replace("offers", $offersMsg, $smsMsg);
                $smsMsg = getLatinText($smsMsg);

                #echo '<p>Το sms που θα σταλεί στο : '.$phone.'<br />'.$smsMsg.'</p>';
                #$smsRes = true;
                $smsRes = sendSMS(array(SMS_COUNTRY_CODE.$phone), $smsMsg);
                if($smsRes) {
                    $messages .= "Ο πελάτης ενημερώθηκε με sms στο κινητό του για τη νέα του συναλλαγή.\n";
                    $smsCredits--;
                }
            }

            if($settings['SESS_EMAIL_ENABLE_TRANSACTION'] == 'y' && filter_var($user['email'], FILTER_VALIDATE_EMAIL)){
                $emailMsg = str_replace("surname", $user['surname'], $settings['SESS_EMAIL_MSG_TRANSACTION']);
                $emailMsg = str_replace("name", $user['name'], $emailMsg);
                $emailMsg = str_replace("customerId", $customer_id, $emailMsg);
                $emailMsg = str_replace("points", $points, $emailMsg);
                $emailMsg = str_replace("totalPoints", $totalPoints, $emailMsg);
                $emailMsg = str_replace("offers", $offersMsg, $emailMsg);
                $emailRes = sendEmail(array($user['email']), $emailMsg, $settings['SESS_EMAIL_SUB_TRANSACTION']);
                if($emailRes)
                    $messages .= 'Ο πελάτης ενημερώθηκε με email για τη νέα του συναλλαγή.';
                else
                    $messages .= 'Ο πελάτης ΔΕΝ ενημερώθηκε με email για τη νέα του συναλλαγή.';
            }
        } ?>


<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
    <meta charset="UTF-8">
    <title>Αποτέλεσμα επίσκεψης</title>
    <style type="text/css">
        *{
            font-size: 1.2em;
            font-family: Verdana, Arial, Helvetica, sans-serif;
        }
    </style>
</head>
<body style="margin: 0px 0px 40px 0px;">
<a href="javascript:window.print()" style="float:right;font-size: 0.9em;margin: 10px;">Εκτύπωση</a>
<div style="text-align: center"><img src="images/logo.jpg" style="padding: 10px 20px 30px" alt="logo" /><div style="clear: both"></div>
<p><?=nl2br($messages)?></p>
    <p style="margin:0;background:#3e3e3e;color:#EEEEEE;position:fixed;bottom:0;width:100%;line-height:30px;text-align:center;font-size:16px;">Loyalty Club application by New Media Business | Τηλ.: 2410 539535</p>
</body>
</html>

    <?php
        die();
    }
    /* Normal transaction */
    if(!defined("VISIT_ONLY") || !VISIT_ONLY) {
 ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
    <html>
        <head>
            <meta charset="UTF-8">
            <title>Νέα συναλλαγή</title>
            <script type="text/javascript">
                function addValue(number) {
                    var element = document.getElementById('m');
                    var element1 = document.getElementById('ma');
                    if(element.value.length < 5) {
                        element.value += number;
                        element1.value += number;
                    }
                }
                function clearValues() {
					document.getElementById('m').value = '';
                    document.getElementById('ma').value = '';
				}
				function checkCustomer() {
				    var xmlhttp;
				    xmlhttp=new XMLHttpRequest();
				    xmlhttp.open("GET", "bridge-getinfo.php?customer_id="+document.getElementById('cid').value, true);
                    xmlhttp.onreadystatechange = function () {
                         if ( xmlhttp.readyState == 4 && xmlhttp.status == 200 ) {
                            jsonObject = JSON.parse( xmlhttp.responseText );

                            if(jsonObject.status == 200) {
                                alert(jsonObject.message.name+" "+jsonObject.message.surname+" (" + jsonObject.message.phone + ")" +
                                "\nΠόντοι: " + jsonObject.message.points +
                                "\nΕπισκέψεις: " + jsonObject.message.total_visits);
                            }
                            else {
                                alert("Σφάλμα δικτύου ή ο πελάτης δε βρέθηκε");
                            }
                         }
                    };
                    xmlhttp.send(null);
				    return false;
				}
		function confirmDialog(moneypoints, visitpoints) {
            var money = document.getElementById('m').value;

		    var points = money*moneypoints + visitpoints;

		<?php
            if(ALLOW_SERVICES_MULTIPLY) {
                echo "var servicePoints = 0; var servicesCount = 0; ";
                if(isset($settings['SESS_SERVICES']) && $settings['SESS_SERVICES'] != ""){
                    $servno = explode(",", $settings['SESS_SERVICES']);
                    for($i=0; $i<sizeof($servno); $i++){
                        $txt=explode("(x", $servno[$i]);
                        $txt2=explode(")", $txt[1]);
                        $multiplier = trim($txt2[0]);
                        echo "\nif (document.getElementById('service".$i."').checked == true) {\n\t\tservicePoints += ".$multiplier." * money * moneypoints;\n\t\tservicesCount++;\n}\n";
                    }
                }
                echo "if(servicesCount > 1){\n\t\talert('Παρακαλώ επιλέξτε μόνο μια υπηρεσία.');\n\t\treturn false;\n}\n";
                echo "if (servicesCount != 0) {\n\t\tpoints = servicePoints + visitpoints;\n}";
            }
            ?>

			return confirm("Είστε σίγουρος για τη συναλλαγή;\n\nΘα προστεθούν "+points+" πόντοι στον πελάτη.");
		}
            </script>
            <style type="text/css">
                a.nav{font-size: 1.6em}
                input[type="checkbox"]:checked + label {
                    font-weight: bold;
                    background: url("images/apply.png") no-repeat left center;
                }
                input[type="checkbox"]:not(:checked) + label {
                    background: none;
                }
                input[type="checkbox"] + label {
                    padding: 10px 0 10px 35px;
                    display: block;
                    width: 100%;
                }
                input[type="checkbox"]
                {
                    display: none;
                }
            </style>
        </head>
        <body onload="document.getElementById('cid').focus();" style="margin: 0px 0px 40px 0px;">
        <a class="nav" href="bridge.php">Νέα συναλλαγή</a> | <a class="nav" href="bridge-checkouts.php">Εξαργυρώσεις</a> | <a class="nav" href="bridge-new-customer.php">Νέος πελάτης</a><br />
        <h1>Νέα συναλλαγή</h1>
            <div style="width:600px; margin: 10px auto;font-size:4em">
	            <form action="#" method="post">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" id="table1">
						<tr>
                            <td colspan="3" style="text-align: center">
                                <span style="font-size: 30pt;">Αρ. πελάτη</span>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align: center">
                                <input type="text" name="cid" id="cid" style="font-size: 60pt; width:80%" value="<?=(isset($_REQUEST['cid']) && $_REQUEST['cid'] != "0"?str_replace("viber://add?number=30", "", $_REQUEST['cid']):"");?>" />
                                <input type="button" style="font-size: 60pt; width:15%" onclick="checkCustomer();" value="?" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align: center">
                                <span style="font-size: 30pt;">Ποσό συναλλαγής</span>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align: center">
                                <input type="hidden" name="m" id="m" value="<?=(isset($_REQUEST['m']) && $_REQUEST['m'] != "0"?$_REQUEST['m']:"");?>" />
                                <input type="text" disabled="disabled" name="ma" id="ma" style="font-size: 60pt; width:99%" value="<?=(isset($_REQUEST['m']) && $_REQUEST['m'] != "0"?$_REQUEST['m']:"");?>" />
                            </td>
                        </tr>
                        <tr>
                            <td><input type="button" value="1" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('1');" /></td>
                            <td><input type="button" value="2" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('2')" /></td>
                            <td><input type="button" value="3" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('3')" /></td>
                        </tr>
                        <tr>
                            <td><input type="button" value="4" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('4')" /></td>
                            <td><input type="button" value="5" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('5')" /></td>
                            <td><input type="button" value="6" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('6')" /></td>

                        </tr>
                        <tr>
                            <td><input type="button" value="7" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('7')" /></td>
                            <td><input type="button" value="8" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('8')" /></td>
                            <td><input type="button" value="9" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('9')" /></td>
                        </tr>
                        <tr>
                            <td><input type="button" value="0" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('0')" /></td>
                            <td><input type="button" value="." style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="addValue('.')" /></td>
                            <td><input type="button" value="C" style="font-size: 60pt; font-weight: bold; width: 100%;" onclick="clearValues()" /></td>
                        </tr>
                        <tr>
                            <td colspan="3"><input type="submit" value="OK" onclick="return confirmDialog(<?php echo $settings['SESS_MONEY_POINTS'];?>, <?php echo $settings['SESS_VISIT_POINTS'];?>)" style="font-size: 40pt; font-weight: bold; width: 100%;height:103px;padding: 0" /></td>
                        </tr>
                        <?php
                            if(isset($settings['SESS_SERVICES']) && $settings['SESS_SERVICES'] != ""){
                                echo '<tr><td colspan="3">Υπηρεσίες</td></tr><tr>';
                                echo '  <td colspan="3">';
                                $service = explode(",", $settings['SESS_SERVICES']);
                                for($i=0; $i<sizeof($service); $i++){
                                    echo '<input type="checkbox" name="service'.$i.'" id="service'.$i.'" value="'.$service[$i].'" />
                                            <label for="service'.$i.'" >'.$service[$i].'</label>';
                                }
                                echo '  </td>';
                                echo '</tr>';
                            }
                            ?>
                    </table>
                </form>
            </div>
        <p style="margin:0;background:#3e3e3e;color:#EEEEEE;position:fixed;bottom:0;width:100%;line-height:30px;text-align:center;font-size:16px;">Loyalty Club application by New Media Business | Τηλ.: 2410 539535</p>
        </body>
    </html>
<?php
    die();
    }
    /* Display the quick visit form */
    else {
            ?>
                <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
                <html>
                    <head>
                        <meta charset="UTF-8">
                        <title>Νέα συναλλαγή</title>
                        <style type="text/css">
                            *{
                                font-size: 1.2em;
                                font-family: Verdana, Arial, Helvetica, sans-serif;
                            }
                            input[type="radio"]:checked + label {
                                font-weight: bold;
                                background: url("images/apply.png") no-repeat left center;
                            }
                            input[type="radio"]:not(:checked) + label {
                                background: none;
                            }
                            input[type="radio"] + label {
                                padding: 10px 0 10px 35px;
                                display: block;
                                width: 100%;
                            }
                            input[type="radio"]
                            {
                                display: none;
                            }
                        </style>
                        <script type="text/javascript">
                            var checkHappened = false;
                            var createCustomer = false;

                            function setUnchecked() {
                                checkHappened = false;
                                createCustomer = false;
                                document.getElementById("submitButton").value = 'Έλεγχος';
                                html = '<input type="radio" name="pid" id="checkout0" checked="checked" value=""><label for="checkout0">Χωρίς εξαργύρωση</label>';
                                document.getElementById("availableCheckouts").innerHTML = html;
                                return false;
                            }

                            function confirmDialog(){
                                if(document.getElementById('customer_id').value == 0){
                                    alert("Παρακαλώ εισάγετε αρ. πελάτη ή κινητού.");
                                    return false;
                                }
                                var visitpoints = <?=$settings['SESS_VISIT_POINTS'];?>;
                                if(!checkHappened && !createCustomer) {
                                    checkAvailableCheckouts(visitpoints);
                                    return false;
                                }
                                return true;
                            }
                            function checkAvailableCheckouts(visitpoints) {
                                var searchFor = "customer_id";
                                var customerId = document.getElementById("customer_id").value;
                                if(customerId.length >= 9) {
                                    searchFor = "phone";
                                }
                                var xmlhttp;
                                xmlhttp=new XMLHttpRequest();
                                xmlhttp.open("GET", "get-customer-checkouts.php?points="+visitpoints+"&"+searchFor+"="+customerId, true);
                                xmlhttp.onreadystatechange = function () {
                                    if ( xmlhttp.readyState == 4 && xmlhttp.status == 200 ) {
                                        jsonObject = JSON.parse( xmlhttp.responseText );

                                        if(jsonObject.status == 200) {
                                            var html = "";
                                            if(jsonObject.points) {
                                                html = html + "<div>";
                                                for(var j=0; j < jsonObject.points; j++) {
                                                    html = html + '<img src="images/stamp.jpg" />'
                                                }
                                                html = html + "</div>";
                                            }

                                            for(var i=0; i < jsonObject.message.length; i++) {
                                                html = html + '<input type="radio" name="pid" id="checkout' + jsonObject.message[i].id + '" value="' + jsonObject.message[i].id + '">';
                                                html = html + '<label for="checkout' + jsonObject.message[i].id + '">';
                                                html = html + jsonObject.message[i].prize_msg + " (" + jsonObject.message[i].prize_points + " πόντοι)";
                                                html = html + "</label>";
                                            }

                                            if(jsonObject.points == null) {
                                                html = '<p>Ο πελάτης δε βρέθηκε!</p>';
                                                document.getElementById("availableCheckouts").innerHTML = html;
                                                document.getElementById("submitButton").value = 'Δημιουργία πελάτη';
                                                document.getElementById("transaction").action = 'bridge-new-customer-quick.php?cid=' + document.getElementById("customer_id").value;
                                                createCustomer = true;
                                            }
                                            else {
                                                html = html + '<input type="radio" name="pid" id="checkout0" checked="checked" value=""><label for="checkout0">Χωρίς εξαργύρωση</label>';
                                                document.getElementById("availableCheckouts").innerHTML = html;
                                                checkHappened = true;
                                                createCustomer = false;
                                                document.getElementById("submitButton").value = 'Ολοκλήρωση συναλλαγής';
                                            }
                                        }
                                        else {
                                            alert(jsonObject.message);
                                        }
                                    }
                                };
                                xmlhttp.send(null);
                            }
                        </script>
                    </head>
                    <body style="margin: 0px 0px 40px 0px;" onload="<?= !empty($customer_id) && defined("SKIP_CHECK") && SKIP_CHECK == true ? "document.getElementById('transaction').submit()": "" ?>">
                        <form method="post" action="bridge.php" name="transaction" id="transaction">
                            <input type="hidden" value="<?=date("Y-m-d H:i:s");?>" name="date" />
                            <table width="100%" border="1">
                                <tr><th colspan="2">Αρ. πελάτη ή κινητού</th></tr>
                                <tr>
                                    <td align="center"><input style="width: 100%" type="text" name="cid" id="customer_id" value="<?=$customer_id?>" onkeyup="return setUnchecked()"/></td>

                                </tr>
                                <tr>
                                    <td style="font-size: 0.8em">
                                        <div id="availableCheckouts">
                                            <input type="radio" value="" id="checkout0" checked="checked" name="pid"/><label for="checkout0">Χωρίς εξαργύρωση</label>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center">
                                        <input style="width: 100%" type="submit" id="submitButton" value="Έλεγχος" onclick="return confirmDialog();"/>
                                    </td>
                                </tr>
                            </table>
                        </form>
                        <p style="margin:0;background:#3e3e3e;color:#EEEEEE;position:fixed;bottom:0;width:100%;line-height:30px;text-align:center;font-size:16px;">Loyalty Club application by New Media Business | Τηλ.: 2410 539535</p>
                    </body>
                </html>
<?php
            die();
    }
}

if (isset($_REQUEST['m']) && $_REQUEST['m'] != "")
	$money = $_REQUEST['m'];
else
	$money = "0";

$points = $money * $settings["SESS_MONEY_POINTS"] + $settings["SESS_VISIT_POINTS"];

$dateNow = date("Y-m-d H:i:s");

$notes = "";
$services = "";
$phone = '0';

if(ALLOW_SERVICES_MULTIPLY){

    $pointsFromServices = 0;
    $servicesUsed = false;
    if (isset($settings['SESS_SERVICES']) && $settings['SESS_SERVICES'] != "") {
        $servno = explode(",", $settings['SESS_SERVICES']);
        for ($i = 0; $i < sizeof($servno); $i++) {
            if (isset($_POST['service' . $i])) {
                if ($services != "")
                    $services .= ",";
                $services .= $servno[$i];

                $serviceString = $servno[$i];

                $txt = explode("(x", $serviceString);
                $txt2 = explode(")", $txt[1]);
                $multiplier = trim($txt2[0]);

                $pointsFromServices += $multiplier * $money * $settings['SESS_MONEY_POINTS'];
                $servicesUsed = true;
                break;
            }
        }
    }

    if($servicesUsed) {
        $points = $pointsFromServices + $settings['SESS_VISIT_POINTS'];
    }
}
else {
    if(isset($settings['SESS_SERVICES']) && $settings['SESS_SERVICES'] != ""){
        $servno = explode(",", $settings['SESS_SERVICES']);
        for($i=0; $i<sizeof($servno); $i++){
            if(isset($_POST['service'.$i])){
                if($services != "")
                    $services .= ",";
                $services .= $servno[$i];
            }
        }
    }
}

$redirect = 'no';

if ($customer_id == '' && $phone == '0') {
	if ($json)
		echo json_encode(array('status' => 500, 'error' => 'You did not sent any customer id'));
	else
		echo "Δεν επιλέξατε κάποιο πελάτη";
	exit();
}

//check if the user exist in the database

if (strlen($customer_id) >= 9) {
    $qry = "SELECT customers.*, SUM( transactions.points ) AS points, SUM( transactions.money ) AS money, COUNT( * ) AS visits
            FROM  customers, transactions
            WHERE transactions.customer_auto_id = customers.id AND customers.phone LIKE '$customer_id'";
}
else {
    $qry = "SELECT customers.*, SUM( transactions.points ) AS points, SUM( transactions.money ) AS money, COUNT( * ) AS visits
            FROM  customers, transactions
            WHERE transactions.customer_auto_id = customers.id AND customers.customer_id LIKE '$customer_id'";
}

$result = mysql_query($qry);
//Check whether the query was successful or not
if ($result) {
	if (mysql_num_rows($result) == 1) {
		$user = mysql_fetch_array($result);
		if (is_null($user['id']) || $user['id'] == "") {
            if (strlen($customer_id) >= 9) {
                $qry = "SELECT * FROM customers WHERE phone LIKE '$customer_id'";
            }
            else {
                $qry = "SELECT * FROM customers WHERE customer_id LIKE '$customer_id'";
            }

			$custres = mysql_query($qry) or die(mysql_error());
			$user = mysql_fetch_array($custres);
			if (is_null($user['id'])) {
				if ($json) {
                    echo json_encode(array(
                        'status' => 500,
                        'error' => 'Could not find customer with id ' . $customer_id
                    ));
                }
				else {
                    if(defined("VISIT_ONLY") && VISIT_ONLY) {
                        echo "<script type='text/javascript'>window.location.replace('bridge-new-customer-quick.php?cid=".$customer_id."');</script>";
                    }
                    else {
                        echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
                <html><head><meta charset="UTF-8"></head><body>
                <h2>Δε βρέθηκε ο πελάτης.
                <a href="bridge.php">Προσπαθήστε ξανά</a> ή δημιουργήστε <a href="bridge-new-customer.php?cid=' . $customer_id . '">νέο πελάτη</a>.
                </h2></body></html>';
                    }
                }
				exit();
			}
			$user['points'] = 0;
			$user['money'] = 0;
			$user['visits'] = 0;
		}
		$customer_auto_id = $user['id'];
		$customer_id = $user['customer_id'];

		if (CHECK_LAST_TRANSACTION) {
			$sql = "SELECT UNIX_TIMESTAMP(`date`) AS `date` FROM `transactions` WHERE `customer_auto_id` = " . $customer_auto_id . " ORDER BY `transactions`.`date` DESC LIMIT 1";
			$transres = mysql_query($sql) or die(mysql_error());
			$lastTransaction = mysql_fetch_array($transres);
			if (strtotime("-" . LAST_TRANSACTION) < $lastTransaction['date']) {
				echo json_encode(array('status' => 500, 'error' => 'There is already a transaction for this customer in the last ' . LAST_TRANSACTION));
				exit();
			}
		}

		//customer found successfully, do the transaction
		$insertQuery = "INSERT INTO transactions (`customer_auto_id`, `money`, `points`, `date`, `by`, `store_id`, `notes`, `services`)
                                                VALUES ('$customer_auto_id', '$money', '$points', '$dateNow', '$me', '$store_id', '$notes', '$services');";

		mysql_query($insertQuery, $link) or die(mysql_error());

        addReferralPoints($user['customer_id'], $user['rel_customer_id'], $money * $settings['SESS_REFERRALMONEYPOINTS'], $me, $store_id, $dateNow);

		$transactionId = mysql_insert_id($link);
		$totalPoints = $points + $user['points'];
		$totalMoney = $money + $user['money'];

	}
	else {
        if ($json) {
            echo json_encode(array(
                'status' => 500,
                'error' => 'Could not find customer with id ' . $customer_id
            ));
        }
        else {
            if(defined("VISIT_ONLY") && VISIT_ONLY) {
                echo "<script type='text/javascript'>window.location.replace('bridge-new-customer-quick.php?cid=".$customer_id."');</script>";
            }
            else {
                echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
                <html><head><meta charset="UTF-8"></head><body>
                <h2>Δε βρέθηκε ο πελάτης. <a href="bridge.php">Προσπαθήστε ξανά</a> ή δημιουργήστε <a href="bridge-new-customer.php?cid=' . $customer_id . '">νέο πελάτη</a>.</h2></body></html>';
            }
        }
        exit();
	}
}
else {
    if ($json) {
        echo json_encode(array(
            'status' => 500,
            'error' => 'Could not find customer with id ' . $customer_id
        ));
    }
    else {
        if(defined("VISIT_ONLY") && VISIT_ONLY) {
            echo "<script type='text/javascript'>window.location.replace('bridge-new-customer-quick.php?cid=".$customer_id."');</script>";
        }
        else {
            echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
                <html><head><meta charset="UTF-8"></head><body>
                <h2>Δε βρέθηκε ο πελάτης. <a href="bridge.php">Προσπαθήστε ξανά</a> ή δημιουργήστε <a href="bridge-new-customer.php?cid=' . $customer_id . '">νέο πελάτη</a>.</h2></body></html>';
        }
    }
	exit();
}

ob_start();
$smsNum = 0;
$offersMsg = "TO MEΓAΛYTEPO ΔΩPO ΠOY ΔIKAIOYΣTE EINAI: ";
$foundBestPrize = false;

//check if customer can have a prize
$prizeResult = mysql_query("SELECT prizes.*, prizes.prize_points*".$user['members_num']." AS `prize_points` FROM prizes WHERE till_date > NOW() AND from_date < NOW() ORDER BY prize_points DESC")
or die(mysql_error());

$prizes = array();
$alreadyInformed = false;
$messagePrize = "";
while ($prize = mysql_fetch_array($prizeResult)) {
	if ($totalPoints >= $prize['prize_points'] && (is_null($prize['customer_custom']) || (isset($user['custom'.$prize['customer_custom']]) && $user['custom'.$prize['customer_custom']] == 'y'))) {

        /* if we do not remove the prize points when he checkout the prize, check if he has already won this prize */
        if(!isset($settings['SESS_REMOVE_CHECKOUT_POINTS']) || $settings['SESS_REMOVE_CHECKOUT_POINTS'] == "0"){
            $customer_auto_id = $user['id'];
            $prize_id = $prize['id'];

            /* check if he has already received this prize */
            $checkoutsResult = mysql_query("SELECT * FROM checkouts WHERE customer_auto_id='$customer_auto_id' AND prize_auto_id='$prize_id'");
            $rows = mysql_num_rows($checkoutsResult);

            /* he can have this prize */
            if($rows == 0) {
                /* create a checkout.received = 'n' entry */
                $insertCheckoutQuery = "INSERT INTO checkouts (`transaction_auto_id`, `customer_auto_id`, `prize_auto_id`, `created_by_store_auto_id`, `date`, `received`)
                            VALUES ('$transactionId', '$customer_auto_id', '$prize_id', '".STORE_ID."','$dateNow', 'n');";
                mysql_query($insertCheckoutQuery, $link) or die(mysql_error());

                $checkoutid = mysql_insert_id($link);

                /* inform him for the prize he won */
                if($user['sms'] == "1" && $settings['SESS_SMS_ENABLE_PRIZE'] == 'y' && $prize['sms_notify'] == "1"){
                    $smspMsg = str_replace("surname", $user['surname'], $settings['SESS_SMS_MSG_PRIZE']);
                    $smspMsg = str_replace("name", $user['name'], $smspMsg);
                    $smspMsg = str_replace("totalPoints", $totalPoints, $smspMsg);
                    $smspMsg = str_replace("prizePoints", $prize['prize_points'], $smspMsg);
                    $smspMsg = str_replace("prizeMsg", $prize['prize_msg'], $smspMsg);
                    $smspMsg = getLatinText($smspMsg);
                    $smspRes = sendSMS(array(SMS_COUNTRY_CODE . $user['phone']), $smspMsg);
                    if($smspRes)
                        $messagePrize .= '<p class="main">Ο πελάτης ενημερώθηκε με sms στο κινητό του για την απόκτηση της προσφοράς:</p>'.$smspMsg;
                    else
                        $messagePrize .= '<p class="main">Ο πελάτης ΔΕΝ ενημερώθηκε με sms για την απόκτηση της προσφοράς.</p>';
                }

                if($settings['SESS_EMAIL_ENABLE_PRIZE'] == 'y' && filter_var($user['email'], FILTER_VALIDATE_EMAIL) && $prize['sms_notify'] == "1"){
                    $emailMsg = str_replace("surname", $user['surname'], $settings['SESS_EMAIL_MSG_PRIZE']);
                    $emailMsg = str_replace("name", $user['name'], $emailMsg);
                    $emailMsg = str_replace("totalPoints", $totalPoints, $emailMsg);
                    $emailMsg = str_replace("prizePoints", $prize['prize_points'], $emailMsg);
                    $emailMsg = str_replace("prizeMsg", $prize['prize_msg'], $emailMsg);
                    $emailRes = sendEmail(array($user['email']), $emailMsg, $settings['SESS_EMAIL_SUB_PRIZE']);
                    if($emailRes)
                        $messagePrize .= '<p class="main">Ο πελάτης ενημερώθηκε με email για την απόκτηση της προσφοράς</p>';
                    else
                        $messagePrize .= '<p class="main">Ο πελάτης ΔΕΝ ενημερώθηκε με email για την απόκτηση της προσφοράς.</p>';

                }
                $prizes[] = array('points' => $prize['prize_points'], 'message' => $prize['prize_msg'], "prizeid" => $prize['id'], "checkoutid" => $checkoutid);
            }
            /* we have already created this checkout for this prize, check if it's not received to include in the list of available prizes to checkout */
            else {
                $checkoutsUnreceived = mysql_fetch_array($checkoutsResult);
                if($checkoutsUnreceived['received'] != 'y') {
                    $prizes[] = array('points' => $prize['prize_points'], 'message' => $prize['prize_msg'], "prizeid" => $prize['id'], "checkoutid" => $checkoutsUnreceived['id']);
                }
            }
        }
        else {
            if(!$alreadyInformed && $user['points'] < $prize['prize_points']) {
                /* inform him for the prize he won */
                if($user['sms'] == "1"  && $prize['sms_notify'] == "1" && $settings['SESS_SMS_ENABLE_PRIZE'] == 'y'){
                    $smspMsg = str_replace("surname", $user['surname'], $settings['SESS_SMS_MSG_PRIZE']);
                    $smspMsg = str_replace("name", $user['name'], $smspMsg);
                    $smspMsg = str_replace("totalPoints", $totalPoints, $smspMsg);
                    $smspMsg = str_replace("prizePoints", $prize['prize_points'], $smspMsg);
                    $smspMsg = str_replace("prizeMsg", $prize['prize_msg'], $smspMsg);
                    $smspMsg = getLatinText($smspMsg);
                    $smspRes = sendSMS(array(SMS_COUNTRY_CODE . $user['phone']), $smspMsg);
                    if($smspRes)
                        $messagePrize .= '<p class="main">Ο πελάτης ενημερώθηκε με sms στο κινητό του για την απόκτηση της προσφοράς:</p>'.$smspMsg;
                    else
                        $messagePrize .= '<p class="main">Ο πελάτης ΔΕΝ ενημερώθηκε με sms για την απόκτηση της προσφοράς.</p>';
                }

                if($settings['SESS_EMAIL_ENABLE_PRIZE'] == 'y' && filter_var($user['email'], FILTER_VALIDATE_EMAIL) && $prize['sms_notify'] == "1"){
                    $emailMsg = str_replace("surname", $user['surname'], $settings['SESS_EMAIL_MSG_PRIZE']);
                    $emailMsg = str_replace("name", $user['name'], $emailMsg);
                    $emailMsg = str_replace("totalPoints", $totalPoints, $emailMsg);
                    $emailMsg = str_replace("prizePoints", $prize['prize_points'], $emailMsg);
                    $emailMsg = str_replace("prizeMsg", $prize['prize_msg'], $emailMsg);
                    $emailRes = sendEmail(array($user['email']), $emailMsg, $settings['SESS_EMAIL_SUB_PRIZE']);
                    if($emailRes)
                        $messagePrize .= '<p class="main">Ο πελάτης ενημερώθηκε με email για την απόκτηση της προσφοράς.</p>';
                    else
                        $messagePrize .= '<p class="main">Ο πελάτης ΔΕΝ ενημερώθηκε με email για την απόκτηση της προσφοράς.</p>';
                }
                $alreadyInformed = true;
            }

            if(!$foundBestPrize) {
                $offersMsg .= $prize['prize_msg'];
                $foundBestPrize = true;
            }

            $prizes[] = array('points' => $prize['prize_points'], 'message' => $prize['prize_msg'], "prizeid" => $prize['id'], "checkoutid" => 0);
        }

		//break; /* Receive only the biggest price you can, not all */
	}
}

if(!$foundBestPrize) {
    $offersMsg = "";
}
ob_clean();

if ($json)
	echo json_encode(array('status' => 200, 'totalpoints' => $totalPoints, 'prizes' => $prizes, 'sms' => $smsNum));
else {

    if ($settings['SESS_SMS_ENABLE_TRANSATION'] == 'y' && $user['sms'] == "1") {
        $smsMsg = str_replace("surname", $user['surname'], $settings['SESS_SMS_MSG_TRANSACTION']);
        $smsMsg = str_replace("name", $user['name'], $smsMsg);
        $smsMsg = str_replace("customerId", $customer_id, $smsMsg);
        $smsMsg = str_replace("points", $points, $smsMsg);
        $smsMsg = str_replace("totalPoints", $totalPoints, $smsMsg);
        $smsMsg = str_replace("offers", $offersMsg, $smsMsg);
        $smsMsg = getLatinText($smsMsg);
        $smsRes = sendSMS(array(SMS_COUNTRY_CODE . $user['phone']), $smsMsg);
        if ($smsRes) {
            $smsNum++;
        }
    }

    if($settings['SESS_EMAIL_ENABLE_TRANSACTION'] == 'y' && filter_var($user['email'], FILTER_VALIDATE_EMAIL)) {
        $emailMsg = str_replace("surname", $user['surname'], $settings['SESS_EMAIL_MSG_TRANSACTION']);
        $emailMsg = str_replace("name", $user['name'], $emailMsg);
        $emailMsg = str_replace("customerId", $customer_id, $emailMsg);
        $emailMsg = str_replace("points", $points, $emailMsg);
        $emailMsg = str_replace("totalPoints", $totalPoints, $emailMsg);
        $emailMsg = str_replace("offers", $offersMsg, $emailMsg);
        $emailRes = sendEmail(array($user['email']), $emailMsg, $settings['SESS_EMAIL_SUB_TRANSACTION']);
    }

    echo '
    <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
			<html>
			  <head>
			  	<meta charset="UTF-8">
				<title>Η συναλλαγή ολοκληρώθηκε</title>
				<style type="text/css">*{font-size: 1.2em}</style>
				<script src="https://www.google.com/cloudprint/client/cpgadget.js"></script>
				<script type="text/javascript">
				function printCloud() {
                    document.getElementById("img-logo").style.display = "none";
                    document.getElementById("store-info").style.display = "block";
                    var x = document.getElementsByClassName("button");
                    var i;
                    for (i = 0; i < x.length; i++) {
                        x[i].style.display = "none";
                    } 
                    var gadget = new cloudprint.Gadget();
                    gadget.setPrintDocument("text/html", "Print", document.getElementById("printable").innerHTML);
                    gadget.openPrintDialog();
                    document.getElementById("img-logo").style.display = "block";
                    document.getElementById("store-info").style.display = "none";
                    var x = document.getElementsByClassName("button");
                    var i;
                    for (i = 0; i < x.length; i++) {
                        x[i].style.display = "block";
                    } 
                }
                </script>
			  </head>
			  <body style="margin: 0px 0px 40px 0px;">';

    if(defined("VISIT_ONLY") && VISIT_ONLY) {
        echo '<div style="text-align: center"><img id="img-logo" src="images/logo.jpg" style="padding: 10px 20px 30px" alt="logo" /><div style="clear: both"></div>';
        for ($i=1;$i<=$totalPoints;$i++) {
            echo '<img src="images/stamp.jpg" style="float: left" />';
            if(!empty($prizes)) {
                foreach($prizes as $prize) {
                    if($i == $prize["points"]) {
                        echo '<div style="clear: both"></div>';
                        echo '<form method="post" action="#">';
                        echo '<input type="hidden" name="checkoutid" value="' . $prize["checkoutid"] . '" />';
                        echo '<input type="hidden" name="prizeid" value="' . $prize["prizeid"] . '" />';
                        echo '<input type="hidden" name="prizepoints" value="' . $prize["points"] . '" />';
                        echo '<input type="hidden" name="cid" value="' . $user['customer_id'] . '" />';
                        echo $prize["message"].' <input type="submit" value="Εξαργύρωση" />';
                        echo '</form>';
                        echo '<hr />';
                    }
                }
            }
        }
        echo '</div>';
    }
    else {
        echo '
			  	<a class="nav" href="bridge.php">Νέα συναλλαγή</a> | <a class="nav" href="bridge-checkouts.php">Εξαργυρώσεις</a> | <a class="nav" href="bridge-new-customer.php">Νέος πελάτης</a> | <a href="#" onClick="return printCloud();">Εκτύπωση</a><br />
			  	<div style="width:600px; margin: 20px auto;font-size:1.7em" id="printable">
			  	<img id="img-logo" src="images/logo.jpg"/>
			  	<p id="store-info" style="display: none">'.$storesDetails[$store_id]['store_id'].'<br>'.
            'ΑΦΜ: '.$storesDetails[$store_id]['afm'].'<br>'.
            $storesDetails[$store_id]['street'].' '.$storesDetails[$store_id]['city'].'<br>'.
            'Τηλ.: '.$storesDetails[$store_id]['phone'].
            '</p>
				<p><strong>Η συναλλαγή ολοκληρώθηκε</strong></p>
				<p>Πελάτης : <strong>' . $user['name'] . ' ' . $user['surname'] . ' (' . $customer_id . ')</strong><br>
				Πόντοι συναλλαγής : <strong>' . $points . '</strong> <br>
				Συνολικοί πόντοι : <strong>' . $totalPoints . '</strong></p>';

        echo $messagePrize;
        if (isset($prizes) && is_array($prizes) && count($prizes)) {
            echo '<p><strong>Μπορείτε να επιλέξετε ανάμεσα στις παρακάτω προσφορές: </strong></p>';
            foreach ($prizes as $prize) {
                echo '<form method="post" action="#">';
                echo '<input type="hidden" name="checkoutid" value="' . $prize["checkoutid"] . '" />';
                echo '<input type="hidden" name="prizeid" value="' . $prize["prizeid"] . '" />';
                echo '<input type="hidden" name="prizepoints" value="' . $prize["points"] . '" />';
                echo '<input type="hidden" name="cid" value="' . $user['customer_id'] . '" />';
                echo '<p>' . $prize["message"] . " (" . $prize["points"] . ' πόντοι) <input type="submit" class="button" value="Εξαργύρωση" /></p>';
                echo '</form>';
            }
        }
        echo '		</div>';
        if($smsNum > 0) {
            echo '<p class="main">Ο πελάτης ενημερώθηκε με sms στο κινητό του για την ολοκλήρωση της συναλλαγής.</p>';
        }
    }

    echo '        <p style="margin:0;background:#3e3e3e;color:#EEEEEE;position:fixed;bottom:0;width:100%;line-height:30px;text-align:center;font-size:16px;">Loyalty Club application by New Media Business | Τηλ.: 2410 539535</p>
        	  </body>
			</html>';
}

function str2num($str) {
	if (strpos($str, '.') < strpos($str, ',')) {
		$str = str_replace('.', '', $str);
		$str = strtr($str, ',', '.');
	}
	else {
		$str = str_replace(',', '', $str);
	}

	return (float)$str;
}

?>

