<?php

//require_once 'utils/SQLFilter.php';

class ApiUserService {
   
    private $apiUserDao;
    
    /**
     * @param ApiUserDao $apiUserDao
     */
    function __construct($apiUserDao) {
        $this->apiUserDao = $apiUserDao;
    }
    
    function findAll($sqlFilter = null) {
        return $this->apiUserDao->findAll($sqlFilter);
    }
    
    function findById($id) {
        return $this->apiUserDao->findById($id);
    }
    
    function save($apiUser) {
        return $this->apiUserDao->save($apiUser);
    }
    
    function delete($apiUser) {
        return $this->apiUserDao->delete($apiUser);
    }


    /**
     * Determines whether the provided token 
     * is valid or not
     * @param string $token the Basic Authentication token
     * @return boolean
     */
    function isBasicAuthenticationTokenValid($token) {
        $credentials = base64_decode($token);
        $credentials_parts = explode(":", $credentials);
        //Not valid basic authentication token
        if(count($credentials_parts) != 2) {
            return false;
        }
        
        $username = $credentials_parts[0];
        $password = $credentials_parts[1];
        $result = $this->apiUserDao->findAll((new SQLFilter("name = $username"))->andExpr("password = $password"));
        return count($result) != 0;
    }
}
