<!doctype html>
<html lang="en">
    <?php
    require_once 'DatabaseConnector.php';
    require_once 'Dao.php';
    require_once 'PromotionClass.php';
    ?>

    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <!-- Required meta tags -->
        
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO"
              crossorigin="anonymous">
        <link rel="stylesheet" href="parts/styles.css">
    </head>

    <body>
        <main>
            <?php
            
            $search_by_customer_id = false;
            $search_by_category = false;
            if(isset($_GET['customer_id'])) {   //θα πρέπει να ξεκαθαρίσουμε με τι παράμετρο καλέστηκε το αρχείο γιατί αλλάζει η μέθοδος αναζήτησης
                $search_by_customer_id = true;
            }
            else if (isset($_GET['category'])) {
                $search_by_category = true;
            }
            else {
                die("Bad params...");
            }
            
            
            $connector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
            $mysqlConnection = $connector->getConnection();
            $dao = new Dao($mysqlConnection);

            //Στον πίνακα βάζω ή αφαιρώ χρώματα
            $colors = array("#eee7e6", "#ffffff");
            $color_len = count($colors);
            $color = 0;
            ?>

            <div class="list-group">


                <?php
                    $customer_id;
                    $category;
                    $promotions;
                    
                    if($search_by_customer_id) {
                        $customer_id = secureInput($_GET['customer_id']);
                        $promotions = $dao->getNotExpiredPromotions();
                    }
                    else {
                        $category = secureInput($_GET['category']);
                        $promotions = $dao->getLastPromotionByCategory($category);
                    }
   
                    foreach ($promotions as $promotion) {
                    if($search_by_category || $dao->userIsInCategory($customer_id, $promotion->getCategory())) { ?>
                        <a href="#" class="list-group-item list-group-item-action flex-column align-items-start" style="border:dashed; background-color: <?= $colors[$color] ?>">
                            <div class="d-flex w-100 justify-content-between">
                                <h5 class="mb-1" style="color: red">
        <?= $promotion->getTitle() ?>
                                </h5>
                                
                                
                                
                                </div>
                            <p class="mb-1">
        <?= $promotion->getBody() ?>
                            </p>
                        <img src="images/logo.png" width="100" align="right">
                            
        </small>
                            <div><small><?= IMEROMINIA_EKDOSIS . " " . substr($promotion->getEntryDate(), 0, strlen($promotion->getEntryDate()) - 5) ?></small></div>
                            <br>
<?php
                                    if ($promotion->getExpireDate() != "0000-00-00") {
                                         echo "<small>" . IMEROMINIA_LIXIS . " " . $promotion->getExpireDate() . "</small>";
                                    }?>
                        </a>

                        <?php
                        if ($color == $color_len - 1) {
                            $color = 0;
                        } else {
                            $color++;
                        }
                    }
                    }
                    
                    

                ?>

            </div>

        </main>
    </body>

</html>

