<?php
	header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    
	require_once('auth.php');
	require('admin.php');
	require('header.php');


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title><?php echo CREATE_OFFER; ?></title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<link href="calendar.css" type="text/css" rel="stylesheet" />
<script language="JavaScript" src="form_validator.js"
    type="text/javascript" xml:space="preserve">
</script>
<script src="calendar.js" type="text/javascript"></script>
<script type="text/javascript">
function counter() {
		var text = document.getElementById('prize_msg').value;
/*
		document.getElementById('prize_msg').value = text.toUpperCase();
*/
		var msgs = 1;
		var len = document.getElementById('prize_msg').value.length;
		document.getElementById('chars').innerHTML = len;
		
		if (len > 89) 
			document.getElementById('prize_msg').value = text.substring(0, 89);
	}

    function setAgeFrom() {
        document.getElementById("from_date").value = document.getElementById("from_year").value + '/' + document.getElementById("from_month").value + '/' + document.getElementById("from_day").value;
    }

    function setAgeTill() {
        document.getElementById("till_date").value = document.getElementById("till_year").value + '/' + document.getElementById("till_month").value + '/' + document.getElementById("till_day").value;
    }
</script>
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
</head>

<body>
	
<?php headerDiv();?>


<div class="main">
<h1><?php echo CREATE_NEW_OFFER; ?></h1>
	<div id="new-prize_errorloc"></div>

	<form action="admin-new-prize-exec.php" method="post" name="new-prize" id="new-prize" >
	<table class="main">
		<tr>
			<td><?php echo POINTS_FOR_OFFER_ACQUISITION; ?></td>
			<td><input type="text" name="prize_points" size="20"/> *</td>
		</tr>
		<tr>
			<td><?php echo FROM; ?></td>
			<td>
                <select id="from_day" onchange="setAgeFrom()">
                    <option value=""><?php echo DAY; ?></option>
                    <?php for($i = 1; $i <= 31; $i++) echo '<option value="'.str_pad($i, 2, '0', STR_PAD_LEFT).'">'.$i.'</option>'; ?>
                </select>

                <select id="from_month" onchange="setAgeFrom()">
                    <option value=""><?php echo MONTH; ?></option>
                    <?php for($i = 1; $i <= 12; $i++) echo '<option value="'.str_pad($i, 2, '0', STR_PAD_LEFT).'">'.$i.'</option>'; ?>
                </select>

                <select id="from_year" onchange="setAgeFrom()">
                    <option value=""><?php echo YEAR; ?></option>
                    <?php for($i = date("Y", strtotime("+6 years")); $i >= date("Y", strtotime("-3 years")); $i--) echo '<option value="'.$i.'">'.$i.'</option>'; ?>
                </select>

                <input type="hidden" name="from_date" id="from_date" /> *
            </td>
		</tr>
		<tr>
			<td><?php echo TO; ?></td>
			<td>
                <select id="till_day" onchange="setAgeTill()">
                    <option value=""><?php echo DAY; ?></option>
                    <?php for($i = 1; $i <= 31; $i++) echo '<option value="'.str_pad($i, 2, '0', STR_PAD_LEFT).'">'.$i.'</option>'; ?>
                </select>

                <select id="till_month" onchange="setAgeTill()">
                    <option value=""><?php echo MONTH; ?></option>
                    <?php for($i = 1; $i <= 12; $i++) echo '<option value="'.str_pad($i, 2, '0', STR_PAD_LEFT).'">'.$i.'</option>'; ?>
                </select>

                <select id="till_year" onchange="setAgeTill()">
                    <option value=""><?php echo YEAR; ?></option>
                    <?php for($i = date("Y", strtotime("+6 years")); $i >= date("Y", strtotime("-3 years")); $i--) echo '<option value="'.$i.'">'.$i.'</option>'; ?>
                </select>

                <input type="hidden" name="till_date" id="till_date" /> *
            </td>
		</tr>
		<tr>
			<td><?php echo MEMBER_CATEGORY; ?></td>
			<td>
				<select name="customer_custom" style="width: 156px">
					<option value=""><?php echo ALL; ?></option>
					<?php
						for ($i = 1; $i <= CUSTOM_FIELDS_NUM; $i++) {
							if(isset($_SESSION['SESS_CUSTOM_FIELD' . $i]) && $_SESSION['SESS_CUSTOM_FIELD' . $i] != "" && isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "1") {
								echo '<option value="' . $i . '">' . $_SESSION['SESS_CUSTOM_FIELD' . $i] . '</option>';
							}
						}
					?>
				</select>
			</td>
		</tr>
		<tr>
			<td><?php echo OFFER_MESSAGE_UP_TO_90_CHARS; ?></td>
			<td><textarea name="prize_msg" id="prize_msg" style="margin:2px; width:150px; height:100px" onKeyDown="counter();" onKeyUp="counter();"
				></textarea>
				<span id="chars">0</span>
                <script type="text/javascript">counter()</script>
			</td>
		</tr>
		<tr>
			<td><?php echo NOTIFICATION_BY_SMS_ON_OFFER_ACQUISITION; ?></td>
			<td>
                <select name="sms_notify">
                    <option value="1"><?php echo YES; ?></option>
                    <option value="0"><?php echo NO; ?></option>
                </select>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="text-align:center;padding:10px;">
				<button type="submit" class="styled" >
						<img src="images/apply.png" class="icon" /> Create reward
				</button>
			</td>
		</tr>
	</table>
</form>
<script language="JavaScript" type="text/javascript" xml:space="preserve">
//<![CDATA[
  var frmvalidator  = new Validator("new-prize");
  frmvalidator.EnableOnPageErrorDisplaySingleBox();
  frmvalidator.EnableMsgsTogether();
 
  frmvalidator.addValidation("prize_points", "req", "<?php echo POINTS_NOT_ENTERED; ?>");
  frmvalidator.addValidation("prize_points", "maxlen=10", "<?php echo MAX_DIGITS_FOR_POINTS; ?>");
  frmvalidator.addValidation("prize_points", "numeric", "<?php echo POINTS_NUMERIC_ONLY; ?>");
  
  frmvalidator.addValidation("from_date", "req", "<?php echo START_DATE_NOT_ENTERED; ?>");

  frmvalidator.addValidation("till_date", "req", "<?php echo END_DATE_NOT_ENTERED; ?>");
  
  frmvalidator.addValidation("prize_msg", "maxlen=254", "<?php echo OFFER_MESSAGE_MAX_LENGTH; ?>");
 
//]]>
</script>

<p class="main"><?php echo FIELDS_REQUIRED; ?></p>
</div>

</body>
</html>
