<?php
    header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

    require_once('auth.php');
    require_once('config.php');
    require('admin.php');
    require('header.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo EPEXERGASIA_PROSFORAS; ?></title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="styles.css">
    <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <script src="form_validator.js"></script>
    <script src="calendar.js"></script>
    <script>
        function counter() {
            var text = document.getElementById('prize_msg').value;
            var len = text.length;
            document.getElementById('chars').innerHTML = len;
            if (len > 89) document.getElementById('prize_msg').value = text.substring(0, 89);
        }

        function setAgeFrom() {
            document.getElementById("from_date").value = document.getElementById("from_year").value + '/' + document.getElementById("from_month").value + '/' + document.getElementById("from_day").value;
        }

        function setAgeTill() {
            document.getElementById("till_date").value = document.getElementById("till_year").value + '/' + document.getElementById("till_month").value + '/' + document.getElementById("till_day").value;
        }
    </script>
</head>

<body>
<?php headerDiv(); ?>

<div class="container mt-5 main">
    <h1 class="text-center"><?php echo EPEXERGASIA_PROSFORAS; ?></h1>

    <?php
        if ($_POST['id'] == '') {
            echo '<div class="alert alert-danger">' . DEN_EPILExTHIKE_KAPOIA_PROSFORA_PROS_EPEXERGASIA . '</div>';
            exit();
        }

        $link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
        if (!$link) {
            die('<div class="alert alert-danger">' . APOTYCHIA_SYNDESHS_ME_TO_DIAKOMISTI . ': ' . mysql_error() . '</div>');
        }

        $db = mysql_select_db(DB_DATABASE);
        if (!$db) {
            die('<div class="alert alert-danger">Unable to select database</div>');
        }

        mysql_query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'", $link)
        or die(mysql_error());

        $qry = "SELECT * FROM prizes WHERE id='" . $_POST['id'] . "';";
        $result = mysql_query($qry);
        if ($result && mysql_num_rows($result) == 1) {
            $prize = mysql_fetch_assoc($result);
        } else {
            die('<div class="alert alert-danger">' . DE_VRETHIKE_I_PROSFORA_PROS_EPEXERGASIA . '</div>');
        }
    ?>

    <form action="admin-edit-prize-exec.php" method="post" name="edit-prize" id="edit-prize" class="form-horizontal">
        <input type="hidden" name="id" value="<?php echo $prize['id']; ?>" />
        
        <div class="form-group row">
            <label class="col-sm-3 col-form-label"><?php echo PONTOI_GIA_TIN_APOKTISI_TIS_PROSFORAS; ?></label>
            <div class="col-sm-9">
                <input type="text" name="prize_points" class="form-control" value="<?php echo $prize['prize_points']; ?>" required />
            </div>
        </div>

        <div class="form-group row">
            <label class="col-sm-3 col-form-label"><?php echo APO; ?></label>
            <div class="col-sm-9">
                <?php
                    $dayAge = $monthAge = $yearAge = "";
                    if (!empty($prize['from_date'])) {
                        $d = DateTime::createFromFormat('Y-m-d', $prize['from_date']);
                        if ($d && $d->format('Y-m-d') == $prize['from_date']) {
                            $dayAge = $d->format('d');
                            $monthAge = $d->format('m');
                            $yearAge = $d->format('Y');
                        }
                    }
                ?>
                <select id="from_day" class="form-control d-inline w-auto" onchange="setAgeFrom()">
                    <option value=""><?php echo MERA; ?></option>
                    <?php for ($i = 1; $i <= 31; $i++) echo '<option value="' . str_pad($i, 2, '0', STR_PAD_LEFT) . '" ' . ($dayAge == $i ? 'selected' : '') . '>' . $i . '</option>'; ?>
                </select>

                <select id="from_month" class="form-control d-inline w-auto" onchange="setAgeFrom()">
                    <option value=""><?php echo MINAS; ?></option>
                    <?php for ($i = 1; $i <= 12; $i++) echo '<option value="' . str_pad($i, 2, '0', STR_PAD_LEFT) . '" ' . ($monthAge == $i ? 'selected' : '') . '>' . $i . '</option>'; ?>
                </select>

                <select id="from_year" class="form-control d-inline w-auto" onchange="setAgeFrom()">
                    <option value=""><?php echo ETOS; ?></option>
                    <?php for ($i = date("Y", strtotime("+6 years")); $i >= date("Y", strtotime("-3 years")); $i--) echo '<option value="' . $i . '" ' . ($yearAge == $i ? 'selected' : '') . '>' . $i . '</option>'; ?>
                </select>
                <input type="hidden" name="from_date" id="from_date" value="<?= $d ? $d->format('Y/m/d') : '' ?>" />
            </div>
        </div>

        <div class="form-group row">
            <label class="col-sm-3 col-form-label"><?php echo EOS; ?></label>
            <div class="col-sm-9">
                <?php
                    $dayAge = $monthAge = $yearAge = "";
                    if (!empty($prize['till_date'])) {
                        $d = DateTime::createFromFormat('Y-m-d', $prize['till_date']);
                        if ($d && $d->format('Y-m-d') == $prize['till_date']) {
                            $dayAge = $d->format('d');
                            $monthAge = $d->format('m');
                            $yearAge = $d->format('Y');
                        }
                    }
                ?>
                <select id="till_day" class="form-control d-inline w-auto" onchange="setAgeTill()">
                    <option value=""><?php echo MERA; ?></option>
                    <?php for ($i = 1; $i <= 31; $i++) echo '<option value="' . str_pad($i, 2, '0', STR_PAD_LEFT) . '" ' . ($dayAge == $i ? 'selected' : '') . '>' . $i . '</option>'; ?>
                </select>

                <select id="till_month" class="form-control d-inline w-auto" onchange="setAgeTill()">
                    <option value=""><?php echo MINAS; ?></option>
                    <?php for ($i = 1; $i <= 12; $i++) echo '<option value="' . str_pad($i, 2, '0', STR_PAD_LEFT) . '" ' . ($monthAge == $i ? 'selected' : '') . '>' . $i . '</option>'; ?>
                </select>

                <select id="till_year" class="form-control d-inline w-auto" onchange="setAgeTill()">
                    <option value=""><?php echo ETOS; ?></option>
                    <?php for ($i = date("Y", strtotime("+6 years")); $i >= date("Y", strtotime("-3 years")); $i--) echo '<option value="' . $i . '" ' . ($yearAge == $i ? 'selected' : '') . '>' . $i . '</option>'; ?>
                </select>
                <input type="hidden" name="till_date" id="till_date" value="<?= $d ? $d->format('Y/m/d') : '' ?>" />
            </div>
        </div>

        <div class="form-group row">
            <label class="col-sm-3 col-form-label"><?php echo KATIGORIA_MELON; ?></label>
            <div class="col-sm-9">
                <select name="customer_custom" class="form-control">
                    <option <?= empty($prize['customer_custom']) ? "selected" : "" ?> value=""><?php echo OLOI; ?></option>
                    <?php
                        for ($i = 1; $i <= CUSTOM_FIELDS_NUM; $i++) {
                            if (isset($_SESSION['SESS_CUSTOM_FIELD' . $i]) && $_SESSION['SESS_CUSTOM_FIELD' . $i] != "" && isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "1") {
                                echo '<option value="' . $i . '" ' . ($prize['customer_custom'] == $i ? "selected" : "") . '>' . $_SESSION['SESS_CUSTOM_FIELD' . $i] . '</option>';
                            }
                        }
                    ?>
                </select>
            </div>
        </div>

        <div class="form-group row">
            <label class="col-sm-3 col-form-label"><?php echo MINYMA_PROSFORAS; ?></label>
            <div class="col-sm-9">
                <textarea name="prize_msg" id="prize_msg" class="form-control" rows="3" maxlength="254" onKeyDown="counter();" onKeyUp="counter();"><?php echo $prize['prize_msg']; ?></textarea>
                <small id="chars" class="form-text text-muted">Characters: 0</small>
            </div>
        </div>

        <div class="form-group row">
            <label class="col-sm-3 col-form-label"><?php echo EIDOPOIHSH_ME_SMS_KATA_TIN_APOKTISI_TIS_PROSFORAS; ?></label>
            <div class="col-sm-9">
                <select name="sms_notify" class="form-control">
                    <option value="1" <?=($prize['sms_notify'] ? "selected" : "")?>>Yes</option>
                    <option value="0" <?=(!$prize['sms_notify'] ? "selected" : "")?>>No</option>
                </select>
            </div>
        </div>

        <div class="form-group row">
            <div class="col-sm-12 text-center">
                <button type="submit" class="btn btn-primary">
                    <img src="images/apply.png" class="icon" /> <?php echo YPOVOLI_EPEXERGASIAS; ?>
                </button>
            </div>
        </div>
    </form>

    <script>
        var frmvalidator = new Validator("edit-prize");
        frmvalidator.EnableOnPageErrorDisplaySingleBox();
        frmvalidator.EnableMsgsTogether();

        frmvalidator.addValidation("prize_points", "req", "<?php echo DEN_ECHETE_EISAGEI_TON_ARITHMO_PONTON; ?>");
        frmvalidator.addValidation("prize_points", "maxlen=10", "<?php echo MEGISTOS_ARITHMOS_PSIFION_GIA_TON_ARITHMO_PONTON_EINAI_10; ?>");
        frmvalidator.addValidation("prize_points", "numeric", "<?php echo ARITHMOS_PONTON_MONO_PSIFIA; ?>");

        frmvalidator.addValidation("from_date", "req", "<?php echo DEN_EXETE_EISAGEI_TIN_HMEROMINIA_EKKINISIS_TIS_PROSFORAS; ?>");

        frmvalidator.addValidation("till_date", "req", "<?php echo DEN_EXETE_EISAGEI_TIN_HMEROMINIA_TERMATISMOU_TIS_PROSFORAS; ?>");

        frmvalidator.addValidation("prize_msg", "maxlen=254", "<?php echo MINYMA_TIS_PROSFORAS_MECHRI_254_CHARAKTIRES; ?>");
    </script>

    <p class="text-muted text-center"><?php echo PEDIA_ME_ASTERI_EINAI_YPOCHREOTIKA; ?></p>
</div>
<pre>
    
    
</pre>
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
