<?php
require_once 'config.php';
require_once 'Response.php';

$key = '?consumer_key=' . consumerKey . "&consumer_secret=" . consumerSecret;
$resource = "orders";

$params = "&status=completed";

$lastOrderIdFromloyaltyTransactionTable = lastOrderIdFromloyaltyTransactionTable(); // Το χρειαζόμαστε για να πάρουμε τα επόμενα orderId
$responseObject = callAPI("GET", wooCommerceApiUrl . "orders/$lastOrderIdFromloyaltyTransactionTable" . $key, false);

if (! property_exists(json_decode($responseObject->getBody()), "date_created_gmt"))
    die("Δεν υπάρχει νέο order ώστε να τοποθετηθεί στο transaction πίνακα");

$dateFromLastOrderId = json_decode($responseObject->getBody())->date_created_gmt;
$lastOrderId = json_decode($responseObject->getBody())->id;

$dateFromLastOrderIdOneDayBefore = date("Y-m-d\TH:i:s", strtotime($dateFromLastOrderId) - 60 * 60 * 24); // Μετατροπή του date στο format που θέλει το wooCommerce, μια μέρα πριν για να πιάσει την σημερινή ημερομηνία

// Βάζω παράμετρο date είτε από το config είτε από το transactionDb βάζω τήν μεγαλυτερη ημερομηνία.
if (dateAfter != "") {
    if (dateAfter > $dateFromLastOrderIdOneDayBefore)
        $params .= "&after=" . dateAfter;
    else
        $params .= "&after=" . $dateFromLastOrderIdOneDayBefore;
} else {
    $params .= "&after=" . $dateFromLastOrderIdOneDayBefore;
}

// url του wooCommerce Api
$wooCommerceWithKeyAndAfterParam = wooCommerceApiUrl . $resource . $key . $params . "&exclude=$lastOrderIdFromloyaltyTransactionTable";
$responseObject = callAPI("GET", $wooCommerceWithKeyAndAfterParam, false);

// Επεξεργασία του header
$header = $responseObject->getHeader();
$matches = array();
preg_match('/X-WP-TotalPages: [0-9]+/', $header, $matches); // Παίρνω από το header την παράμετρο X-WP-TotalPages
$total_pages = explode(':', $matches[0])[1]; // Παίρνω τον αριθμό από την μεταβλητή

$body = $responseObject->getBody();
// παίρνουμε τα orders από το body
$orders = json_decode($body);

wooCommerceOrdersToLoyalty($orders, $lastOrderId);

for ($i = 2; $i <= $total_pages; $i ++) {

    $responseObject = callAPI("GET", $wooCommerceWithKeyAndAfterParam . "&page=$i", false);
    $body = $responseObject->getBody();
    $orders = json_decode($body);
    wooCommerceOrdersToLoyalty($orders, $lastOrderId);
}

function wooCommerceOrdersToLoyalty($orders, $lastOrderId)
{
    $resource = "products/{id}"; // Δημιουργία wildcard για το product id
    $key = '?consumer_key=' . consumerKey . "&consumer_secret=" . consumerSecret;
    $productCategoriesUrl = wooCommerceApiUrl . $resource . $key;
    $customerDetailsWoocommerce = wooCommerceApiUrl . "customers/{id}" . $key;
    $transactionUrl = transactions_url . "?";
    $loyaltyRegisterApiURL = loyaltyRegisterApiURL;
    echo "<p> Μεταφορά των order από το woocommerce στο loyalty</p>";
    foreach ($orders as $order) {
        
        $customer_id_from_order = $order->customer_id;
        if ($order->id > $lastOrderId) {
            // Το woocommerce τους εγγεγραμμένους πελάτες τους βάζει τιμή id μεγαλύτερη του μηδενός ενώ τους άλλους μηδέν
            if ($customer_id_from_order > 0) {
                $customerDetailsWoocommerceCall = str_replace("{id}", $customer_id_from_order, $customerDetailsWoocommerce);
                $customer_id_from_order += 10000000;
                $orderId = $order->id;

                // Πρέπει να πάρουμε τα products την κατηγορία και το κόστος
                $lineItems = $order->line_items;
                foreach ($lineItems as $lineItem) {
                    $productId = $lineItem->product_id;
                    $totalCost = $lineItem->total;
                    $productCategoriesUrlCall = str_replace('{id}', $productId, $productCategoriesUrl); // Αντικατάσταση του wildcard με το κατάλληλο product_id
                                                                                                        // Κάνουμε κλήση : $productCategoriesUrlCall και παίρνουμε τις κατηγορίες;
                    $responseObject = callAPI("GET", $productCategoriesUrlCall, false);
                    $body = $responseObject->getBody();
                    $product = json_decode($body);
                    $category_id = $product->categories[0]->id;
                    // Παίρνουμε τα στοιχεία από το wooCommerce
                    $responseObject = callAPI("GET", $customerDetailsWoocommerceCall, false);
              
                    $body = $responseObject->getBody();

                    $customer = json_decode($body);
                    $first_name = $customer->first_name;
                    $last_name = $customer->last_name;
                    $email = $customer->email;
                    $phone = $customer->billing->phone;
                    $phone_len = strlen($phone);
                    if ($phone_len > 10) {
                        $phone = substr($phone, $phone_len - 10, $phone_len);
                    }
                   
                    // Εγγραφή του χρήστη αν δεν υπάρχει στο loyalty
                    $responseObject = callAPI('GET', "$loyaltyRegisterApiURL" . "?customer_id=$customer_id_from_order&firstname=$first_name&lastname=$last_name&email=$email&phone=$phone", false);

                    // Έπειτα κάνουμε κλήση στο loyalty api αφού έχουμε συλλέξει όλα τα δεδομένα
                    $transactionUrl .= "customer_id=$customer_id_from_order&amount=$totalCost&woo_order_id=$orderId&service_id=$category_id";
                    $responseObject = callAPI('GET', $transactionUrl, false);
                    //echo "url =" . $transactionUrl . "<br>";
                    $transactionObject = json_decode($responseObject->getBody());
                    $transactionStatus = $transactionObject->status;
                    $transactionMessage = $transactionObject->message;
                    echo "orderId = $orderId status = $transactionStatus message = $transactionMessage </br>";
                }
            }
        }
    }
    echo "<p>Οι συναλλαγές μεταφέρθηκαν</p>";
}

function lastOrderIdFromloyaltyTransactionTable()
{
    
     $dsn = "mysql:host=".HOST.";dbname=".DBNAME;
     $pdo = new PDO($dsn, USER, PASSWORD,array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION));
     
      $sql = 'SELECT MAX(eshop_order_id) from transactions';
      $stmt = $pdo->prepare($sql);
     
      try {
      $stmt->execute();
     
      $result = $stmt->fetch();
     
      $last_id = $result[0];
     
      } catch (Exception $ex) {
      die('Database error!');
      }
      finally {
      $stmt->closeCursor();
      $pdo = null;
      }
     
      return $last_id;
    
}

function callAPI($method, $url, $data)
{
    $curl = curl_init();

    switch ($method) {
        case "POST":
            curl_setopt($curl, CURLOPT_POST, 1);
            if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            break;
        case "PUT":
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
            if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            break;
        default:
            if ($data)
                $url = sprintf("%s?%s", $url, http_build_query($data));
    }

    // OPTIONS:
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json'
    ));
    curl_setopt($curl, CURLOPT_HEADER, 1);

    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

    // EXECUTE:
    $result = curl_exec($curl);

    if (! $result) {
        die("Connection Failure");
    }

    $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
    $header = substr($result, 0, $headerSize);
    $body = substr($result, $headerSize);
    $responseObject = new Response($header, $body);
    curl_close($curl);
    return $responseObject;
}
?>
