<?php
	header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

	require_once('auth.php');
	require('header.php');
	require_once('config.php');
	require_once ("DatabaseConnector.php");
	
	?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<link rel="stylesheet" href="https://toert.github.io/Isolated-Bootstrap/versions/4.0.0-beta/iso_bootstrap4.0.0min.css">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title>Προβολή στατιστικών πελάτη απο συσκευές wifi</title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<link href="calendar.css" type="text/css" rel="stylesheet" />
<script src="calendar.js" type="text/javascript"></script>
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
</head>

<body>
	
<?php

if(isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0) {
    $page = $_GET['page'];
}
else {
    $page = 1;
}

$page_length = 20;  //Πόσες εγγραφές θα φαίνονται ανά σελίδα
$start = ($page-1) * $page_length;
	
	
$fromDate = $_REQUEST['from_wifi_date']; //Τo παίρνω απο $_POST['from_date'];
$tillDate = $_REQUEST['till_wifi_date']; //Τo παίρνω απο $_POST['till_date'];
if (!DateTime::createFromFormat('Y-m-d', $fromDate))
    exit();
if (!DateTime::createFromFormat('Y-m-d', $tillDate))
    exit();

$dbName = DB_DATABASE; //Το παίρνω από SELECT database(); ή DB_name

$databaseConnector = new DatabaseConnector("newmedia_visitsdb", "newmedia_wifiu", "wifi123**", "localhost"); //wifiuser εδώ...
$pdo = $databaseConnector->getConnection();
$pdo->exec('set names utf8');

$total_visits = $pdo->query("SELECT count(id) FROM newmedia_visitsdb.Visits WHERE dbname = \"$dbName\"")->fetch()[0];
$total_pages =  ceil($total_visits / $page_length);

$sql = "SELECT * \n"
    . "FROM newmedia_visitsdb.Visits LEFT JOIN $dbName.customers ON newmedia_visitsdb.Visits.customer_id = $dbName.customers.token_id\n"
    . "WHERE dbname = \"$dbName\"\n"
    . "AND (cast(date as date) BETWEEN :fromDate AND :tillDate)\n"
    . "ORDER BY Visits.date DESC\n"
    . "LIMIT :start, :page_length";

$stmt = $pdo->prepare($sql);

// $stmt->bindParam(":dbname", $dbName);
$stmt->bindParam(":fromDate", $fromDate);
$stmt->bindParam(":tillDate", $tillDate);
$stmt->bindParam(":start", $start, PDO::PARAM_INT);
$stmt->bindParam(":page_length", $page_length, PDO::PARAM_INT);

$stmt->execute();


$results = $stmt->fetchAll();

/*for ($i = 0; $i < $stmt->columnCount(); $i++) {
    $column = $stmt->getColumnMeta($i);
    $columns[] = $column['name'];
}  */
?>

	
<?php
    headerDiv();
?>

<div class="bootstrap main" style="max-width: 900px;">
    <h1>Εμφάνιση στατιστικών των μελών που πέρασαν από το κατάστημά σας (wifi proximity) </h1>
    <p>
<div id="table-wrapper">
  <div id="table-scroll" class="table-responsive">
<table class="table" border = "1">
    <thead >
        <tr >
            <th><span class="text"><?php echo "Αναγνωριστικό";?></span></th>
            <th><?php echo "Όνομα";?></th>
            <th><?php echo "Επώνυμο";?></th>
            <th><?php echo "Ημερομηνία";?></th>
        </tr>
    </thead>
    <tbody>
        <?php
       
        foreach ($results as $result) {
             echo '<tr>';
            echo '<td contenteditable style="max-width:150px;overflow-x:scroll;">'.$result[1] . '</td>'.'<td>'. $result[9] .'</td>'.'<td>'.$result[10].'</td>' .'<td>'.$result[2].'</td>';
            echo '</tr>';
        }
        
        ?>
        <tr><td><?php echo "Εμφανίζονται: ".sizeof($results)." Σύνολο επισκέψεων: $total_visits"?></td></tr>
    </tbody>
</table>
  </div>
</div>
&nbsp;</p>

<?php   
if ($page > 1) { ?>
	<a class="btn btn-outline-info mb-4" href="?page=1&from_wifi_date=<?=$fromDate?>&till_wifi_date=<?=$tillDate?>">First</a>
    <a class="btn btn-outline-info mb-4" href="?page=<?=$page-1?>&from_wifi_date=<?=$fromDate?>&till_wifi_date=<?=$tillDate?>">Previous</a>  
<?php }
for($i = 1; $i <= $total_pages; $i++) {
    if($i == $page) { ?>
        <a class="btn btn-info mb-4" href="?page=<?=$i?>&from_wifi_date=<?=$fromDate?>&till_wifi_date=<?=$tillDate?>"><?=$i?></a>
    <?php }
    else if ($i > $page-3 && $i < $page+3) { ?>
    	<a class="btn btn-outline-info mb-4" href="?page=<?=$i?>&from_wifi_date=<?=$fromDate?>&till_wifi_date=<?=$tillDate?>"><?=$i?></a>
    <?php } 
}

if ($page < $total_pages) { ?>
<a class="btn btn-outline-info mb-4" href="?page=<?=$page+1?>&from_wifi_date=<?=$fromDate?>&till_wifi_date=<?=$tillDate?>">Next</a>
<a class="btn btn-outline-info mb-4" href="?page=<?=$total_pages?>&from_wifi_date=<?=$fromDate?>&till_wifi_date=<?=$tillDate?>">Last</a>
<?php } 

?>


</div>
</body>
</html>

