<?php

if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) {
    die('Direct access not allowed');
    exit();
}

header("Pragma: no-cache");
header("Cache: no-cache");
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

require_once('auth.php');
require('header.php');
require_once('config.php');
require_once ("DatabaseConnector.php");


if (isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0) {
    $page = $_GET['page'];
} else {
    $page = 1;
}

$page_length = 20;
$start = ($page - 1) * $page_length;



if (!empty($_REQUEST[$from_date_param_name]) && !empty($_REQUEST[$till_date_param_name])) {
    $fromDate = $_REQUEST[$from_date_param_name]; //Τo παίρνω απο $_POST['from_date'];
    $tillDate = $_REQUEST[$till_date_param_name]; //Τo παίρνω απο $_POST['till_date'];
} else {
    $fromDate = "0000-01-01";
    $tillDate = date("Y-m-d");
}

if (!DateTime::createFromFormat('Y-m-d', $fromDate))
    die("Bad date format!");
if (!DateTime::createFromFormat('Y-m-d', $tillDate))
    die("Bad date format!");



$dbName = DB_DATABASE; //Το παίρνω από SELECT database(); ή DB_name

$databaseConnector = new DatabaseConnector("newmedia_visitsdb", "newmedia_wifiu", "wifi123**", "localhost"); //wifiuser εδώ...

$pdo = $databaseConnector->getConnection();
$pdo->exec('set names utf8');

$binds = [];
$and = "";
$count_join = "";
if(!empty($_GET["customer_id"])) {
    $and = " AND $dbName.customers.customer_id = :cust_id ";
    $count_join = "JOIN $dbName.customers ON newmedia_visitsdb.$table_name.customer_id = $dbName.customers.token_id";
    $cust_id = secureInput($_GET["customer_id"]);
    $binds[":cust_id"] = $cust_id;
}

$sql = "SELECT count(*) "
        . "FROM newmedia_visitsdb.$table_name\n $count_join\n"
        . "WHERE dbname = \"$dbName\" AND (cast(date as date) BETWEEN :fromDate AND :tillDate) $and\n";

$stmt = $pdo->prepare($sql);

// $stmt->bindParam(":dbname", $dbName);
$binds[":fromDate"] =  $fromDate;
$binds[":tillDate"] = $tillDate;

$stmt->execute($binds);

$total_visits = $stmt->fetch()[0];
$total_pages = ceil($total_visits / $page_length);

$sql = "SELECT  newmedia_visitsdb.$table_name.customer_id as token, name, surname, date, $dbName.customers.customer_id as customer_id\n"
        . "FROM newmedia_visitsdb.$table_name LEFT JOIN $dbName.customers ON newmedia_visitsdb.$table_name.customer_id = $dbName.customers.token_id\n"
        . "WHERE dbname = \"$dbName\"\n"
        . "AND (cast(date as date) BETWEEN :fromDate AND :tillDate) $and\n"
        . "ORDER BY $table_name.date DESC\n"
        . "LIMIT :start, :page_length";

$stmt = $pdo->prepare($sql);

foreach ($binds as $key => &$value) {
    $stmt->bindParam($key, $value);
}

$stmt->bindParam(":start", $start, PDO::PARAM_INT);
$stmt->bindParam(":page_length", $page_length, PDO::PARAM_INT);

$stmt->execute();


$results = $stmt->fetchAll();

require_once 'user-visits-stats-view.php';