<?php  

if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) {
    die('Direct access not allowed');
    exit();
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <link rel="stylesheet" href="https://toert.github.io/Isolated-Bootstrap/versions/4.0.0-beta/iso_bootstrap4.0.0min.css">
        <meta http-equiv="content-type" content="text/html;charset=utf-8" />
        <title><?= $title ?></title>
        <link href="styles.css" rel="stylesheet" type="text/css" />
        <link href="calendar.css" type="text/css" rel="stylesheet" />
        <script src="calendar.js" type="text/javascript"></script>
        <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
        <link rel="icon" href="images/favicon.ico" type="image/x-icon" />
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
        <meta http-equiv="Pragma" content="no-cache">
        <meta http-equiv="Expires" content="0">
    </head>

    <body>

    <?php
    headerDiv();
    ?>

<div class="bootstrap main" style="max-width: 900px;">
    <h1><?=$h1_text?></h1>  
        <form>
        <div class="form-group">
            echo '<label for="fromDate">' . LABEL_FROM . '</label>';
            <input id="fromDate" type="date" name="<?=$from_date_param_name?>" max="3000-12-31" 
                   min="1000-01-01" class="form-control" value="<?=$fromDate?>">
        </div>
        <div class="form-group">
           echo '<label for="tillDate">' . LABEL_TO . '</label>';
            <input id="tillDate" type="date" name="<?=$till_date_param_name?>" min="1000-01-01"
                   max="3000-12-31" class="form-control" value="<?=$tillDate?>">
        </div>
        <div class="form-group">
            echo '<label for="customerID">' . LABEL_CUSTOMER_CARD . '</label>';
            <input type="text" class="form-control" id="customerID" name="customer_id" placeholder="Κάρτα πελάτη">
        </div>

            <div class="row" width="100%">
               echo '<button style="margin: 0 auto" type="submit" class="btn btn-primary col-3">' . BUTTON_SEARCH . '</button>';
            </div>
            
    </form>
    <p>
        
    <div id="table-wrapper">
      <div id="table-scroll" class="table-responsive">
        <table class="table" border = "1">
            <thead>
                <tr >
                    echo '<th><span class="text">' . LABEL_IDENTIFIER . '</span></th>';
                    echo '<th>' . LABEL_NAME . '</th>';
                    echo '<th>' . LABEL_SURNAME . '</th>';
                    echo '<th>' . LABEL_DATE . '</th>';
                </tr>
            </thead>
            <tbody>
                <?php

                foreach ($results as $result) {
                    if(!empty($result["customer_id"])) {
                        $customer_id = $result["customer_id"];
                        $id_field = '<td style="max-width:150px;overflow-x:scroll;"><a href="?customer_id='.$customer_id.'">'.$customer_id. '</a></td>';
                        $class = 'style="background-color:#e6f9ff"';
                    }
                    else {
                        $id_field = '<td style="max-width:150px;overflow-x:scroll;">'.$result["token"]. '</td>';
                        $class = "";
                    }
                    
                    echo "<tr $class>";
                    echo $id_field.'<td>'. $result["name"] .'</td>'.'<td>'.$result["surname"].'</td>' .'<td>'.$result["date"].'</td>';
                    echo "</tr>";
                }

                ?>
                echo '<tr><td>' . LABEL_DISPLAYING . ' ' . sizeof($results) . ' ' . LABEL_TOTAL_VISITS . ' ' . $total_visits . '</td></tr>';
            </tbody>
        </table>
      </div>
    </div>
    &nbsp;
    </p>

<?php   
$current_url = basename($_SERVER['REQUEST_URI']);
if(!strpos($current_url, "?")) {
    $current_url .= "?";
}
$current_url = preg_replace("(&page=[0-9]+)", "", $current_url);
if ($page > 1) { ?>
    <a class="btn btn-outline-info mb-4" href="<?=$current_url?>&page=1">First</a>
    <a class="btn btn-outline-info mb-4" href="<?=$current_url?>&page=<?=$page-1?>">Previous</a>  
<?php }
for($i = 1; $i <= $total_pages; $i++) {
    if($i == $page) { ?>
        <a class="btn btn-info mb-4" href="<?=$current_url?>&page=<?=$i?>"><?=$i?></a>
    <?php }
    else if ($i > $page-3 && $i < $page+3) { ?>
    	<a class="btn btn-outline-info mb-4" href="<?=$current_url?>&page=<?=$i?>"><?=$i?></a>
    <?php } 
}

if ($page < $total_pages) { ?>
<a class="btn btn-outline-info mb-4" href="<?=$current_url?>&page=<?=$page+1?>">Next</a>
<a class="btn btn-outline-info mb-4" href="<?=$current_url?>&page=<?=$total_pages?>">Last</a>
<?php } 

?>


</div>
</body>
</html>