<?php
if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) {
    header("Location: services-settings.php");
    exit();
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <link rel="stylesheet" href="https://toert.github.io/Isolated-Bootstrap/versions/4.0.0-beta/iso_bootstrap4.0.0min.css">
            <meta http-equiv="content-type" content="text/html;charset=utf-8"/>
            <title><?= $title ?></title>
            <link href="styles.css" rel="stylesheet" type="text/css"/>
            <link href="calendar.css" type="text/css" rel="stylesheet" />
            <script src="calendar.js" type="text/javascript"></script>
            <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon"/>
            <link rel="icon" href="images/favicon.ico" type="image/x-icon" />
            <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate"/>
            <meta http-equiv="Pragma" content="no-cache"/>
            <meta http-equiv="Expires" content="0"/>
    </head>

    <body>
        <?php
        headerDiv();
        ?>
  	<div class="bootstrapiso">

        <!-- For auto-complete -->
        <datalist id="categories">
            <?php foreach ($categories as $category) { ?>
                <option value="<?= $category ?>">
                    <?php
                }
                ?>
        </datalist>     

        <div class="main">
            <div class="bootstrap">

                <table class="table table-striped">
                    <thead style="background-color: #343a40; color: white">
                        <tr>
    <th scope="col">#</th>
    <th scope="col"><?php echo CATEGORY; ?></th>
    <th scope="col"><?php echo SERVICE; ?></th>
    <th scope="col"><?php echo POINTS_PER_EURO; ?></th>
    <th scope="col"><?php echo ACTION; ?></th>
</tr>

                    </thead>
                    <tbody>
                        <?php
                        $i = 0;
                        foreach ($categorizedServices as $category => $services) {
                            foreach ($services as $service) {
                                ?>
                                <tr class="service-row">
                                    <th scope="row"><?= $i + 1 ?></th>
                                    <td class="category"><?= $category ?></td>
                                    <td class="name"><?= getPureServiceName($service) ?></td>
                                    <td class="multiplier"><?= getMultiplier($service) ?></td>
                                    <td>
                                       <button class="ml-1 btn btn-danger" onclick="deleteService(<?= $i ?>)"><?php echo DELETE; ?></button>
                                    </td>
                                </tr>
                                <?php
                                $i++;
                            }
                        }
                        ?>
                        <tr id="additionalService">
                            <th scope="row"><?= $i + 1 ?></th>
                            <td class="category">
                                <input id="additionalCategory" list="categories"/>
                            </td>
                            <td class="name">
                                <input id="additionalName" type="text"/>
                            </td>
                            <td class="multiplier">
                                <input id="additionalMultiplier" type="number" step="0.1"/>
                            </td>
                            <td>
                               <button class="btn btn-success" onclick="addService()"><?php echo ADD; ?></button>
                            </td>

                        </tr>             

                    </tbody>
                </table>

                <form id="servicesForm" action="#" method="POST">
                    <input id="services" name="services" type="hidden"/>
                </form>

            </div>
        </div>
        </div>
        <script type="text/javascript">

            var serviceRowClass = "service-row";
            var additionalServiceId = "additionalService";
            var additionalCategoryId = "additionalCategory";
            var additionalNameId = "additionalName";
            var additionalMultiplierId = "additionalMultiplier";
            var servicesId = "services";
            var categoryClass = "category";
            var nameClass = "name";
            var multiplierClass = "multiplier";
            var servicesFormId = "servicesForm";

            function deleteService(index) {
                document.getElementsByClassName(serviceRowClass)[index].remove();
                composeAndSubmit();
            }


            function addService() {

                if (validateAndSubstituteInputs()) {

                    document.getElementById(additionalServiceId).classList.add(serviceRowClass);
                    composeAndSubmit();
                }
            }

            function validateAndSubstituteInputs() {

                var isValid = true;

                var category = document.getElementById(additionalCategoryId).value;
                var name = document.getElementById(additionalNameId).value;
                var multiplier = document.getElementById(additionalMultiplierId).value;
                if (!name || !multiplier) {
                    isValid = false;
                    alert("<?php echo PLEASE_FILL_SERVICE_NAME_AND_POINTS_FOR_ADDING; ?>");
                } else { // substitute parent elements
                    document.getElementById(additionalCategoryId).parentElement.innerText = category ? category : "noCategory";
                    document.getElementById(additionalNameId).parentElement.innerText = name;
                    document.getElementById(additionalMultiplierId).parentElement.innerText = multiplier;
                }

                return isValid;
            }


            function composeAndSubmit() {
                var serviceRows = document.getElementsByClassName(serviceRowClass);
                var services = [];

                for (var i = 0; i < serviceRows.length; i++) {
                    services.push(getService(serviceRows[i]));
                }

                document.getElementById(servicesId).value = compose(services);

                document.getElementById(servicesFormId).submit();

            }

            function getService(serviceRow) {

                var service = {category: "", name: "", multiplier: ""};

                for (var i = 0; i < serviceRow.childNodes.length; i++) {
                    if (serviceRow.childNodes[i].className === categoryClass) {
                        service.category = serviceRow.childNodes[i].innerText;
                    }
                    if (serviceRow.childNodes[i].className === nameClass) {
                        service.name = serviceRow.childNodes[i].innerText;
                    }
                    if (serviceRow.childNodes[i].className === multiplierClass) {
                        service.multiplier = serviceRow.childNodes[i].innerText;
                    }
                }

                return service;
            }

            function compose(services) {
                var composedServices = [];

                for (var i = 0; i < services.length; i++) {
                    composedServices.push(services[i].name + "(x" + services[i].multiplier + ")#" + services[i].category);
                }

                return composedServices.join(",");
            }


        </script>

    </body>
</html>

