<?php

require_once ('config.php');
require_once ('DatabaseConnector.php');
require_once('Dao.php');
require_once('CredentialsDB.php'); //Εδώ έχουμε το API_ACCESS_KEY

function sendSMS($phoneNoRecipients = array(), $msgText) {
    
    if(!LARGE_SMS) {
        if (mb_strlen($msgText, "UTF-8") + substr_count($msgText, '€') > 159) {
            die("To μήνυμα δεν μπορεί να αποσταλλεί γιατί είναι πάνω από 160 χαρακτήρες!");
        }
    }

     //Σύνδεση στην βάση
    $connector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
    $mysqlConnection = $connector->getConnection();
    $dao = new Dao($mysqlConnection);
    $phoneNoRecipients = array_unique($phoneNoRecipients);



    /* ------------------------------------------------------------------- */
    /*
     * Η συνάρτηση παίρνει τα $phoneNoRecipients και επιστεφει από την db assosiative πίνακα με κλειδί το
     * τηλέφωνο και value το firebaseToken
     */
    $phonesWithFirebaseToken = $dao->getPhonesFromDBthatHaveFirebaseToken($phoneNoRecipients);
    // Από τον assosiative πίνακα παίρνουμε τα value ως νέο πίνακα
    //$firebaseTokens = array_values($phonesWithFirebaseToken);
    $firebaseTokens =  multidimension_array_values($phonesWithFirebaseToken); //array_values($phonesWithFirebaseToken);

    // Μας επιστρέφει τα firebase tokens που έχουνε errors δλδ δεν στάλθηκαν
    $firebaseTokensWithErrors = sendNotifications(SMS_FROM, $firebaseTokens,$msgText);
    // print_r($firebaseTokensWithErrors);
    /* Παίρνουμε τα τηλέφωνα που πήραν notifications */
    $phones = phonesGotMessage($phonesWithFirebaseToken, $firebaseTokensWithErrors);
    //print_r($phones);
    /* ------------------------------------------------------------------- */

    /* Δεν μας ενδιαφέρουν τα firebaseTokens πλέον */
    //$phones = array_keys($phonesGotMessage);
    /* Αποθηκεύουμε στην sms_history τα τηλέφωνα που πήραν επιτυχώς push μήνυμα */
    if(count($phones) == 1){//Αν το μήνυμα το πήρε ένας τότε αποθηκεύουμε ως push-message το group
         $dao->saveToSmsHistory("push-message", $phones, $msgText);
    }else{//Αν το μήνυμα το πήραν πολλοι τότε αποθηκεύουμε ως push-group το group
        $dao->saveToSmsHistory("push-group", $phones, $msgText);
    }




    $phoneNoRecipients = array_diff($phoneNoRecipients,$phones);
   
    foreach ($phoneNoRecipients as $key => $phone) {
        if (strlen($phone) < 9) { // min 7 chars + 2 country code
            unset($phoneNoRecipients[$key]);
        }
    }

    $errors = 0;
    if (!empty($phoneNoRecipients)) {
        $url = "http://" . SMS_GW_IP . ":" . SMS_GW_PORT;

        if (SMS_BATCH_SPLIT_REQUESTS) {
            /* Sends multiple requests with 10 recipients each */
            $batch = array();
            foreach ($phoneNoRecipients as $phone) {
                $batch[] = $phone;

                if (count($batch) % 10 == 0) {
                    $params = array("to" => implode(",", $batch), "text" => urlencode($msgText));
                    
                    $total_msg = ceil((mb_strlen($msgText, "UTF-8") + substr_count($msgText, '€')) / 160 ) * count($batch);
                
                    if($total_msg > returnSMS()){
                         die("Το υπόλοιπό σου δεν επαρκεί");
                    }
                    
                    $response = curlSendSMS($url, $params);
                    $errors += substr_count($response, "ERROR");
                    if (!$response) {
                        return 0;
                    }
                    $chars = mb_strlen($msgText, "UTF-8") + substr_count($msgText, '€');
                    for ($i = ceil($chars / 160); $i > 0; $i--) {
                        curlSendResponse($response);
                    }
                    $batch = array();
                }
            }

            if (!empty($batch)) { //stile sms atomiko
                $params = array("to" => implode(",", $batch), "text" => urlencode($msgText));
                $total_msg = ceil((mb_strlen($msgText, "UTF-8") + substr_count($msgText, '€')) / 160 ) * count($batch);
                
                if($total_msg > returnSMS()){
                     die("Το υπόλοιπό σου δεν επαρκεί!");
                }
                   
                  
                $response = curlSendSMS($url, $params);
                $errors += substr_count($response, "ERROR");
                if (!$response) {
                    return 0;
                }
                $chars = mb_strlen($msgText, "UTF-8") + substr_count($msgText, '€');
                for ($i = ceil($chars / 160); $i > 0; $i--) {
                    curlSendResponse($response);
                }
            }
        } else {
            /* Sends one request with all recipients at once */
            $params = array("to" => implode(",", $phoneNoRecipients), "text" => urlencode($msgText));
            
             $total_msg = ceil((mb_strlen($msgText, "UTF-8") + substr_count($msgText, '€')) / 160 ) * count($phoneNoRecipients);
                
            if($total_msg > returnSMS()){
                 die("Το υπόλοιπό σου δεν επαρκεί!");
            }
            
            $response = curlSendSMS($url, $params);
            $errors += substr_count($response, "ERROR");
            if (!$response) {
                return 0;
            }
            $chars = mb_strlen($msgText, "UTF-8") + substr_count($msgText, '€');
            for ($i = ceil($chars / 160); $i > 0; $i--) {
                curlSendResponse($response);
            }
        }
    }
    
    if(count($phoneNoRecipients)==0 ){
        return -100; //δεν θα λάβει κανένας sms αλλά μόνο push
    }
    
    return count($phones) + count($phoneNoRecipients) - $errors;
    
}

function curlSendSMS($url, $params) {
//    return fakeCurlSendSMS($params);

    $params["username"] = urlencode(SMS_GW_USER);
    $params["password"] = urlencode(SMS_GW_PASS);
    $params["from"] = urlencode(SMS_FROM);

    $fields_string = "";
    foreach ($params as $key => $value) {
        $fields_string .= $key . '=' . $value . '&';
    }
    rtrim($fields_string, '&');

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, count($params));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        curl_close($ch);
        return false;
    }
    curl_close($ch);

    return $response;
}

function curlSendResponse($response) {
    $url = SMS_RESULT_URL;

    $params = array("result" => $response);
    $fields_string = "";
    foreach ($params as $key => $value) {
        $fields_string .= $key . '=' . $value . '&';
    }
    rtrim($fields_string, '&');

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, count($params));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_exec($ch);
    curl_close($ch);
}

function fakeCurlSendSMS($params) {
    $response = "";
    if (isset($params['to'])) {
        foreach (explode(",", $params['to']) as $to) {
            $response .= "SUCCESS MessageId: " . uniqid("", true) . ";Recipient:" . $to . "<br />";
//            $response .= "ERROR:001; STATUS:Invalid username or password<br />";
        }
    }
    return $response;
    /**
     * Possible responses:
     *
     * multiple recipients : "SUCCESS MessageId: 557bf16fa48d0-8441-95269;Recipient:306971234567<br />SUCCESS MessageId: 557bf16fa4ea4-7081-47246;Recipient:306972345678<br />"
     * one recipient : "SUCCESS MessageId: 5575f02a3016c-2648-59494;Recipient:306971234567"
     * error: "ERROR:001; STATUS:Invalid username or password"
     * error: "ERROR:003; STATUS:Out Of Credit"
     */
}

function returnSMS() {
    $credits = file_get_contents(SMS_CREDITS_URL, null, stream_context_create(array('http' => array('timeout' => 5))));

    if ($credits === false) {
        return 0;
    }

    $credits = json_decode($credits, true);

    if ($credits === false) {
        return 0;
    }

    return $credits['credits'];
}

function getAccountInfo() {
    $info = file_get_contents(SMS_CREDITS_URL, null, stream_context_create(array('http' => array('timeout' => 5))));
    $info = json_decode($info, true);

    return $info;
}

function getLatinText($text) {
    $greek = array("Α", "Β", "Ε", "Ζ", "Η", "Ι", "Κ", "Μ", "Ν", "Ο", "Ρ", "Τ", "Υ", "Χ");
    $latin = array("A", "B", "E", "Z", "H", "I", "K", "M", "N", "O", "P", "T", "Y", "X");
    return str_replace($greek, $latin, $text);
}

  //  $firebaseTokensWithErrors = sendNotifications(SMS_FROM, $firebaseTokens,$msgText);

function sendNotifications($messageTitle,$arrayOfTokens, $messageBody ) {
//echo "mpike";
//echo APP_LOGO;
    $actual_link = $_SERVER['PHP_SELF'];
    $actual_link = explode('/', $actual_link);
    $serverLocationForInbox = "http://" . $_SERVER['HTTP_HOST'] . "/" . $actual_link[1] . "/inbox.php?phone=";
    $serverLocationForInboxInMember = "http://" . $_SERVER['HTTP_HOST'] . "/" . $actual_link[1] . "/member/";
    //echo "server location inbox : ".$serverLocationForInbox;

    //global $dao; // Ωστέ να μην το ξαναφτίαξουμε
    $connector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
    $mysqlConnection = $connector->getConnection();
    $dao = new Dao($mysqlConnection);
    $messageNotificationBody = $messageBody;

    /*
     * Παρακάτω απλά κομματίαζω τον πίνακα σε 1000αδες γιατί στο
     * firabase μπορούμε να στείλουμε μέχρι 1000 tokens ταυτόχρονα
     */

    if (count($arrayOfTokens) <= 1000)
        $end = count($arrayOfTokens);
    else
        $end = 1000;

    $i = 0;

    // Το σύνολο των επιτυχημένων μηνυμάτων που στάλθηκαν
    $sumOfSuccess = 0;
    $start = 0;
    $failedTokens = []; //Ο πίνακας που θα αποθηκεύσουμε τα tokens που δεν στάλθηκαν
    //print_r($arrayOfTokens);
    while ($start < count($arrayOfTokens)) {
echo "while";
        $end = ($i + 1) * $end;

        if ($end > count($arrayOfTokens))
            $end = count($arrayOfTokens);
        /* ------------------------------------- */
        $slicedArrayOfTokens = array_slice($arrayOfTokens, $start, $end);
        $notification = array
            (
            'body' => $messageNotificationBody,
            'title' => $messageTitle,
            'image' => APP_LOGO,
            'icon' => APP_LOGO,
            "click_action" =>$serverLocationForInboxInMember,
            'sound' => 'mySound'/* Default sound */
        );
         $notificationAndroid = array
            (
            "click_action" =>"OPEN_ACTIVITY_1",
        );

        $msg = array(
            'body' => $messageNotificationBody,
            'title' => $messageTitle,
             'image' => APP_LOGO,
            'icon' => APP_LOGO,
            "SERVER_LOCATION_FOR_ΙΝΒΟΧ" => $serverLocationForInbox,
            "click_action" =>$serverLocationForInboxInMember
        );
         $fcm_options= array ( 
            'link' => 'https://www.piatsa.com.gr/gr/'
      );
        $fields = array(
            'registration_ids' => $slicedArrayOfTokens,
            'notification' => $notification,
            'priority' => 'high',
            'android' => $notificationAndroid,
            'fcm_options' => $fcm_options

            //'data' => $msg
        );
        $headers = array(
            'Authorization: key=' . API_ACCESS_KEY,
            'Content-Type: application/json'
        );
        // Send Reponse To FireBase Server
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        $jsonResult = curl_exec($ch);
        $jsonObject = json_decode($jsonResult); // Πόσα μηνύματα στάλθηκαν με επιτυχία
        $success = $jsonObject->success;
        $sumOfSuccess += $success;
        
        if ($jsonResult === FALSE) {
    die('FCM Send Error: ' . curl_error($ch));
    }
  
        curl_close($ch);
#Echo Result Of FireBase Server
//print_r($jsonResult);


        // Στην χιλιάδα ψάχνω για errors
        for ($k = 0; $k < count($jsonObject->results); $k ++) {
            if (isset($jsonObject->results[$k]->error)) {
                $failedTokens[] = $arrayOfTokens[$start + $k];
            }
        }

        curl_close($ch);
        // Echo Result Of FireBase Server

        /* -------------------------------------- */
        $i ++;
        $start = $i * $end;
    }


    return $failedTokens;
}
/**
 * Μετατρέπει έναν πολυδιάστατο πίνακα σε μονοδιάστατο αγνοώντας τα κενά κελιά
 * @param array $array Ο δισδιάστατος πίνακας που που περιέχει τα tokens
 * @return array $tokens Μονοδιάστατος πίνακας με όλα τα tokens
 */
function multidimension_array_values($array) {
    $arr = [];
    foreach ($array as $key => $values) {
        foreach ($values as $value) {
        //    echo "to value einai ".$value;
            if ($value) {
                $arr[] = $value;
            }
        }
    }
    //echo "multi dimension<br>";
    //print_r($arr);
    return $arr;
}
/**
 * Βρίσκει ποια τηλέφωνα πήραν ειδοποίηση, θεωρείται ότι ειδοποιήθηκε 
 * αν πήρε ειδοποίηση από την εφαρμογή 
 * 
 * @param array $phonesWithFirebaseTokens Ο δισδιάστατος πίνακας που που περιέχει τα tokens
 * @param array $firebaseTokensWithErrors Ο πίνακας με τα εσφαλμένα tokens
 * @return array $phonesGotMessage τα τηλέφωνα που πήραν ειδοποίηση
 */
function phonesGotMessage($phonesWithFirebaseTokens, $firebaseTokensWithErrors) {
    $phonesGotMessage = [];
   // echo "<br>phonesWithFirebaseTokens <br>";
  //  print_r($phonesWithFirebaseTokens);
    
  //    echo "<br>firebaseTokensWithErrors<br>";
  //  print_r($firebaseTokensWithErrors);
    foreach ($phonesWithFirebaseTokens as $phone => $tokens) {
            //tokens[0] android token
            if ($tokens[0] && !in_array($tokens[0], $firebaseTokensWithErrors)) {
                //$gotMessage = true;
                $phonesGotMessage[] = $phone;
            }

    }

    return $phonesGotMessage;
}

?>
