<?php

    require_once 'DatabaseConnector.php';
    require_once 'config.php';
    require_once 'Dao.php';
    require_once 'CredentialsDB.php';
  
    
    //Σύνδεση στην βάση
    $connector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
    $mysqlConnection = $connector->getConnection();
    $dao = new Dao($mysqlConnection);


    //Επιλογή διαγραφής από το κουμπί στο promotions.php
    if(isset($_GET['promotionID'])){
        $promotionID = $_GET['promotionID'];
        
       
              
        $dao->deletePromotionClassFromDB($promotionID);
        header("Location: promotion-form.php?message=Το promotion διαγράφηκε επιτυχώς");
        exit();

               
     
    

    }
    //Na prosexkw to selector
    else if(isset($_POST['promotionTitle'],$_POST['promotionBody'],$_POST['expireDate'],$_POST['category'])){
        $promotionTitle = $_POST['promotionTitle'];
        $promotionBody = $_POST['promotionBody'];
        $expireDate = $_POST['expireDate'];
        $categoryOfPromotion = $_POST['category'];
        $categoryOfPromotion = secureSelector($categoryOfPromotion);//Για λόγους ασφάλειας


        /*
            Παρακάτω αυτό το κάνω για λόγους ασφάλειας
            ώστε να μην μπορεί κάποιος να βάλεις από το url μη δικό του storeID

        */
       
       
            if($expireDate == ""){
                $expireDate = "0000-00-00";
            }
            $promotion = new PromotionClass("",$promotionTitle,$promotionBody,"",$expireDate,$categoryOfPromotion);
            $dao->savePromotionClassToDB($promotion);
            
            //$tokens = $dao->getAllTokens();
            $tokens = $dao->getTokensFromCategory($categoryOfPromotion);
            $fireBaseTokenArray = array();
            foreach($tokens as $token){
                $fireBaseTokenArray[] = $token['token_id'];
            }
            $message = sendPromotionMessage($fireBaseTokenArray, STORE_NAME,$promotionTitle, $promotionBody,$categoryOfPromotion);
            header("Location: promotion-form.php?message=$message");
            exit();
   
    }
    else{
        die("somethings wrong with parameters");
    }
    
    
    
    function sendPromotionMessage($fireBaseTokenArray,$bussinessName,$title, $messageBody,$categoryOfPromotion){
        
        global $dao;
         $actual_link = $_SERVER['PHP_SELF'];
         $actual_link = split('/', $actual_link);
         $promotion_script_location = "http://" . $_SERVER['HTTP_HOST'] . "/" . $actual_link[1] . "/android-promotions-webview.php?category=$categoryOfPromotion";
        /* Το παρακάτω το χρειαζόμαστε ώστε να μπορούμε να στείλουμε το $promotionID με το firebase. Το παίρνουμε έτσι γιατί πρώτα στέλνουμε
         * notification και μετά το αποθηκεύουμε στην db
         */
        $promotionID = $dao->getNextPromotionID();
        $i = 0;
        if (count($fireBaseTokenArray) <= 1000)
            $end = count($fireBaseTokenArray);
            else
                $end = 1000;
                
                $i = 0;
                
                //Το σύνολο των επιτυχημένων μηνυμάτων που στάλθηκαν
                $sumOfSuccess = 0;
                $start = 0;
                while ($start < count($fireBaseTokenArray)) {
                    
                    $end = ($i + 1) * $end;
                    
                    if ($end > count($fireBaseTokenArray))
                        $end = count($fireBaseTokenArray);
                        /* ------------------------------------- */
                        $slicedArrayOfTokens = array_slice($fireBaseTokenArray, $start, $end);
                        $to = $fireBaseTokenArray;
                        
                        $msg = array
                        (
                            'body' => $messageBody,
                            'title' => 'Promotion '.$bussinessName." : ".$title,
                            'PROMOTION_SCRIPT_LOCATION' => $promotion_script_location
                        );
                        
                         $notification = array
                            (
                           
                            'body' => $messageBody,
                            'title' => 'Promotion '.$bussinessName." : ".$title,
                            "icon" => "efarmogi",
                            'sound' => 'mySound'/* Default sound */
                        );
                        
                        
                        $fields = array
                        (
                            'registration_ids' => $slicedArrayOfTokens,
                            'notification' => $notification,
                            'data' => $msg
                        );
                        
                        
                        $headers = array
                        (
                            'Authorization: key=' . API_ACCESS_KEY,
                            'Content-Type: application/json'
                        );
                      
                        //echo json_encode($fields,JSON_UNESCAPED_SLASHES);
                        //exit();
                        //Send Reponse To FireBase Server
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields, JSON_UNESCAPED_SLASHES));
                        
                        $jsonResult = curl_exec($ch);
                        $jsonObject = json_decode($jsonResult); //Πόσα μηνύματα στάλθηκαν με επιτυχία
                        
                        
                        
                        $success = $jsonObject->success;
                        $sumOfSuccess += $success;
                        $failures = count($fireBaseTokenArray) - $sumOfSuccess;
                        
                        curl_close($ch);
                        #Echo Result Of FireBase Server
                        
                        /* -------------------------------------- */
                        $i++;
                        $start = $i * $end;
                }
                
                return "Στάλθηκαν επιτυχώς ".$sumOfSuccess ." από τα ". count($fireBaseTokenArray) . " μηνύματα";
                
                
                
    }
    function secureSelector($category){
        $categoryValue = "all";

        if($category == "custom1"){
            $categoryValue = "custom1";
        }
        else if($category == "custom2"){
            $categoryValue = "custom2";
        }
        else if($category == "custom3"){
            $categoryValue = "custom3";
        }
        else if($category == "custom4"){
            $categoryValue = "custom4";
        }
        else if($category == "custom5"){
            $categoryValue = "custom5";
        }
        else if($category == "custom6"){
            $categoryValue = "custom6";
        }
        else if($category == "custom7"){
            $categoryValue = "custom7";
        }
        else if($category == "custom8"){
            $categoryValue = "custom8";
        }
        else if($category == "custom9"){
            $categoryValue = "custom9";
        }
        else if($category == "custom10"){
            $categoryValue = "custom10";
        }
        else if($category == "custom11"){
            $categoryValue = "custom11";
        }
        else if($category == "custom12"){
            $categoryValue = "custom12";
        }
        return $categoryValue;
    }





?>