<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
require_once 'functions-transaction.php';
require_once __DIR__.'/auth.php';
require_once __DIR__ . '/../account-manager81/config.php';
require_once 'DatabaseConnector.php';
require_once __DIR__ . '/../account-manager81/dao/AccountDao.php';
require_once __DIR__ . '/../account-manager81/dao/LoyaltyCatalogueDao.php';
require_once __DIR__ . '/../account-manager81/dao/SmsCatalogueDao.php';
require_once __DIR__ . '/../account-manager81/dao/SmsCatalogueDao.php';
require_once __DIR__ . '/../account-manager81/dao/LoyaltyPriceDao.php';
require_once __DIR__ . '/../account-manager81/dao/SmsPriceDao.php';
require_once __DIR__ . '/../libs/net2020/utils/SQLFilter.php';


$databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
$connection = $databaseConnector->getConnection();

$accountDao = new AccountDao($connection);
$loyaltyPriceDao = new LoyaltyPriceDao($connection);
$smsPriceDao = new SmsPriceDao($connection);

$accountId = $_SESSION['SESS_ACCOUNT_SENDER'];

$result = $accountDao->findAll((new SQLFilter("sender = $accountId")));

if(count($result) == 0) {
    echo "account id:".$accountId;
    die("Account not found!");
}

// Account sender is unique
$account = $result[0];


 //Getting the loyalty prices for the specific catalogue
if ($account->getLoyaltyCatalogueId()) {
    $loyaltyPrices = $loyaltyPriceDao->findAll((new SQLFilter("loyaltyCatalogueId = {$account->getLoyaltyCatalogueId()}")));
} else {
    $loyaltyCatalogueDao = new LoyaltyCatalogueDao($connection);
    // The default loyalty catalogue should have name default
    $defaultLoyaltyCatalogue = $loyaltyCatalogueDao->findAll((new SQLFilter("name = Default")))[0];

    $loyaltyPrices = $loyaltyPriceDao->findAll((new SQLFilter("loyaltyCatalogueId = {$defaultLoyaltyCatalogue->getId()}")));
}

// Getting the sms prices for the specific catalogue
if ($account->getSmsCatalogueId()) {
    $smsPrices = $smsPriceDao->findAll((new SQLFilter("smsCatalogueId = {$account->getSmsCatalogueId()}")));
} else {
    $smsCatalogueDao = new SmsCatalogueDao($connection);
    // The default sms catalogue should have name default
    $defaultSmsCatalogue = $smsCatalogueDao->findAll((new SQLFilter("name = Default")))[0];

    $smsPrices = $smsPriceDao->findAll((new SQLFilter("smsCatalogueId = {$defaultSmsCatalogue->getId()}")));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <style>
        .xloyalty-header {
            width: 100%;
            background: #ffffff;
            padding: 15px 20px;
            border-bottom: 1px solid #e5e5e5;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .xloyalty-header img {
            height: 155px;
        }
    </style>
</head>
<body>

<div class="xloyalty-header">
    <img src="xloyalty.png" alt="xLoyalty Logo">
</div>
<?
require_once 'price-catalogues-view.php';
