<?php
if (session_id() === '') {
    session_start();
}
require_once 'functions-transaction.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../libs/net2020/DatabaseConnector.php';
require_once __DIR__ . '/../account-manager81/config.php';
require_once __DIR__ . '/../account-manager81/models/LoyaltyPrice.php';
require_once __DIR__ . '/../account-manager81/models/SmsPrice.php';
require_once __DIR__ . '/../account-manager81/dao/LoyaltyPriceDao.php';
require_once __DIR__ . '/../account-manager81/dao/SmsPriceDao.php';
require_once './Payment3DSFactory.php';

if (!isset($_GET['id'], $_GET['type'])) {
    die("wrong params...");
}

$typeId = secureInput($_GET['id']);
$type = secureInput($_GET['type']);

$types = ['loyalty', 'sms'];

if (!in_array($type, $types)) {
    die("Invalid type");
}

$types = ['loyalty', 'sms'];

if (!in_array($type, $types)) {
    die("Invalid type");
}

$databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
$connection = $databaseConnector->getConnection();

$amount = getAmount($connection, $types, $type, $typeId) * 100; // viva accepts the price as integer

try {

    $payment3DSService = Payment3DSFactory::create('stripe');

    // passing the params as a base 64 encoded json to avoid url decoding problems
    $data = base64_encode(
            json_encode([
        "id" => $typeId,
        "type" => $type])
    );

    $successUrl = getRedirectUrl("payment-charge.php?data=$data");
    $cancelUrl = getRedirectUrl("price-catalogues.php");
    
    $payment3DSService->requestPayment($amount, $successUrl, $cancelUrl);
    
} catch (Exception $ex) {
    error_log($ex);
    header("Location: payment-failure.php");
    die();
}

function getRedirectUrl($redirectScript) {
    $actualLink = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

    $actualLink = explode("/", $actualLink);
    $actualLink[count($actualLink) - 1] = $redirectScript;

    return $sessionRedirectUrl = implode("/", $actualLink);
}

function getAmount($connection, $types, $type, $typeId) {

    // handle loyalty subscription update
    if ($type == $types[0]) {

        $loyaltyPriceDao = new LoyaltyPriceDao($connection);
        $loyaltyPrice = $loyaltyPriceDao->findById($typeId);

        if (!$loyaltyPrice) {
            die("Wrong type id");
        }

        return $loyaltyPrice->getPrice();

        // handle sms credits addition
    } else {

        $smsPriceDao = new SmsPriceDao($connection);
        $smsPrice = $smsPriceDao->findById($typeId);

        if (!$smsPrice) {
            die("Wrong type id");
        }

        return $smsPrice->getPrice();
    }
}
