<?php
if (session_id() === '') {
    session_start();
}

// μετά τα require/uses κλπ...

error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'functions-transaction.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../libs/net2020/DatabaseConnector.php';
require_once __DIR__ . '/../libs/net2020/utils/SQLFilter.php';
require_once __DIR__ . '/../account-manager81/config.php';
require_once __DIR__ . '/../account-manager81/models/LoyaltyPrice.php';
require_once __DIR__ . '/../account-manager81/dao/AccountDao.php';
require_once __DIR__ . '/../account-manager81/dao/LoyaltyPriceDao.php';
require_once __DIR__ . '/../account-manager81/services/LoyaltySubscriptionService.php';
require_once __DIR__ . '/../account-manager81/dao/SmsPriceDao.php';
require_once __DIR__ . '/../account-manager81/dao/CreditDao.php';
require_once __DIR__ . '/../account-manager81/services/SmsCreditsService.php';
require_once __DIR__ . '/../account-manager81/models/Account.php';
require_once './Payment3DSFactory.php';


if (!isset($_GET['data'])) {
    die("wrong params...");
}

$obj = json_decode(base64_decode($_GET['data']));

$typeId = secureInput($obj->id);
$type = secureInput($obj->type);

$types = ['loyalty', 'sms'];

if (!in_array($type, $types)) {
    die("Invalid type");
}

try {

    $databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
    $connection = $databaseConnector->getConnection();

    $accountSender = $_SESSION['SESS_ACCOUNT_SENDER'];

    $accountDao = new AccountDao($connection);

    $result = $accountDao->findAll((new SQLFilter("sender = $accountSender")));

    if (count($result) == 0) {
        die("Account not found");
    }

    $account = $result[0];

    $payment3DSService = Payment3DSFactory::create('stripe');

// handle loyalty subscription update
    if ($type == $types[0]) {

        $loyaltyPriceDao = new LoyaltyPriceDao($connection);
        $loyaltyPrice = $loyaltyPriceDao->findById($typeId);

        if (!$loyaltyPrice) {
            die("Wrong type id");
        }

        $amount = $loyaltyPrice->getPrice() * 100;
        $payment3DSService->makeTheActualCharge($amount, $account);

        $loyaltySubscriptionService = new LoyaltySubscriptionService($accountDao);
        $newExpirationDate = $loyaltySubscriptionService->updateSubscription($account, $loyaltyPrice->getPeriod());

        $msg = "Η συνδρομή σας ανανεώθηκε με νέα ημερομηνία λήξης συνδρομης $newExpirationDate";
       // na kanei eggrafi sto account net2020 gia nea synallagi ananewshs syndromis me klisi sto transaction.php me $amount/100
        header("Location: payment-success.php?msg=$msg");
        die();
    } else { // handle sms credits addition
        
        $smsPriceDao = new SmsPriceDao($connection);
        $smsPrice = $smsPriceDao->findById($typeId);

        if (!$smsPrice) {
            die("Wrong type id");
        }

        $amount = $smsPrice->getPrice() * 100;
        $payment3DSService->makeTheActualCharge($amount, $account);

        $creditDao = new CreditDao($connection);

        $smsCreditsService = new SmsCreditsService($creditDao);
        $creditsAdded = $smsCreditsService->addCredits($account, $smsPrice->getAmount());

        $msg = "Προστέθηκαν $creditsAdded sms credits στον λογαριασμό σας!";
               // na kanei eggrafi sto account net2020 gia nea synallagi ananewshs syndromis me klisi sto transaction.php me $amount/100

        header("Location: payment-success.php?msg=$msg");
        die();
    }
} catch (Exception $ex) {
    error_log($ex);
    echo $ex;
  //  header("Location: payment-failure.php");
    die();
}