<?php
	header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

	require_once('auth.php');
	require_once('config.php');
	require_once('sendSMS.php');
	require('header.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title>Marketing analytics and sms targeting</title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
<script type="text/javascript" language="javascript">
	function showMsg(){
		alert("<?=SENDING_PROCESS_DURATION ?>");
	}
    function printDiv(store){
        var content = document.getElementById("printable");
        document.getElementById("chart").style.display="none";
        document.getElementById("printButton").style.display="none";
        var pri = document.getElementById("printwindow").contentWindow;
        pri.document.open();
        pri.document.write('<div><img src="images/logo.png" /><br /><br />');
        pri.document.write(content.innerHTML);
        pri.document.write('</div>');
        pri.document.close();
        pri.focus();
        pri.print();
        document.getElementById("chart").style.display="initial";
        document.getElementById("printButton").style.display="initial";
    }
</script>
<script src="Chart.min.js"></script>
</head>

<body>

<?php headerDiv();?>

	<div class="main">
		<h1>Marketing segmentation stats and campaigns</h1>
        <div id="printable" >
<?php
	$smsFlag = false;
	//Connect to mysql server
	$link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
	if(!$link) {
		die(ERROR_DATABASE_CONNECTION_FAILURE);
	}

	//Select database
	$db = mysql_select_db(DB_DATABASE);
	if(!$db) {
		die(ERROR_DATABASE_CONNECTION_FAILURE);
	}

	mysql_query("SET sql_mode = '', character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'", $link)
	or die(mysql_error());

	$campaigntype = "1";
	if(isset($_POST['campaigntype']))
		$campaigntype = secureInput($_POST['campaigntype']);
		
		if(isset($_POST['members9']))
		$members9=secureInput($_POST['members9']);

	$days = "0";
	if(isset($_POST['days'.$campaigntype]) && intval($_POST['days'.$campaigntype]) != "")
		$days = intval($_POST['days'.$campaigntype]);

	$visits = "1";
	if(isset($_POST['visits'.$campaigntype]) && intval($_POST['visits'.$campaigntype]) != "")
		$visits = intval($_POST['visits'.$campaigntype]);

    $smsMsg = "";
	if(isset($_POST['msg'])){
		if ($_POST['msg'] != ""){
			$smsMsg = getLatinText($_POST['msg']);
            $smsMsg = htmlspecialchars($smsMsg);
		}
		else{
			$smsFlag = true;
		}
	}
	else{
		$smsFlag = true;
	}

	$whereStoreOnly = "";
    if ($_SESSION['SESS_ADMIN'] != "y") {
        $whereStoreOnly = " AND t.store_id = " . $_SESSION['SESS_STORE_AUTO_ID'] . " ";
    } 
    
    // παρε τον κωδικο καταστηματος 
    if($_POST['store_id']!="all") $whereStoreOnly = " AND t.store_id = ". $_POST['store_id'];

	$pastSeconds = time() - 86400*$days;
	$past = date("Y-m-d 00:00:01", $pastSeconds);
	$dateToDisplay = date("d/m/Y", $pastSeconds);
	$randomCustomers = false;

    if ($campaigntype == "0") {
        if(empty($_SESSION['SESS_LOYALTY_TIME_A']) || empty($_SESSION['SESS_LOYALTY_TIME_B'])) {
            echo '<p class="main">'. MUST_SET_INTERVALS_FOR_LOYALTY_CHECK.'</p>';
            die();
        }
        echo '<p class="main">'.CUSTOMERS_WITH_LOYALTY_ABOVE  . $days . '% '. BASED_ON_LAST  . ($_SESSION['SESS_LOYALTY_TIME_A'] + $_SESSION['SESS_LOYALTY_TIME_B']) .  DAYS .'</p>';

        $pastA = date("Y-m-d 00:00:01", strtotime("-" . ($_SESSION['SESS_LOYALTY_TIME_A'] + $_SESSION['SESS_LOYALTY_TIME_B']) . " days"));
        $pastB = date("Y-m-d 00:00:01", strtotime("-" . $_SESSION['SESS_LOYALTY_TIME_B'] . " days"));

        $qry = "
        SELECT customer_id, name, surname, phone, money, timeA, timeB, ROUND((timeB/((timeA*" . $_SESSION['SESS_LOYALTY_TIME_B'] . ")/" . $_SESSION['SESS_LOYALTY_TIME_A'] . "))*100, 2) AS `loyalty` FROM (
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            SUM(IF(`t`.`date` >= '".$pastA."' AND `t`.`date` < '".$pastB."', 1, 0)) AS `timeA`,
            SUM(IF(`t`.`date` >= '".$pastB."' AND `t`.`date` < NOW(), 1, 0)) AS `timeB`,
            SUM(`t`.`money`) AS `money`
            FROM `customers`
            INNER JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id` " . $whereStoreOnly;
        if(!$smsFlag) {
            $qry .= " WHERE `customers`.`sms` = 1 ";
        }
        $qry .= "GROUP BY `customers`.`id` HAVING timeA > 0 AND timeB > 0) AS temp HAVING loyalty ".$_REQUEST["loyaltyratio"] . $days." ORDER BY loyalty";
    }
	elseif ($campaigntype == "1") {
        $visits2 = "0";
        if(isset($_POST['visits1_2']) && intval($_POST['visits1_2']) != "")
            $visits2 = intval($_POST['visits1_2']);

        echo '<p class="main">'.CUSTOMERS_NOT_SHOWN_IN_STORE . $days .  DAYS_AND_IN_THE_PAST_MADE   . $visits2 .  TO  . $visits .   VISITS .'</p>';


        $qry = "
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            SUM(IF(`t`.`date` < '".$past."', 1, 0)) AS `beforecounter`,
            SUM(IF(`t`.`date` >= '".$past."', 1, 0)) AS `aftercounter`,
            SUM(`t`.`money`) AS `money`
            FROM `customers`
            INNER JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id`" . $whereStoreOnly;;
        if(!$smsFlag) {
            $qry .= " WHERE `customers`.`sms` = 1 ";
        }
        if ($_SESSION['SESS_ADMIN'] != "y") {
                $qry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
            }
            else {
              if($_POST['store_id']!="all") $qry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }
        $qry .= "
GROUP BY `customers`.`id`
HAVING `beforecounter` <= ".$visits." AND `beforecounter` >= ".$visits2." AND `aftercounter` = 0"
;
	}
	elseif ($campaigntype == "2") {
        $visits2 = "10";
        if(isset($_POST['visits2_2']) && intval($_POST['visits2_2']) != "")
            $visits2 = intval($_POST['visits2_2']);

        echo '<p class="main">';

        if(!empty($_POST['random2']) && is_numeric($_POST['random2'])) {
            $randomCustomers = true;
            $smsFlag = true;
            echo  DISPLAY  . $_POST['random2'] .  RANDOM_CUSTOMERS ;
        }
        else {
            echo  CUSTOMERS ;
        }

        echo 'who did '.$visits.' to '.$visits2.' transactions ';
        if(!empty($_POST['from_days_2']) && !empty($_POST['till_days_2'])) {
            echo 'from ' . date("d/m/Y", strtotime($_POST['from_days_2'])) . ' to ' . date("d/m/Y", strtotime($_POST['till_days_2']));
        }
        echo '</p>';

		$qry = "
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            COUNT(t.id) AS `visits`,
            SUM(`t`.`money`) AS `money`
            FROM `customers`
            INNER JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id` " . $whereStoreOnly . " WHERE 1 ";
            
        if(!$smsFlag) {
            $qry .= " AND `customers`.`sms` = 1 ";
        }
        if(!empty($_POST['from_days_2']) && !empty($_POST['till_days_2'])) {
            $qry .= " AND `t`.`date` BETWEEN '" . $_POST['from_days_2'] . " 00:00:00' AND '" . $_POST['till_days_2'] . " 23:59:59'";
        }
         
         if ($_SESSION['SESS_ADMIN'] != "y") {
             $qry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
         }
         else {
              if($_POST['store_id']!="all") $qry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }
        $qry .= " GROUP BY `customers`.`id` ";
        $qry .= "HAVING `visits` >= ".$visits." AND `visits` <= ".$visits2;

        if($randomCustomers) {
            $qry .= " ORDER BY RAND() LIMIT " . $_POST['random2'];
        }
	}
    elseif ($campaigntype == "3") {
        echo '<p class="main">'. CUSTOMERS_OF_GROUP  . $_SESSION['SESS_CUSTOM_FIELD' . $visits] . '</p>';

        $qry = "
SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`, SUM(`t`.`points`) AS `totalpoints`, SUM(`t`.`money`) AS `money`
FROM `customers`
INNER JOIN transactions AS t ON t.customer_auto_id = customers.id " . $whereStoreOnly . " WHERE 1 AND ";
        if(!$smsFlag) {
            $qry .= " `customers`.`sms` = 1 AND";
        }
        $qry .= " `customers`.`custom" . $visits . "` = 'y' ";
        $qry .= " GROUP BY `customers`.`id`";
    }
    elseif ($campaigntype == "4") {
        echo '<p class="main">'.CUSTOMERS_WITH_TURNOVER_ABOVE  . $visits . ' €';
        if(!empty($_POST['service4'])) {
            echo IN_THE_SERVICE_PRODUCT  . $_POST['service4'];
        }
        echo '.</p>';

        $qry = "
SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`, SUM(`t`.`money`) AS `money`
FROM `customers`
INNER JOIN transactions AS t ON t.customer_auto_id = customers.id " . $whereStoreOnly . " WHERE 1 ";
        if(!$smsFlag) {
            $qry .= " AND `customers`.`sms` = 1 ";
        }
        if(!empty($_POST['service4'])) {
            $qry .= " AND t.services LIKE '%" . $_POST['service4'] . "%' ";
        }
        if ($_SESSION['SESS_ADMIN'] != "y") {
                $qry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
            }
            else {
              if($_POST['store_id']!="all") $qry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }
        $qry .= " GROUP BY `customers`.`id` HAVING money >= ".$visits;
        $qry .= " ORDER BY `money` DESC";
    }
    elseif ($campaigntype == "5") {
        $visits2 = "10";
        if(isset($_POST['visits5_2']) && intval($_POST['visits5_2']) != "")
            $visits2 = intval($_POST['visits5_2']);

        echo '<p class="main">';
        if(!empty($_POST['random5']) && is_numeric($_POST['random5'])) {
            $randomCustomers = true;
            $smsFlag = true;
echo DISPLAY . ' ' . htmlspecialchars($_POST['random5']) . ' ' . RANDOM_CUSTOMERS; 
        }
        else {
            echo CUSTOMERS ;
        }

echo WHO_MADE_TURNOVER_FROM . ' ' . htmlspecialchars($visits) . ' ' . TO . ' ' . htmlspecialchars($visits2) . ' €'; 
        if(!empty($_POST['from_days_5']) && !empty($_POST['till_days_5'])) {
            echo ' from ' . date("d/m/Y", strtotime($_POST['from_days_5'])) . ' to ' . date("d/m/Y", strtotime($_POST['till_days_5']));
        }
        if(!empty($_POST['service5'])) {
        echo IN_THE_SERVICE_PRODUCT . ' ' . htmlspecialchars($_POST['service5']); 
        }
        echo '.</p>';

        $qry = "
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            SUM(`t`.`money`) AS `money`
            FROM `customers`
            INNER JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id` " . $whereStoreOnly . "
            WHERE `t`.`money` > 0 ";

        if(!$smsFlag) {
            $qry .= " AND `customers`.`sms` = 1 ";
        }

        if(!empty($_POST['service5'])) {
            $qry .= " AND `t`.`services` LIKE '%" . $_POST['service5'] . "%' ";
        }

        if(!empty($_POST['from_days_5']) && !empty($_POST['till_days_5'])) {
            $qry .= " AND `t`.`date` BETWEEN '" . $_POST['from_days_5'] . " 00:00:00' AND '" . $_POST['till_days_5'] . " 23:59:59'";
        }
        if ($_SESSION['SESS_ADMIN'] != "y") {
                $qry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
            }
            else {
              if($_POST['store_id']!="all") $qry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }

        $qry .= " GROUP BY `customers`.`id`
            HAVING `money` >= ".$visits." AND `money` <= ".$visits2;

        if($randomCustomers) {
            $qry .= " ORDER BY RAND() LIMIT " . $_POST['random5'];
        }
    }
    elseif ($campaigntype == "6") {
        $monthsAgoTimestamp = strtotime("midnight -".$days." months");
        if($days == 0) {
            $monthsAgoTimestamp = strtotime("first day of this month");
        }
        else {
            $monthsAgoTimestamp = strtotime("first day of this month", $monthsAgoTimestamp);
        }

echo '<p class="main">' . NEW_MEMBERS_LAST . ' ' . htmlspecialchars($days) . ' ' . MONTHS . '</p>';

        $qry = "
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            SUM(IFNULL(`t`.`money`, 0)) AS `money`, UNIX_TIMESTAMP(signup_date) as signup_timestamp, MONTH(signup_date) as `month`
            FROM `customers`
            LEFT JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id` " . $whereStoreOnly . "
            WHERE signup_date < CURRENT_DATE() AND UNIX_TIMESTAMP(`signup_date`) >= ".$monthsAgoTimestamp;

        if ($_SESSION['SESS_ADMIN'] != "y") {
            $qry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
        }
        else {
              if($_POST['store_id']!="all") $qry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }

        if(!$smsFlag) {
            $qry .= " AND `customers`.`sms` = 1 ";
        }

        $qry .= " GROUP BY `customers`.`id` ORDER BY signup_date DESC";
    }
    elseif ($campaigntype == "7") {
echo '<p class="main">' . MEMBERS_AGE_FROM . ' ' . htmlspecialchars($days) . ' ' . TO . ' ' . htmlspecialchars($visits) . ' ' . YEARS_OLD . '</p>';

        $qry = "
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            SUM(IFNULL(`t`.`money`, 0)) AS `money`,
            DATE_FORMAT(NOW(), '%Y') - DATE_FORMAT(customers.age, '%Y') - (DATE_FORMAT(NOW() , '00-%m-%d') < DATE_FORMAT(customers.age, '00-%m-%d')) AS `age`
            FROM `customers`
            LEFT JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id` " . $whereStoreOnly . "
            WHERE `customers`.`age` IS NOT NULL AND `customers`.`age` != '0000-00-00' AND DATE_FORMAT(NOW(), '%Y') - DATE_FORMAT(`customers`.`age`, '%Y') - (DATE_FORMAT(NOW() , '00-%m-%d') < DATE_FORMAT(`customers`.`age`, '00-%m-%d')) BETWEEN ".$days." AND ".$visits;

        if ($_SESSION['SESS_ADMIN'] != "y") {
            $qry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
        }
        else {
              if($_POST['store_id']!="all") $qry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }

        if(!$smsFlag) {
            $qry .= " AND `customers`.`sms` = 1 ";
        }

        $qry .= " GROUP BY `customers`.`id` ORDER BY age DESC";
    }
    elseif ($campaigntype == "8") {
        $service = $_POST['service8'];
echo '<p class="main">' . MEMBERS_WHO_TRANSACTED_WITH_SERVICE_PRODUCT . ' ' . htmlspecialchars($visits) . ' ' . IN_THE_LAST . ' ' . htmlspecialchars($days) . ' ' . DAYS . '</p>';

        $qry = "
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            SUM(IFNULL(`t`.`money`, 0)) AS `money`
            FROM `customers`
            INNER JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id` " . $whereStoreOnly . "
            WHERE `t`.`date` >= '".$past."' AND `t`.`services` LIKE '%".$service."%'";

        if(!$smsFlag) {
            $qry .= " AND `customers`.`sms` = 1 ";
        }

        $qry .= " GROUP BY `customers`.`id`";
    }
    
     elseif ($campaigntype == "9") {
           if($_POST['store_id']!="all") $whereStoreOnly = " where transactions.store_id = ". $_POST['store_id'];
           else $whereStoreOnly="";
           
           $qry = "
            SELECT customers.customer_id, customers.name , customers.surname,
       customers.phone , sum(transactions.money) AS money
FROM customers JOIN transactions ON customers.id = transactions.customer_auto_id
$whereStoreOnly 
GROUP BY customers.customer_id
ORDER BY money DESC
LIMIT ".$members9;
    

       
        $smsHistoryTitle = 'Marketing: TOP 5 Members';
    
    }

//	echo $qry ;

    if($smsFlag == false) {
        echo '<p class="main">'.MESSAGE_WILL_BE_SENT_TO_THE_FOLLOWING.' <span id="num"></span>'.CUSTOMERS.':</p>';
        echo '<p>'.$smsMsg.'</p>';
    }

    $phoneNumbers = array();

	$result = mysql_query($qry) or die(mysql_error());
	$rows_result = mysql_num_rows($result);
	
    $sumResult = mysql_query("SELECT SUM(money) AS money FROM (".$qry.") AS temp") or die(mysql_error());
    $sumRow = mysql_fetch_array($sumResult);

    /* sum only positive money values? */
	$totalMoneyResult = mysql_query("SELECT SUM(money) AS totalmoney FROM transactions") or die(mysql_error());
    $totalMoneyRow = mysql_fetch_array($totalMoneyResult);
	$totalClientsResult = mysql_query("SELECT count(id) AS clients FROM customers") or die(mysql_error());
    $totalClientsRow = mysql_fetch_array($totalClientsResult);
	$posostoClients=($rows_result*100)/$totalClientsRow["clients"];
    $rows = mysql_num_rows($result);
	
    $results = 0;
    if($rows > 0) {

        if(!$randomCustomers) {
            echo '<p class="main">'.TURNOVER.  $sumRow['money'] . "€";
            $totalM = $totalMoneyRow['totalmoney'];
            $posostoTotal = round(($sumRow['money'] * 100) / $totalM, 2);
            echo '<br>'.PERCENTAGE_OF_TURNOVER_OVER_TOTAL . $posostoTotal . "%";
            echo '<br>'.TOTAL_TURNOVER_OF_ALL_CUSTOMERS. $totalM;
            echo '<br>'.PERCENTAGE_OF_CUSTOMERS_OVER_TOTAL. round($posostoClients, 2) . "%";
            echo "</p>";
        }

        if($campaigntype == "6") {
            $qry = "SELECT
                      `signup_date`  AS `signup_date`,
                      COUNT(*)       AS `counter`
                    FROM `customers`
                    WHERE `signup_date` < CURRENT_DATE() AND UNIX_TIMESTAMP(`signup_date`) >= " . $monthsAgoTimestamp;

            if ($_SESSION['SESS_ADMIN'] != "y") {
                $qry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
            }
            else {
              if($_POST['store_id']!="all") $qry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }

            $qry .= " GROUP BY MONTH(`signup_date`), YEAR(`signup_date`)
                    ORDER BY `signup_date` DESC";
            $sumResult = mysql_query($qry) or die(mysql_error());
            $data = array('labels' => array(), "datasets" => array(array("label" => "Νέα μέλη", "data" => array())));
            while($sumRow = mysql_fetch_array($sumResult)) {
                $date = explode("-", $sumRow['signup_date']);
                $data['labels'][] = $date[1]."/".$date[0];
                $data['datasets'][0]['data'][] = (int) $sumRow['counter'];
            }

            echo '<canvas id="chart" width="500" height="300"></canvas>';
            echo '<script type="text/javascript" language="javascript">';
            echo '
                    window.onload = function() {
                        window.myBar = new Chart(document.getElementById("chart").getContext("2d"), {
                            type: "bar",
                            data: '.json_encode($data).',
                            options: {
                                responsive: false,
                                legend: {
                                    display: false
                                },
                                elements: {
                                    rectangle: {
                                        backgroundColor: "#cbe0e4"
                                    }
                                },
                                scales: {
                                    yAxes: [{
                                        ticks: {
                                            beginAtZero:true
                                        }
                                    }]
                                }
                            }
                        });
                    };</script>';
        }

        if($campaigntype == "7") {
            $sumQry = "SELECT COUNT(*) AS `counter` FROM `customers` WHERE `customers`.`age` IS NOT NULL AND `customers`.`age` != '0000-00-00'";
            if ($_SESSION['SESS_ADMIN'] != "y") {
                $sumQry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
            }
            else {
              if($_POST['store_id']!="all") $sumQry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }

            $sumResult = mysql_query($sumQry) or die(mysql_error());
            $summary = mysql_fetch_array($sumResult);

            $qry = "
                SELECT
                  COUNT(ages) AS counter,
                  ages
                FROM (
                       SELECT CASE
                              WHEN `age` >= 65
                                THEN '65+'
                              WHEN `age` >= 55
                                THEN '55-65'
                              WHEN `age` >= 41
                                THEN '41-54'
                              WHEN `age` >= 31
                                THEN '31-40'
                              WHEN `age` >= 25
                                THEN '25-30'
                              WHEN `age` >= 19
                                THEN '19-24'
                              WHEN `age` >= 12
                                THEN '12-18'
                              ELSE '0'
                              END AS ages
                       FROM (
                              SELECT DATE_FORMAT(NOW(), '%Y') - DATE_FORMAT(customers.age, '%Y') -
                                     (DATE_FORMAT(NOW(), '00-%m-%d') < DATE_FORMAT(customers.age, '00-%m-%d')) AS `age`
                              FROM `customers`
                              WHERE `customers`.`age` IS NOT NULL AND `customers`.`age` != '0000-00-00'";

            if ($_SESSION['SESS_ADMIN'] != "y") {
                $qry .= " AND customers.signup_store  = " . $_SESSION['SESS_STORE_AUTO_ID'];
            }
            else {
              if($_POST['store_id']!="all") $qry .= " AND customers.signup_store = ". $_POST['store_id'];
               
         }
            

            $qry .= "
                              HAVING age > 0
                              ORDER BY age DESC
                            ) AS periods
                     ) AS summary
                GROUP BY ages
            ";
            $sumResult = mysql_query($qry) or die(mysql_error());
            $data = array("datasets" => array(array("labels" => array(), "data" => array(), "backgroundColor" => array())));
            $colors = array("#BEABCB", "#BFECCA", "#ECCEBF", "#C2BFEC", "#ECBFE3", "#cbe0e4", "#BBBBBB");
            $colorCounter = 0;
            while($sumRow = mysql_fetch_array($sumResult)) {
                $data['labels'][] = $sumRow['ages']." (".round($sumRow['counter']*100/$summary['counter'], 1)."%)";
                $data['datasets'][0]['data'][] = (int) $sumRow['counter'];
                $data['datasets'][0]['backgroundColor'][] = $colors[$colorCounter++];
            }

            echo '<canvas id="chart" width="500" height="300"></canvas>';
            echo '<script type="text/javascript" language="javascript">';
            echo '
                    window.onload = function() {
                        window.myBar = new Chart(document.getElementById("chart").getContext("2d"), {
                            type: "pie",
                            data: '.json_encode($data).',
                            options: {
                                responsive: false,
                                legend: {
                                    position: "bottom"
                                }
                            }
                        });
                    };
                    </script>';
        }

        if(ALLOW_MASSIVE_SMS_NUMBERS_EXPORT) {
            echo '<button type="submit" class="styled" onclick="document.getElementById(\'export-numbers\').submit();"><img src="images/save.png" class="icon" /> ' . EXPORT_NUMBERS . '</button>';
        }

        echo '<table class="main" cellspacing="0">
    <tr style="font-weight:bold;text-align:center;">
        <td>id</td>
        <td class="leftborder">' . NUMBER . '</td>
        <td class="leftborder">' . SURNAME . '</td>
        <td class="leftborder">' . NAME . '</td>
        <td class="leftborder">' . PHONE . '</td>';
        if($campaigntype == "0") {
            echo '<td class="leftborder">' . LOYALTY_PERCENTAGE . '<br />' . LOYALTY . '</td>';
echo '<td class="leftborder">' . TRANSACTIONS_TIME_A . '<br />' . TIME_A . '</td>';
echo '<td class="leftborder">' . TRANSACTIONS_TIME_B . '<br />' . TIME_B . '</td>';
echo '<td class="leftborder">' . FOR_100_PERCENT . '<br />' . IN_TIME_B . '</td>';

        }
        if($campaigntype == "1") {
            echo '<td class="leftborder">' . TRANSACTIONS_BEFORE . '<br />' . $dateToDisplay . '</td>';
echo '<td class="leftborder">' . TRANSACTIONS_AFTER . '<br />' . $dateToDisplay . '</td>';

        }
        elseif($campaigntype == "2") {
           echo '<td class="leftborder">' . VISITS . '</td>';
        }
        elseif($campaigntype == "3") {
            echo '<td class="leftborder">' . POINTS . '</td>';
        }
        elseif($campaigntype == "4" || $campaigntype == "5") {
            echo '<td class="leftborder">' . REVENUE . '</td>';
			echo '<td class="leftborder">' . PERCENTAGE . '</td>';
        }
        elseif($campaigntype == "6") {
            echo '<td class="leftborder">' . REVENUE . '</td>';
            echo '<td class="leftborder">' . REGISTRATION_MONTH . '</td>';
        }
        elseif($campaigntype == "7") {
            echo '<td class="leftborder">' . REVENUE . '</td>';
           echo '<td class="leftborder">' . AGE . '</td>';
        }
        elseif($campaigntype == "9") {
           echo '<td class="leftborder">' . REVENUE . '</td>';
         
        }
        echo '	</tr>';

        $counter = 0;
        while($row = mysql_fetch_array($result)) {
            $phoneNumbers[] = $row['phone'];

            $results++;
            if ($counter == 0){
                    $column = "even";
                    $counter++;
            }else{
                    $column = "odd";

                    $counter = 0;
            }
            echo '
                <tr class="';
            echo $column;
            echo '">';
            echo '  <td style="text-align:center;">'.$results.'</td>
                    <td class="leftborder" style="text-align:center;">'.$row['customer_id'].'</td>
                    <td class="leftborder">'.$row['surname'].'</td>
                    <td class="leftborder">'.$row['name'].'</td>
                    <td class="leftborder">'.$row['phone'].'</td>';
            if($campaigntype == "0") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['loyalty'].'%</td>';
                echo '<td class="leftborder" style="text-align:center;">'.$row['timeA'].'</td>';
                echo '<td class="leftborder" style="text-align:center;">'.$row['timeB'].'</td>';
                echo '<td class="leftborder" style="text-align:center;">'.($_SESSION['SESS_LOYALTY_TIME_B'] * $row['timeA'] / $_SESSION['SESS_LOYALTY_TIME_A']).'</td>';
            }
            elseif($campaigntype == "1") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['beforecounter'].'</td>
                    <td class="leftborder" style="text-align:center;">'.$row['aftercounter'].'</td>';
            }
            elseif($campaigntype == "2") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['visits'].'</td>';
            }
            elseif($campaigntype == "3") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['totalpoints'].'</td>';
            }
            elseif($campaigntype == "4" || $campaigntype == "5") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['money'].'</td>';
				$pososto=($row['money']*100)/$sumRow['money'];
				echo '<td class="leftborder" style="text-align:center;">'.round($pososto,2).'</td>';
            }
            elseif($campaigntype == "6") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['money'].'</td>';
                echo '<td class="leftborder" style="text-align:center;">'.date("F", $row['signup_timestamp']).'</td>';
            }
            elseif($campaigntype == "7") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['money'].'</td>';
                echo '<td class="leftborder" style="text-align:center;">'.$row['age'].'</td>';
            }
             elseif($campaigntype == "9") {
              echo '<td class="leftborder" style="text-align:center;">'.$row['money'].'</td>';
         
            }
            echo '</tr>';
        }
        echo '</table>';
    }
    else {
        
    }

	echo '<form method="post" name="sms-campaign" id="sms-campaign" action="new-sms-campaign-exec.php">';
	echo '<input type="hidden" name="msg" id="msg" value="'.$smsMsg.'" />';
	echo '<input type="hidden" name="campaigntype" id="campaigntype" value="'.$campaigntype.'" />';
	echo '<input type="hidden" name="days'.$campaigntype.'" id="days" value="'.$days.'" />';
	echo '<input type="hidden" name="visits'.$campaigntype.'" id="visits" value="'.$visits.'" />';
    if($campaigntype == "1") {
        echo '<input type="hidden" name="visits1_2" id="visits1_2" value="' . $visits2 . '" />';
    }
    if($campaigntype == "2") {
        if(isset($_POST['from_days_2'])) $from_days_2=secureInput($_POST['from_days_2']);
        if(isset($_POST['till_days_2'])) $till_days_2=secureInput($_POST['till_days_2']);
        echo '<input type="hidden" name="visits2_2" id="visits2_2" value="' . $visits2 . '" />';
        echo '<input type="hidden" name="from_days_2" id="from_days_2" value="' . $from_days_2 . '" />';
        echo '<input type="hidden" name="till_days_2" id="till_days_2" value="' . $till_days_2 . '" />';
    }
    if($campaigntype == "4") {
        echo '<input type="hidden" name="service4" id="service4" value="' . $_POST['service4'] . '" />';
    }
    if($campaigntype == "5") {
        if(isset($_POST['from_days_5'])) $from_days_2=secureInput($_POST['from_days_5']);
        if(isset($_POST['till_days_5'])) $till_days_2=secureInput($_POST['till_days_5']);
         if(isset($_POST['service5'])) $service5=secureInput($_POST['service5']);
        echo '<input type="hidden" name="visits5_2" id="visits5_2" value="' . $visits2 . '" />';
        echo '<input type="hidden" name="from_days_5" id="from_days_5" value="' . $from_days_5 . '" />';
        echo '<input type="hidden" name="till_days_5" id="till_days_5" value="' . $till_days_5 . '" />';
        echo '<input type="hidden" name="service5" id="service5" value="' . $service5 . '" />';
    }
    if($campaigntype == "8") {
        echo '<input type="hidden" name="service8" id="service8" value="' . $service . '" />';
    }
     if($campaigntype == "9") {
        echo '<input type="hidden" name="service8" id="service8" value="' . $service . '" />';
        echo '<input type="hidden" name="members9" id="members9" value="' . $members9 . '" />';
    }

    $smsCredits = returnSMS();
    if($smsCredits < $rows) {
        $smsFlag = true;
        echo '<p class="main">' . INSUFFICIENT_SMS_BALANCE_FOR_ALL_RECIPIENTS . '</p>';
    }

	if ($smsFlag == false && ($_SESSION['SESS_ADMIN'] == "y" || $_SESSION['SESS_SMS_ENABLE_USER'] == "y")){
		echo '<button type="submit" class="styled" onclick="showMsg()"><img src="images/apply.png" class="icon" /> Aποστολή Μηνύματος</button>';
	}
	else {
        if($_SESSION['SESS_ADMIN'] != "y" && $_SESSION['SESS_SMS_ENABLE_USER'] != "y") {
           echo '<button type="submit" class="styled" onclick="showMsg()"><img src="images/apply.png" class="icon" /> '.SEND_MESSAGE.'</button>';
        }
	}
	echo '</form>';

    /* export numbers to csv */
    if(ALLOW_MASSIVE_SMS_NUMBERS_EXPORT){
        $phoneNumbers = array_unique($phoneNumbers);
        echo '<form action="export-csv-exec.php" id="export-numbers" method="post">';
        echo '<input type="hidden" name="datacomma" value="' . implode(",", $phoneNumbers) . '" />';
        echo '<input type="hidden" name="filename" value="phone_numbers_marketing" />';
        echo '<p class="main">'.SMS_DISABLED_FROM_SETTINGS .'</p>';
        echo '</form>';
    }

    if($smsFlag == false) {
        echo '
        <script type="text/javascript" language="javascript">
            document.getElementById(\'num\').innerHTML = ' . $results . ';
        </script>';
    }
?>
        <div class="printButton" id="printButton">
                <button type="button" class="styled" onclick="printDiv('<?php echo $_SESSION['SESS_STORE_ID'].'<br />'.
                    $_SESSION['SESS_STORE_STREET'].', '.$_SESSION['SESS_STORE_CITY'].
                    '<br />Tel : '.$_SESSION['SESS_STORE_PHONE'];?>');">
                    <img src="images/print.png" class="icon" /> Print</button>
            </div>
            <div style="clear:both;"></div>
        </div>
</div>

<iframe id="printwindow" frameborder="0"></iframe>

</body>
</html>
