<?php
    header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

    require_once('config.php');
    require_once('auth.php');
    require('header.php');
    require_once('sendSMS.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo CUSTOMER_ENTRY_TITLE; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="styles.css" rel="stylesheet" type="text/css" />

    <script src="form_validator.js"></script>
    <script src="calendar.js"></script>
    <link rel="stylesheet" href="calendar.css">
    <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

    <script type="text/javascript">
        function setCellValue() {
            document.forms["new-customer"]["rel_customer_id"].value = document.getElementById('list').value;
        }

        function setSelectValue() {
            document.getElementById('list').value = document.forms["new-customer"]["rel_customer_id"].value;
        }

        function checkPhoneSms() {
            var phone = document.getElementById('phone').value;
            if (phone.length != 0 && phone.length != 10) {
                alert('The phone number is not valid');
                return false;
            }

            if (document.getElementById('sms_checkbox').checked) {
                if (phone.substr(0, 2) != "69" || phone.length != 10) {
                    alert('You chose for the customer to receive SMS but did not provide a valid phone number');
                    return false;
                }
            }

            checkPhone(true);
            return false;
        }

        function checkPhone(confirmDialog) {
            var phone = document.getElementById('phone').value;

            if (phone.length != 10) {
                alert("Please fill in the phone number correctly");
            } else {
                var xmlhttp;
                xmlhttp = new XMLHttpRequest();
                xmlhttp.open("GET", "bridge-getinfo.php?customer_id=" + phone, true);
                xmlhttp.onreadystatechange = function() {
                    if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
                        var jsonObject = JSON.parse(xmlhttp.responseText);

                        if (jsonObject.status == 200) {
                            var message = 'Customer found with this mobile number:\n\n' + jsonObject.message.name + " " +
                                jsonObject.message.surname + " (" + jsonObject.message.customer_id + ")" + "\nPoints: " +
                                jsonObject.message.points + "\nVisits: " + jsonObject.message.total_visits;

                            if (confirmDialog) {
                                if (confirm(message)) {
                                    document.getElementById('new-customer').submit();
                                }
                            } else {
                                alert(message);
                            }
                        } else {
                            if (confirmDialog) {
                                document.getElementById('new-customer').submit();
                            }
                        }
                    }
                };
                xmlhttp.send(null);
            }
        }

        function chooseCard() {
            var form = document.getElementById("new-customer");
            form.action = "#";
            form.submit();
        }

        function setAge() {
            document.getElementById("age").value = document.getElementById("age_year").value + '/' +
                document.getElementById("age_month").value + '/' + document.getElementById("age_day").value;
        }
    </script>
</head>

<body>
<?php headerDiv();?>


<?php 

	$link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
	if(!$link) {
		die('Failed to connect to the server: ' . mysql_error());
	}
	$db = mysql_select_db(DB_DATABASE);
	if(!$db) {
		die("Unable to select database");
	}
	mysql_query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'", $link)
		or die(mysql_error());
		
		if(isset($_POST['plastiki']) && $_POST['plastiki'] == '1') {
		    $plastiki = false;
		} else {
		    $plastiki = true;
		}
		
		
		if($plastiki) $operator=">=";
		else $operator="<";
		
	
	$plastic_card_start="10000";
	
		$result = mysql_query("SELECT max(customer_id) as maxcid FROM `customers` WHERE customer_id $operator $plastic_card_start  ORDER BY  `id`")
		or die(mysql_error());
		
	$last2 = mysql_fetch_array($result);
	
//	print_r($last2);
	
	if($last2[0] == '') {
	    //echo "Plastiki : $plastiki Operator : $operator</br>";
	    if($plastiki) {
	        $last2 = [ "maxcid" => $plastic_card_start];
	    } else {
	        $last2 = [ "maxcid" => 0];
	    }
	}
						
?>

<div class="container mt-5 main">
    <h1 class="text-center"><?php echo NEW_CUSTOMER_ENTRY; ?></h1>
    <div id="new-customer_errorloc"></div>

    <form enctype="multipart/form-data" action="new-customer-exec.php" method="post" name="new-customer" id="new-customer" class="needs-validation" novalidate>
        <div class="mb-3">
            <label class="form-label">Last customer entry with number: <?php echo $last['customer_id']; ?> / MaxId: <?php echo $last2['maxcid']; ?></label>
        </div>

        <div class="row mb-3">
            <label for="customer_id" class="col-sm-3 col-form-label">Customer Number</label>
            <div class="col-sm-9">
                <input type="text" name="customer_id" id="customer_id" class="form-control" value="<?php echo ($last2['maxcid'] + 1); ?>" required />
            </div>
        </div>

        <div class="row mb-3">
            <label for="plastiki" class="col-sm-3 col-form-label">Card Type</label>
            <div class="col-sm-9">
                <select name="plastiki" id="plastiki" class="form-select" onChange="chooseCard()">
                    <option value="0" <?php if ($_POST["plastiki"] == "0" || (empty($_POST["plastiki"]))) echo "selected='selected'"; ?>>Digital</option>
                    <option value="1" <?php if ($_POST["plastiki"] == "1") echo "selected='selected'"; ?>>Plastic</option>
                </select>
            </div>
        </div>

        <div class="row mb-3">
            <label for="status" class="col-sm-3 col-form-label">Status <span class="text-muted">(Platinum member earns double points)</span></label>
            <div class="col-sm-9">
                <select name="members_num" class="form-select" required>
                    <option value="1" selected="selected">Standard</option>
                    <option value="0.5">Platinum</option>
                </select>
            </div>
        </div>

        <div class="row mb-3">
            <label for="name" class="col-sm-3 col-form-label">Name</label>
            <div class="col-sm-9">
                <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
            </div>
        </div>

        <div class="row mb-3">
            <label for="surname" class="col-sm-3 col-form-label">Surname</label>
            <div class="col-sm-9">
                <input type="text" name="surname" class="form-control" placeholder="Enter Surname" required>
            </div>
        </div>

        <div class="row mb-3">
            <label for="dob" class="col-sm-3 col-form-label">Date of Birth</label>
            <div class="col-sm-9">
                <div class="row">
                    <div class="col-md-4">
                        <select id="age_day" class="form-select" onchange="setAge()" required>
                            <option value="">Day</option>
                            <?php for ($i = 1; $i <= 31; $i++) echo '<option value="' . str_pad($i, 2, '0', STR_PAD_LEFT) . '">' . $i . '</option>'; ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <select id="age_month" class="form-select" onchange="setAge()" required>
                            <option value="">Month</option>
                            <?php for ($i = 1; $i <= 12; $i++) echo '<option value="' . str_pad($i, 2, '0', STR_PAD_LEFT) . '">' . $i . '</option>'; ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <select id="age_year" class="form-select" onchange="setAge()" required>
                            <option value="">Year</option>
                            <?php for ($i = 2009; $i >= 1950; $i--) echo '<option value="' . $i . '">' . $i . '</option>'; ?>
                        </select>
                    </div>
                </div>
                <input type="hidden" name="age" value="" id="age" />
            </div>
        </div>

        <div class="row mb-3">
            <label for="street" class="col-sm-3 col-form-label">Address</label>
            <div class="col-sm-9">
                <input type="text" name="street" class="form-control" placeholder="Enter Address">
            </div>
        </div>

        <div class="row mb-3">
            <label for="city" class="col-sm-3 col-form-label">City</label>
            <div class="col-sm-9">
                <input type="text" name="city" class="form-control" placeholder="Enter City" required>
            </div>
        </div>

        <div class="row mb-3">
            <label for="country" class="col-sm-3 col-form-label">Country</label>
            <div class="col-sm-9">
                <input type="text" name="country" class="form-control" value="Ελλάδα" required>
            </div>
        </div>

        <div class="row mb-3">
            <label for="zip" class="col-sm-3 col-form-label">Postal Code</label>
            <div class="col-sm-9">
                <input type="text" name="zip" class="form-control" placeholder="Enter Postal Code">
            </div>
        </div>

        <div class="row mb-3">
            <label for="phone" class="col-sm-3 col-form-label">Mobile Phone</label>
            <div class="col-sm-9">
                <input type="text" id="phone" name="phone" class="form-control" placeholder="Enter Mobile Phone" required>
                <a href="#" onclick="checkPhone(false);" class="text-decoration-underline">Check</a>
            </div>
        </div>

        <div class="form-check mb-3">
            <input type="checkbox" value="1" checked="checked" name="sms" id="sms_checkbox" class="form-check-input">
            <label for="sms_checkbox" class="form-check-label">Receive SMS notifications</label>
        </div>

        <div class="row mb-3">
            <label for="email" class="col-sm-3 col-form-label">Email</label>
            <div class="col-sm-9">
                <input type="email" name="email" class="form-control" placeholder="Enter Email">
            </div>
        </div>

        <div class="row mb-3">
            <label for="facebook" class="col-sm-3 col-form-label">Facebook</label>
            <div class="col-sm-9">
                <input type="text" name="facebook" class="form-control" placeholder="Enter Facebook">
            </div>
        </div>

        <div class="row mb-3">
            <label for="notes" class="col-sm-3 col-form-label">Comments</label>
            <div class="col-sm-9">
                <input type="text" name="notes" class="form-control" placeholder="Enter Comments">
            </div>
        </div>

        <div class="container">
    <!-- Sign Up Date -->
    <div class="row mb-3">
        <label for="signup_date" class="col-sm-3 col-form-label">Sign Up Date</label>
        <div class="col-sm-9">
            <input type="text" name="signup_date" id="signup_date" class="form-control" value="<?= date("Y-m-d") ?>" />
        </div>
    </div>

    <!-- Custom Fields -->
    <?php
    for ($i = 1; $i <= CUSTOM_FIELDS_NUM; $i++) {
        if (isset($_SESSION['SESS_CUSTOM_FIELD' . $i]) && $_SESSION['SESS_CUSTOM_FIELD' . $i] != "") {
            echo '<div class="row mb-3">';
            echo '<label class="col-sm-3 col-form-label">' . $_SESSION['SESS_CUSTOM_FIELD' . $i] . ':</label>';
            echo '<div class="col-sm-9">';
            if (isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "1") {
                echo '<select name="custom' . $i . '" class="form-control">
                        <option value="n">Όχι</option>
                        <option value="y">Ναι</option>
                      </select>';
            } elseif (isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "2") {
                echo '<input type="text" name="custom' . $i . '" class="form-control" />';
            } elseif (isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "3") {
                echo '<select name="custom' . $i . '" class="form-control">';
                foreach (explode(",", $_SESSION['SESS_CUSTOM_FIELD_LIST' . $i]) as $value) {
                    echo '<option value="' . trim($value) . '">' . $value . '</option>';
                }
                echo '</select>';
            }
            echo '</div>';
            echo '</div>';
        }
    }
    ?>

    <!-- Photo Upload -->
    <div class="row mb-3">
        <label class="col-sm-3 col-form-label">Photo:</label>
        <div class="col-sm-9">
            <input type="file" name="file" class="form-control-file" />
        </div>
    </div>

    <!-- Multishop (Admin Only) -->
    <?php if ($_SESSION['SESS_ADMIN'] == "y" && MULTISHOP): ?>
        <div class="row mb-3">
            <label for="store" class="col-sm-3 col-form-label">Store:</label>
            <div class="col-sm-9">
                <select name="store" id="store" class="form-control">
                    <?php
                    $result = mysql_query("SELECT store_id, id FROM stores ORDER BY store_id") 
                        or die(mysql_error());
                    while ($row = mysql_fetch_array($result)) {
                        echo '<option value="' . $row['id'] . '"';
                        if ($_SESSION['SESS_STORE_AUTO_ID'] == $row['id']) echo ' selected';
                        echo '>' . $row['store_id'] . '</option>';
                    }
                    ?>
                </select>
            </div>
        </div>
    <?php endif; ?>
</div>

        <div class="text-center">
            <button type="submit" class="btn btn-primary" onclick="return checkPhoneSms();">Create Customer</button>
        </div>
    </form>
</div>
<pre>
    
    
    
</pre>
<script type="text/javascript" language="javascript">
    document.getElementById("customer_id").focus();
    <?php
        if($_SESSION['SESS_SMS_ENABLE_NEW_CUSTOMER'] == 'y'){
            $smsCredits = returnSMS();
            if($smsCredits < 1) {
                echo "alert('Ο πελάτης ΔΕ θα λάβει SMS λόγω μηδενικού υπολοίπου!')";
            }
        }
    ?>
</script>
<script language="JavaScript" type="text/javascript"
    xml:space="preserve">//<![CDATA[
  var frmvalidator  = new Validator("new-customer");
  frmvalidator.EnableOnPageErrorDisplaySingleBox();
  frmvalidator.EnableMsgsTogether();
 
  frmvalidator.addValidation("customer_id","req","Δεν έχετε εισάγει τον αριθμό πελάτη");
  frmvalidator.addValidation("customer_id","maxlen=20",	"Ο μέγιστος αριθμός ψηφίων για τον αριθμό πελάτη είναι 20");
  frmvalidator.addValidation("customer_id","alnum","Ο αριθμός πελάτη μπορεί να περιέχει μόνο ψηφία και γράμματα");
  
  frmvalidator.addValidation("name","req","Δεν έχετε εισάγει όνομα πελάτη");
  frmvalidator.addValidation("name","maxlen=254","Το όνομα του πελάτη μπορεί να είναι μέχρι 254 χαρακτήρες");
  frmvalidator.addValidation("name","alpha_s","Το όνομα του πελάτη μπορεί να περιέχει μόνο γράμματα και κενό");
  
  frmvalidator.addValidation("surname","req","Δεν έχετε εισάγει επώνυμο πελάτη");
  frmvalidator.addValidation("surname","maxlen=254","Το επώνυμο του πελάτη μπορεί να είναι μέχρι 254 χαρακτήρες");
  frmvalidator.addValidation("surname","alpha_s","Το επώνυμο του πελάτη μπορεί να περιέχει μόνο γράμματα και κενό");
  
  frmvalidator.addValidation("street","maxlen=254","Η διεύθυνση πελάτη μπορεί να είναι μέχρι 254 χαρακτήρες");
 
  frmvalidator.addValidation("city","req","Δεν έχετε εισάγει την πόλη του πελάτη");
  frmvalidator.addValidation("city","maxlen=254","Η πόλη του πελάτη μπορεί να είναι μέχρι 254 χαρακτήρες");
  frmvalidator.addValidation("city","alpha_s","Η πόλη του πελάτη μπορεί να περιέχει μόνο γράμματα και κενό");
  
  frmvalidator.addValidation("country","req","Δεν έχετε εισάγει την χώρα του πελάτη");
  frmvalidator.addValidation("country","maxlen=254","Η χώρα του πελάτη μπορεί να είναι μέχρι 254 χαρακτήρες");
  frmvalidator.addValidation("country","alpha_s","Η χώρα του πελάτη μπορεί να περιέχει μόνο γράμματα και κενό");  
  
  frmvalidator.addValidation("zip","maxlen=6", "Ο μέγιστος αριθμός ψηφίων για τον Τ.Κ. του πελάτη είναι 6");
  frmvalidator.addValidation("zip","numeric", "Ο Τ.Κ. του πελάτη μπορεί να περιέχει μόνο ψηφία");
  
  frmvalidator.addValidation("phone","numeric", "Ο αριθμός τηλεφώνου του πελάτη μπορεί να περιέχει μόνο ψηφία");

  frmvalidator.addValidation("alt_phone","numeric", "Ο αριθμός τηλεφώνου του πελάτη μπορεί να περιέχει μόνο ψηφία");
    
  frmvalidator.addValidation("email","maxlen=254", "Το email του πελάτη μπορεί να είναι μέχρι 254 χαρακτήρες");
  frmvalidator.addValidation("email","email", "Η διεύθυνση email που εισάγατε δεν έχει έγκυρη μορφή");
  
  frmvalidator.addValidation("notes","maxlen=254","Τα σχόλια του πελάτη μπορεί να είναι μέχρι 254 χαρακτήρες");  
//]]></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.getElementById("customer_id").focus();
</script>
</body>
</html>
