<?php
function floatingDesktopMenu(){
    $time = time();

    $quickVisitButtonStyle = "font-size:9px;";
    $quickTransButtonStyle = "font-size:9px;";
    $fullTransButtonStyle = "";
    if(MENU_TYPE == "quick") {
        $quickVisitButtonStyle = "display:none";
        $quickTransButtonStyle = "font-size: 15px; height: 63px; padding-top: 35px;";
        $fullTransButtonStyle = "display:none";
    }
    elseif(MENU_TYPE == "new") {
        $quickVisitButtonStyle = "display:none";
        $quickTransButtonStyle = "display:none";
        $fullTransButtonStyle = "font-size: 15px; height: 63px; padding-top: 35px;";
    }
    elseif(MENU_TYPE == "visit") {
        $quickVisitButtonStyle = "font-size: 15px; height: 63px; padding-top: 35px;";
        $quickTransButtonStyle = "display:none";
        $fullTransButtonStyle = "display:none";
    }

    $menuEntries = array();
    if(TRANSACTIONS_MENU_BUTTONS) {
        $menuEntries[] = array("url" => "new-big-visit-transaction-form.php", "title" => "Γρήγορη επίσκεψη", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/new-transaction.png", "adminOnly" => false, "style" => $quickVisitButtonStyle);
        $menuEntries[] = array("url" => "new-big-transaction-form.php", "title" => "Γρήγορη συναλλαγή", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/new-transaction.png", "adminOnly" => false, "style" => $quickTransButtonStyle);
        $menuEntries[] = array("url" => "new-transaction-form.php", "title" => "Νέα συναλλαγή", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/new-transaction.png", "adminOnly" => false, "style" => $fullTransButtonStyle);
    }

    $menuEntries[] = array("url" => "new-customer-form.php", "title" => "Νέος πελάτης", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/new-customer.png", "adminOnly" => false, "style" => "");
    $menuEntries[] = array("url" => "view-customers.php", "title" => "Πελάτες", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/users.png", "adminOnly" => false, "style" => "");
    $menuEntries[] = array("url" => "view-checkouts.php", "title" => "Εξαργυρώσεις", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/checkout.png", "adminOnly" => false, "style" => "");
    $menuEntries[] = array("url" => "new-sms-form.php", "title" => "Αποστολή SMS", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/sms.png", "adminOnly" => false, "style" => "");
    $menuEntries[] = array("url" => "new-sms-campaign-form.php", "title" => "Marketing", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/sms.png", "adminOnly" => true, "style" => "");
    $menuEntries[] = array("url" => "view-prizes.php", "title" => "Προσφορές", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/prizes.png", "adminOnly" => false, "style" => "");
    $menuEntries[] = array("url" => "reports.php", "title" => "Αναφορές", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/reports.png", "adminOnly" => false, "style" => "");
    $menuEntries[] = array("url" => "admin-settings.php", "title" => "Ρυθμίσεις", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/settings.png", "adminOnly" => true, "style" => "");
    $menuEntries[] = array("url" => "logout.php", "title" => "Αποσύνδεση", "icon" => "https://s3.eu-central-1.amazonaws.com/net2020loyalty/images/logout.png", "adminOnly" => false, "style" => "");

    foreach ($menuEntries as $menu) {
        if($menu['adminOnly'] && $_SESSION['SESS_ADMIN'] != "y"){
            continue;
        }
        echo '<div class="menuentry">
                <a href="' . $menu['url'] . '?no-cache='.$time.'" style="' . $menu['style'] . '">
                        <img src="' . $menu['icon'] . '" class="icon"/> ' . $menu['title'] . '
                </a>
              </div>';
    }
}
?>
