SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

-- --------------------------------------------------------

--
-- Table structure for table `checkouts`
--

CREATE TABLE `checkouts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `transaction_auto_id` int(10) NOT NULL,
  `customer_auto_id` int(10) NOT NULL,
  `prize_auto_id` int(10) NOT NULL,
  `created_by_store_auto_id` int(10) NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `received_date` datetime DEFAULT NULL,
  `received` enum('y','n') NOT NULL DEFAULT 'n',
  `received_by_store_auto_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_auto_id` (`transaction_auto_id`),
  KEY `customer_auto_id` (`customer_auto_id`),
  KEY `prize_auto_id` (`prize_auto_id`),
  KEY `created_by_store_auto_id` (`created_by_store_auto_id`),
  KEY `received_by_store_auto_id` (`received_by_store_auto_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_id` varchar(20) NOT NULL,
  `name` varchar(255) CHARACTER SET greek NOT NULL DEFAULT '',
  `surname` varchar(255) CHARACTER SET greek NOT NULL DEFAULT '',
  `age` date DEFAULT NULL,
  `street` varchar(255) CHARACTER SET greek NOT NULL DEFAULT '',
  `city` varchar(255) CHARACTER SET greek NOT NULL DEFAULT 'Λάρισα',
  `country` varchar(255) CHARACTER SET greek NOT NULL DEFAULT 'Ελλάδα',
  `zip` varchar(20) NOT NULL DEFAULT '',
  `phone` varchar(20) DEFAULT NULL,
  `alt_phone` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `facebook` varchar(150) DEFAULT NULL,
  `notes` text CHARACTER SET greek,
  `sms` tinyint(1) NOT NULL DEFAULT '1',
  `rel_customer_id` varchar(10) DEFAULT NULL,
  `signup_date` date NOT NULL DEFAULT '0000-00-00',
  `signup_store` int(4) NOT NULL,
  `added_by` int(10) NOT NULL,
  `custom1` enum('y','n') NOT NULL DEFAULT 'n',
  `custom2` enum('y','n') NOT NULL DEFAULT 'n',
  `custom3` enum('y','n') NOT NULL DEFAULT 'n',
  `custom4` enum('y','n') NOT NULL DEFAULT 'n',
  `custom5` enum('y','n') NOT NULL DEFAULT 'n',
  `custom6` enum('y','n') NOT NULL DEFAULT 'n',
  `custom7` enum('y','n') NOT NULL DEFAULT 'n',
  `custom8` enum('y','n') NOT NULL DEFAULT 'n',
  `custom9` enum('y','n') NOT NULL DEFAULT 'n',
  `custom10` enum('y','n') NOT NULL DEFAULT 'n',
  PRIMARY KEY (`id`),
  UNIQUE KEY `customer_id` (`customer_id`),
  KEY `rel_customer_id` (`rel_customer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `customer_id`, `name`, `surname`, `age`, `street`, `city`, `country`, `zip`, `phone`, `alt_phone`, `email`, `facebook`, `notes`, `sms`, `rel_customer_id`, `signup_date`, `signup_store`, `added_by`, `custom1`, `custom2`, `custom3`, `custom4`, `custom5`, `custom6`, `custom7`, `custom8`, `custom9`, `custom10`) VALUES
(1, '0000', ' Λιανικής', ' Πελάτης', NULL, '', '', 'Ελλάδα', '', '', '', '', '', '', 0, NULL, '2014-01-01', 1, 1, 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `giftcards`
--

CREATE TABLE `giftcards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL COMMENT 'giftcard barcode',
  `amount` int(10) NOT NULL COMMENT 'giftcard money amount',
  `customer_id` int(10) NOT NULL COMMENT 'the customer auto assigned id, the card owner',
  `store_id` int(10) NOT NULL COMMENT 'the store-auto-assigned-id, where the card created',
  `added_by` int(10) NOT NULL COMMENT 'the loyalty user that added the giftcard to the system',
  `creation_date` datetime NOT NULL COMMENT 'the date the giftcard created',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `prizes`
--

CREATE TABLE `prizes` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `prize_points` int(10) unsigned NOT NULL DEFAULT '0',
  `prize_msg` varchar(254) CHARACTER SET greek DEFAULT NULL,
  `from_date` date NOT NULL DEFAULT '0000-00-00',
  `till_date` date NOT NULL DEFAULT '0000-00-00',
  `sms_notify` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `setting` varchar(25) CHARACTER SET greek NOT NULL,
  `value` varchar(600) CHARACTER SET greek NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting` (`setting`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=36 ;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`id`, `setting`, `value`) VALUES
(1, 'visit_points', '1'),
(2, 'money_points', '1'),
(3, 'customfield1', 'Υπάλληλος'),
(4, 'customfield2', 'Ανδρας'),
(5, 'customfield3', 'Γυναίκα'),
(6, 'customfield4', 'Φοιτητής'),
(7, 'customfield5', ''),
(8, 'customfield6', ''),
(9, 'customfield7', ''),
(10, 'customfield8', ''),
(11, 'customfield9', ''),
(12, 'customfield10', ''),
(13, 'customer_cat1', '100'),
(14, 'customer_cat2', '250'),
(15, 'customer_cat3', '250'),
(16, 'sms_msg_new_customer', 'AΓAΠHTE surname name, EYXAPIΣTOYME ΓIA THN EΓΓPAΦH. EXETE TON APIΘMO KAPTAΣ : customerId'),
(17, 'sms_msg_transaction', 'AΓAΠHTE surname name, H NEA ΣOY ΣYNAΛΛAΓH ΣOY EΔΩΣE points ΠONTOYΣ! ΣYNOΛIKA EXEIΣ totalPoints ΠONTOYΣ!'),
(18, 'sms_msg_prize', 'AΓAΠHTE surname name, MAZEΨEΣ prizePoints ΠONTOYΣ KAI ΔIKAIOYΣAI THN ΠPOΣΦOPA prizeMsg'),
(19, 'sms_msg_checkout', 'AΓAΠHTE surname name, EXEIΣ ΠANΩ AΠO prizePoints ΠONTOYΣ! prizeMsg'),
(20, 'sms_msg_birthday', 'TO KATAΣTHMA MAΣ ΣAΣ EYXETAI XPONIA ΠOΛΛA!'),
(21, 'sms_msg_nameday', 'TO KATAΣTHMA MAΣ ΣAΣ EYXETAI XPONIA ΠOΛΛA!'),
(22, 'sms_msg_free_checkout', 'AΓAΠHTE surname name, MOΛIΣ EΞAPΓYPΩΣATE points ΠONTOYΣ, ΔIKAIOYΣTE EΠIΣTPOΦH XPHMATΩN money EYPΩ'),
(23, 'sms_enable_new_customer', 'y'),
(24, 'sms_enable_transaction', 'y'),
(25, 'sms_enable_prize', 'y'),
(26, 'sms_enable_checkout', 'y'),
(27, 'sms_enable_birthday', 'n'),
(28, 'sms_enable_nameday', 'n'),
(29, 'sms_enable_free_checkout', 'y'),
(30, 'sms_enable_user', 'y'),
(33, 'results_per_page', '50'),
(34, 'services', 'Υπηρεσία 1 (x1),Υπηρεσία 2 (x1),Υπηρεσία 3 (x2)'),
(35, 'removecheckoutpoints', '1'),
(36, 'sms_birthday_money', '0'),
(37, 'sms_birthday_days', '365');

-- --------------------------------------------------------

--
-- Table structure for table `sms_history`
--

CREATE TABLE `sms_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group` varchar(50) CHARACTER SET greek DEFAULT NULL,
  `message` text CHARACTER SET greek NOT NULL,
  `recipients` int(6) NOT NULL,
  `senddate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sms_templates`
--

CREATE TABLE `sms_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) CHARACTER SET greek DEFAULT NULL,
  `contents` varchar(1000) CHARACTER SET greek DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `stores`
--

CREATE TABLE `stores` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `store_id` varchar(20) CHARACTER SET greek NOT NULL,
  `afm` varchar(12) NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET greek NOT NULL DEFAULT '',
  `surname` varchar(255) CHARACTER SET greek NOT NULL DEFAULT '',
  `street` varchar(255) CHARACTER SET greek NOT NULL DEFAULT '',
  `city` varchar(255) CHARACTER SET greek NOT NULL DEFAULT 'Λάρισα',
  `country` varchar(255) CHARACTER SET greek NOT NULL DEFAULT 'Ελλάδα',
  `zip` varchar(10) NOT NULL DEFAULT '',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `alt_phone` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `notes` text CHARACTER SET greek,
  `pin` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `store_id` (`store_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `stores`
--

INSERT INTO `stores` (`id`, `store_id`, `afm`, `name`, `surname`, `street`, `city`, `country`, `zip`, `phone`, `alt_phone`, `email`, `notes`) VALUES
(1, 'Κατάστημα 1', '0123456789', 'Όνομα', 'Επίθετο', 'Οδός', 'Λάρισα', 'Ελλάδα', '41221', '6901234567', '2410123456', 'store1@store.com', 'Σχόλια για το πρώτο κατάστημα');

--
-- Table structure for table `transactioncodes`
--

CREATE TABLE `transactioncodes` (
`id` int(10) NOT NULL AUTO_INCREMENT,
  `money` decimal(9,2) NOT NULL DEFAULT '0.00',
  `code` varchar(13) NOT NULL,
  `crdate` datetime NOT NULL,
  `by` int(10) NOT NULL,
  `store_id` int(10) NOT NULL DEFAULT '1',
  `useddate` datetime DEFAULT NULL,
  `used` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `by` (`by`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_auto_id` int(10) NOT NULL,
  `money` decimal(9,2) NOT NULL DEFAULT '0.00',
  `points` float(10,2) NOT NULL DEFAULT '1.00',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `by` int(10) NOT NULL DEFAULT '0',
  `store_id` int(10) NOT NULL DEFAULT '1',
  `notes` text CHARACTER SET greek,
  `services` text CHARACTER SET greek,
  `giftcard_id` int(11) DEFAULT NULL,
  `giftcard_money` decimal(9,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `customer_auto_id` (`customer_auto_id`),
  KEY `store_id` (`store_id`),
  KEY `giftcard_id` (`giftcard_id`),
  KEY `by` (`by`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL DEFAULT '',
  `password` varchar(60) NOT NULL DEFAULT '',
  `real_name` varchar(50) CHARACTER SET greek NOT NULL DEFAULT '',
  `real_surname` varchar(50) CHARACTER SET greek NOT NULL DEFAULT '',
  `admin` enum('y','n') NOT NULL DEFAULT 'n',
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(20) NOT NULL DEFAULT '',
  `signup_date` date NOT NULL DEFAULT '0000-00-00',
  `store_id` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `real_name`, `real_surname`, `admin`, `email`, `phone`, `signup_date`, `store_id`) VALUES
(1, 'admin', '0192023A7BBD73250516F069DF18B500', 'Name', 'Surname', 'y', 'admin@store.com', '0123456789', '2011-01-01', 1),
(2, 'user', '6AD14BA9986E3615423DFCA256D04E3F', 'Name', 'Surname', 'n', 'user@store.com', '0123456789', '2011-01-01', 1);
