<?php

require_once "config.php";

function isLoggedin() {
    session_start();
    if(!isset($_SESSION['id']) || (trim($_SESSION['id']) == '')) {
        return false;
    }
    return true;
}

function openHeader($title, $description) {
    return <<<HTML
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8">
		 <link rel="stylesheet" media="screen" href="//netdna.bootstrapcdn.com/bootstrap/3.3.4/css/bootstrap.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <link type="text/css" rel="stylesheet" href="css/theme.css">
        <link type="text/css" rel="stylesheet" href="css/primefaces.css">
        <link type="text/css" rel="stylesheet" href="css/loyalty.css">
        <link type="text/css" rel="stylesheet" href="css/calendar.css"/>
        <script type="text/javascript" src="js/jquery.js"></script>
        <script type="text/javascript" src="js/jquery-plugins.js"></script>
        <script type="text/javascript" src="js/calendar.js"></script>
        <title>$title</title></head>
    <body>
	 <div class="container"> 
HTML;
}

function closeHeader() {
    return <<<HTML
</div></body></html>
HTML;
}

function menu($loggedin = false) {
    $indexUrl = "login.php";
    if($loggedin) {
        $indexUrl = "user-index.php";
    }

    $menu = '
    <div id="landingHeader">
        <table role="grid" style="margin: 0 auto" class="ui-panelgrid ui-widget">
            <tbody>
            <tr role="row" class="ui-widget-content">
                <td role="gridcell"><img style="border: none" src="files/logo.png"></td>
                <td role="gridcell" style="width: 50px;">&nbsp;</td>
                <td role="gridcell"><a class="ui-commandlink ui-widget" href="'.$indexUrl.'"><img style="border: none" src="files/icon_home.png"></a></td>
                <td role="gridcell"><img style="border: none; margin: 0 5px" src="files/img_header_separator.png"></td>';

    if($loggedin) {
        $menu .='   <td role="gridcell"><div class="landingButton"><a class="ui-commandlink ui-widget menuButtonText" href="prices.php" >Προσφορές</a></div></td>
                    <td role="gridcell"><img style="border: none; margin: 0 5px" src="files/img_header_separator.png"></td>
                    <td role="gridcell"><div class="landingButton"><a class="ui-commandlink ui-widget menuButtonText" href="edit-profile.php" >Το προφίλ μου</a></div></td>
                    <td role="gridcell"><img style="border: none; margin: 0 5px" src="files/img_header_separator.png"></td>
                    <td role="gridcell"><div class="landingButton"><a class="ui-commandlink ui-widget menuButtonText" href="transactions.php" >Ιστορικό</a></div></td>
                    <td role="gridcell"><img style="border: none; margin: 0 5px" src="files/img_header_separator.png"></td>
                    <!-- <td role="gridcell"><div class="landingButton"><a class="ui-commandlink ui-widget menuButtonText" href="transaction-code.php" >Καταχώρηση συναλλαγής</a></div></td>-->
                    <td role="gridcell"><img style="border: none; margin: 0 5px" src="files/img_header_separator.png"></td>
                    <td role="gridcell"><div class="landingButton"><a class="ui-commandlink ui-widget menuButtonText" href="logout.php" >Αποσύνδεση</a></div></td>
                    <td role="gridcell"><img style="border: none; margin: 0 5px" src="files/img_header_separator.png"></td>';
    }
    $menu .='
            <td role="gridcell"><div class="landingButton"><a class="ui-commandlink ui-widget menuButtonText" href="info.php" >Πληροφορίες</a></div></td>
            <td role="gridcell"><img style="border: none; margin: 0 5px" src="files/img_header_separator.png"></td>
            <td role="gridcell"><div class="landingButton"><a class="ui-commandlink ui-widget menuButtonText" href="contact.php">Επικοινωνία</a></div></td>';


    $menu .= '</tr>
            </tbody>
        </table>
    </div>';

    return $menu;
}

function footer() {
    return <<<HTML
<div id="footer">
    <table role="grid" style="text-align: center; margin: 0 auto" class="ui-panelgrid ui-widget" id="footerForm:j_idt51">
        <tbody>
        <tr role="row" class="ui-widget-content">
            <td role="gridcell"><span class="footerText">ΟΙΚΟΠΕΤΡΟΛ - Τηλέφωνο: 210 8992557</span>
            </td>
            <td role="gridcell"><img style="border: none; margin: 0 2px" src="files/img_footer_separator.png">
            </td>
            <td role="gridcell"><span class="footerText">Powered by <a class="footerText" href="http://www.newmedia.gr" target="_blank" >New Media</a></span></td>
            <td role="gridcell"><img style="border: none; margin: 0 2px" src="files/img_footer_separator.png">
            </td>
            <td role="gridcell"><a class="footerText" target="_blank" href="https://www.facebook.com/"><img style="border: none" src="files/icon_facebook.png"></a>
            </td>
            <td role="gridcell"><a class="footerText" target="_blank" href="http://www.instagram.com/"><img style="border: none" src="files/icon_instagram.png"></a></td>
            <td role="gridcell"><a class="footerText" target="_blank" href="https://www.twitter.com/"><img style="border: none" src="files/icon_twitter.png"></a>
            </td>
        </tr>
        </tbody>
    </table>
</div>
HTML;
}

function str2num($str){
    if(strpos($str, '.') < strpos($str,',')){
        $str = str_replace('.','',$str);
        $str = strtr($str,',','.');
    }
    else{
        $str = str_replace(',','',$str);
    }
    return (float)$str;
}

