<?php
// Το αρχικό αρχείο με τα defines
$inputFile  = 'en.php';   // ← βάλε εδώ το δικό σου
$outputFile = 'en-clean.php';

if (!file_exists($inputFile)) {
    die("Input file not found: $inputFile\n");
}

$lines = file($inputFile);
$seen  = [];
$out   = [];

foreach ($lines as $line) {
    if (preg_match("/define\(\s*['\"]([^'\"]+)['\"]\s*,/i", $line, $m)) {
        $constName = $m[1];

        // Αν έχει ξαναδηλωθεί, προσπερνάμε τη γραμμή
        if (isset($seen[$constName])) {
            continue;
        }

        $seen[$constName] = true;
    }

    $out[] = $line;
}

file_put_contents($outputFile, $out);

echo "Done. Clean file written to: $outputFile\n";
