<?php
require_once('config.php');

define('CSV_DELIMITER', ';'); // Delimiter used in CSV
define('SKIP_FIRST_CSV_LINE', true); // Skip the first line (header)
define('CALCULATE_POINTS', true); // Enable points calculation
define('USER_ID', 1); // Assign the transaction to a user
define('STORE_ID', 1); // Assign the transaction to a store

$dateNow = date("Y-m-d H:i:s");
$notes = "import csv " . $dateNow;
$services = "";
$giftcardMoney = 0;
$giftcardId = null; // Use null instead of "NULL" for safer handling

// Database connection using mysqli
$mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE);

if ($mysqli->connect_error) {
    die("Database connection failed: " . $mysqli->connect_error);
}

// Set character set to UTF-8
$mysqli->set_charset("utf8");

// Fetch settings
$settings = array();
$settingsResult = $mysqli->query("SELECT setting, value FROM settings");
if ($settingsResult) {
    while ($setting = $settingsResult->fetch_assoc()) {
        if ($setting['setting'] == "visit_points") {
            $settings['SESS_VISIT_POINTS'] = $setting['value'];
        }
        if ($setting['setting'] == "money_points") {
            $settings['SESS_MONEY_POINTS'] = $setting['value'];
        }
    }
} else {
    die("Error fetching settings: " . $mysqli->error);
}

$firstLine = true;
$filePath = IMPORT_CSV_PATH . date("Ymd") . ".csv"; // File path for the CSV file
$counter = 0;

if (file_exists($filePath)) {
    if (($handle = fopen($filePath, "r")) !== false) {
        while (($row = fgetcsv($handle, 0, CSV_DELIMITER)) !== false) {
            if (SKIP_FIRST_CSV_LINE && $firstLine) {
                $firstLine = false;
                continue;
            }

            if (is_array($row) && count($row) == 6) {
                $where = "customer_id";
                if (strlen($row[0]) == 10) {
                    $where = "phone";
                }

                // Use prepared statements for security
                $stmt = $mysqli->prepare("SELECT id FROM customers WHERE $where = ?");
                $stmt->bind_param("s", $row[0]);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows === 0) {
                    echo "Customer " . htmlspecialchars($row[0]) . " not found. Skipping from import.<br>";
                    continue;
                } else {
                    $user = $result->fetch_assoc();
                    $customer_id = $user['id'];
                }

                $money = str_replace(",", ".", $row[1]);
                if (!is_numeric($money)) {
                    echo "Invalid money value for customer " . htmlspecialchars($row[0]) . ". Skipping.<br>";
                    continue;
                }

                $points = 0;
                if (CALCULATE_POINTS) {
                    $points = $money * $settings['SESS_MONEY_POINTS'] + $settings['SESS_VISIT_POINTS'];
                }

                $dateTrans = $row[3] . " 00:00:00";

                // Insert the transaction using prepared statements
                $insertQuery = "INSERT INTO transactions 
                    (customer_auto_id, money, points, date, `by`, store_id, notes, services, giftcard_id, giftcard_money)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                $insertStmt = $mysqli->prepare($insertQuery);
                $insertStmt->bind_param(
                    "iddsisissi",
                    $customer_id,
                    $money,
                    $points,
                    $dateTrans,
                    USER_ID,
                    STORE_ID,
                    $notes,
                    $services,
                    $giftcardId,
                    $giftcardMoney
                );
                $insertStmt->execute();
                $counter++;
            }
        }

        fclose($handle);
        echo "Imported $counter transactions.<br>";
    } else {
        echo "Can't read file.<br>";
    }
} else {
    echo "File not found.<br>";
}

// Close the database connection
$mysqli->close();
